/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public abstract class BreakpointItem
extends ItemWrapper
implements Comparable<BreakpointItem>,
Navigatable {
    public static final Key<Object> EDITOR_ONLY = Key.create((String)"EditorOnly");

    public abstract void saveState();

    public abstract Object getBreakpoint();

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public abstract boolean isDefaultBreakpoint();

    protected static void showInEditor(DetailView panel2, VirtualFile virtualFile, int line) {
        Editor editor;
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
        DetailView.PreviewEditorState state = DetailView.PreviewEditorState.create((VirtualFile)virtualFile, (int)line, (TextAttributes)attributes);
        if (state.equals((Object)panel2.getEditorState())) {
            return;
        }
        panel2.navigateInPreviewEditor(state);
        TextAttributes softerAttributes = attributes.clone();
        Color backgroundColor = softerAttributes.getBackgroundColor();
        if (backgroundColor != null) {
            softerAttributes.setBackgroundColor(ColorUtil.softer((Color)backgroundColor));
        }
        if ((editor = panel2.getEditor()) != null) {
            MarkupModel editorModel = editor.getMarkupModel();
            MarkupModel documentModel = DocumentMarkupModel.forDocument(editor.getDocument(), editor.getProject(), false);
            for (RangeHighlighter highlighter : documentModel.getAllHighlighters()) {
                int line1;
                if (highlighter.getUserData(DebuggerColors.BREAKPOINT_HIGHLIGHTER_KEY) != Boolean.TRUE || (line1 = editor.offsetToLogicalPosition((int)highlighter.getStartOffset()).line) == line) continue;
                editorModel.addLineHighlighter(line1, 3002, softerAttributes);
            }
        }
    }

    public void updateAccessoryView(JComponent component2) {
        JCheckBox checkBox2 = (JCheckBox)component2;
        checkBox2.setSelected(this.isEnabled());
    }

    public void setupRenderer(ColoredListCellRenderer renderer, Project project, boolean selected2) {
        this.setupGenericRenderer((SimpleColoredComponent)renderer, true);
    }

    public void setupRenderer(ColoredTreeCellRenderer renderer, Project project, boolean selected2) {
        boolean plainView = renderer.getTree().getClientProperty("plainView") != null;
        this.setupGenericRenderer((SimpleColoredComponent)renderer, plainView);
    }

    public abstract void setupGenericRenderer(SimpleColoredComponent var1, boolean var2);

    public abstract Icon getIcon();

    public abstract String getDisplayText();

    protected void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BreakpointItem item = (BreakpointItem)o;
        return !(this.getBreakpoint() != null ? !this.getBreakpoint().equals(item.getBreakpoint()) : item.getBreakpoint() != null);
    }

    public int hashCode() {
        return this.getBreakpoint() != null ? this.getBreakpoint().hashCode() : 0;
    }
}

