/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpMatchResult;
import org.intellij.lang.regexp.RegExpMatcherProvider;
import org.intellij.lang.regexp.RegExpModifierProvider;
import org.jetbrains.annotations.NotNull;

public class CheckRegExpForm {
    public static final Key<Boolean> CHECK_REG_EXP_EDITOR = Key.create((String)"CHECK_REG_EXP_EDITOR");
    private static final String LAST_EDITED_REGEXP = "last.edited.regexp";
    private static final JBColor BACKGROUND_COLOR_MATCH = new JBColor(15203035, 0x445542);
    private static final JBColor BACKGROUND_COLOR_NOMATCH = new JBColor(16757152, 7220008);
    private final PsiFile myRegexpFile;
    private EditorTextField mySampleText;
    private EditorTextField myRegExp;
    private JPanel myRootPanel;
    private JBLabel myMessage;
    private Project myProject;

    public CheckRegExpForm(@NotNull PsiFile regexpFile) {
        if (regexpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(0);
        }
        this.myRegexpFile = regexpFile;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.myProject = this.myRegexpFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myRegexpFile);
        Language language = this.myRegexpFile.getLanguage();
        Object fileType = language instanceof RegExpLanguage ? RegExpLanguage.INSTANCE.getAssociatedFileType() : new RegExpFileType(language);
        this.myRegExp = new EditorTextField(document, this.myProject, (FileType)fileType, false, false){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.putUserData(CHECK_REG_EXP_EDITOR, Boolean.TRUE);
                editor.setEmbeddedIntoDialogWrapper(true);
                return editor;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/lang/regexp/intention/CheckRegExpForm$1", "updateBorder"));
            }
        };
        String sampleText = PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_EDITED_REGEXP, "Sample Text");
        this.mySampleText = new EditorTextField(sampleText, this.myProject, (FileType)PlainTextFileType.INSTANCE){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setEmbeddedIntoDialogWrapper(true);
                return editor;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/lang/regexp/intention/CheckRegExpForm$2", "updateBorder"));
            }
        };
        this.mySampleText.setOneLineMode(false);
        int preferredWidth = Math.max(JBUIScale.scale((int)250), this.myRegExp.getPreferredSize().width);
        this.myRegExp.setPreferredWidth(preferredWidth);
        this.mySampleText.setPreferredWidth(preferredWidth);
        this.myRootPanel = new JPanel(new BorderLayout()){
            Disposable disposable;
            Alarm updater;

            @Override
            public void addNotify() {
                super.addNotify();
                this.disposable = Disposer.newDisposable();
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)CheckRegExpForm.this.mySampleText), true);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.myRegExp), "shift TAB", CheckRegExpForm.this.mySampleText);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.myRegExp), "TAB", CheckRegExpForm.this.mySampleText);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.mySampleText), "shift TAB", CheckRegExpForm.this.myRegExp);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.mySampleText), "TAB", CheckRegExpForm.this.myRegExp);
                this.updater = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
                DocumentListener documentListener = new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.update();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/regexp/intention/CheckRegExpForm$3$1", "documentChanged"));
                    }
                };
                CheckRegExpForm.this.myRegExp.addDocumentListener(documentListener);
                CheckRegExpForm.this.mySampleText.addDocumentListener(documentListener);
                this.update();
                CheckRegExpForm.this.mySampleText.selectAll();
            }

            private void registerFocusShortcut(JComponent source, String shortcut, final EditorTextField target2) {
                AnAction action2 = new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        IdeFocusManager.findInstance().requestFocus((Component)target2.getFocusTarget(), true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/regexp/intention/CheckRegExpForm$3$2", "actionPerformed"));
                    }
                };
                action2.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{shortcut}), source);
            }

            private void update() {
                this.updater.cancelAllRequests();
                if (!this.updater.isDisposed()) {
                    this.updater.addRequest(() -> {
                        RegExpMatchResult result2 = CheckRegExpForm.isMatchingText(CheckRegExpForm.this.myRegexpFile, CheckRegExpForm.this.myRegExp.getText(), CheckRegExpForm.this.mySampleText.getText());
                        ApplicationManager.getApplication().invokeLater(() -> CheckRegExpForm.this.setBalloonState(result2), ModalityState.any(), __ -> this.updater.isDisposed());
                    }, 0);
                }
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)this.disposable);
                PropertiesComponent.getInstance((Project)CheckRegExpForm.this.myProject).setValue(CheckRegExpForm.LAST_EDITED_REGEXP, CheckRegExpForm.this.mySampleText.getText());
            }
        };
        this.myRootPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
    }

    void setBalloonState(RegExpMatchResult result2) {
        this.mySampleText.setBackground((Color)(result2 == RegExpMatchResult.MATCHES ? BACKGROUND_COLOR_MATCH : BACKGROUND_COLOR_NOMATCH));
        switch (result2) {
            case MATCHES: {
                this.myMessage.setText("Matches!");
                break;
            }
            case NO_MATCH: {
                this.myMessage.setText("No match");
                break;
            }
            case TIMEOUT: {
                this.myMessage.setText("Pattern is too complex");
                break;
            }
            case BAD_REGEXP: {
                this.myMessage.setText("Bad pattern");
                break;
            }
            case INCOMPLETE: {
                this.myMessage.setText("More input expected");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.myRootPanel.revalidate();
        Balloon balloon = JBPopupFactory.getInstance().getParentBalloonFor((Component)this.myRootPanel);
        if (balloon != null && !balloon.isDisposed()) {
            balloon.revalidate();
        }
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.mySampleText;
        if (editorTextField == null) {
            CheckRegExpForm.$$$reportNull$$$0(1);
        }
        return editorTextField;
    }

    @NotNull
    public JPanel getRootPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            CheckRegExpForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public static boolean isMatchingTextTest(@NotNull PsiFile regexpFile, @NotNull String sampleText) {
        if (regexpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(3);
        }
        if (sampleText == null) {
            CheckRegExpForm.$$$reportNull$$$0(4);
        }
        return CheckRegExpForm.isMatchingText(regexpFile, regexpFile.getText(), sampleText) == RegExpMatchResult.MATCHES;
    }

    static RegExpMatchResult isMatchingText(@NotNull PsiFile regexpFile, String regexpText, @NotNull String sampleText) {
        RegExpMatchResult result2;
        Language regexpFileLanguage;
        RegExpMatcherProvider matcherProvider;
        if (regexpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(5);
        }
        if (sampleText == null) {
            CheckRegExpForm.$$$reportNull$$$0(6);
        }
        if ((matcherProvider = (RegExpMatcherProvider)RegExpMatcherProvider.EP.forLanguage(regexpFileLanguage = regexpFile.getLanguage())) != null && (result2 = (RegExpMatchResult)((Object)ReadAction.compute(() -> {
            PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)regexpFile);
            if (host != null) {
                return matcherProvider.matches(regexpText, regexpFile, (PsiElement)host, sampleText, 1000L);
            }
            return null;
        }))) != null) {
            return result2;
        }
        Integer patternFlags = (Integer)ReadAction.compute(() -> {
            int flags;
            block1: {
                RegExpModifierProvider provider;
                PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)regexpFile);
                flags = 0;
                if (host == null) break block1;
                Iterator iterator2 = RegExpModifierProvider.EP.allForLanguage(host.getLanguage()).iterator();
                while (iterator2.hasNext() && (flags = (provider = (RegExpModifierProvider)iterator2.next()).getFlags((PsiElement)host, regexpFile)) <= 0) {
                }
            }
            return flags;
        });
        try {
            Matcher matcher = Pattern.compile(regexpText, patternFlags).matcher(StringUtil.newBombedCharSequence((CharSequence)sampleText, (long)1000L));
            if (matcher.matches()) {
                return RegExpMatchResult.MATCHES;
            }
            if (matcher.hitEnd()) {
                return RegExpMatchResult.INCOMPLETE;
            }
            return RegExpMatchResult.NO_MATCH;
        }
        catch (ProcessCanceledException ignore) {
            return RegExpMatchResult.TIMEOUT;
        }
        catch (Exception exception) {
            return RegExpMatchResult.BAD_REGEXP;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        this.createUIComponents();
        JPanel jPanel = this.myRootPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMessage = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("Red means I can't hear you!");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 2, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(55, 16));
        jLabel.setText("RegExp:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(new Dimension(55, 16));
        jLabel2.setText("Sample:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myRegExp;
        jPanel.add((Component)((Object)editorTextField), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        EditorTextField editorTextField2 = this.mySampleText;
        jPanel.add((Component)((Object)editorTextField2), new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexpFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/intention/CheckRegExpForm";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/intention/CheckRegExpForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingTextTest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

