/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.NetUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.ide.BuiltInServerBundle;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!\u001a*\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020+\u001a\u0010\u0010*\u001a\u0004\u0018\u00010-2\u0006\u0010,\u001a\u00020-\u001a\b\u0010.\u001a\u00020\u001cH\u0000\u001a\u0010\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u0001H\u0000\u001a\b\u00101\u001a\u00020\u0001H\u0002\u001a\u001a\u00102\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u00012\u0006\u00104\u001a\u000205H\u0002\u001a \u00106\u001a\u0004\u0018\u0001072\u0006\u0010%\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001c\u001a\n\u0010;\u001a\u00020\u001c*\u000208\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\"\u000e\u0010\r\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0011\u0010\u0012\"\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0016\u0010\u0017\"N\u0010\u0019\u001aB\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001c0\u001c \u001b* \u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"IDE_TOKEN_FILE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "STANDARD_COOKIE", "Lio/netty/handler/codec/http/cookie/DefaultCookie;", "getSTANDARD_COOKIE", "()Lio/netty/handler/codec/http/cookie/DefaultCookie;", "STANDARD_COOKIE$delegate", "Lkotlin/Lazy;", "TOKEN_HEADER_NAME", "TOKEN_PARAM_NAME", "notificationManager", "Lcom/intellij/notification/SingletonNotificationManager;", "getNotificationManager", "()Lcom/intellij/notification/SingletonNotificationManager;", "notificationManager$delegate", "secureRandom", "Ljava/security/SecureRandom;", "getSecureRandom", "()Ljava/security/SecureRandom;", "secureRandom$delegate", "tokens", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "", "acquireToken", "compareNameAndProjectBasePath", "projectName", "project", "Lcom/intellij/openapi/project/Project;", "doProcess", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectNameAsHost", "findIndexFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basedir", "Ljava/nio/file/Path;", "isActivatable", "isOwnHostName", "host", "randomToken", "toIdeaPath", "decodedPath", "offset", "", "validateToken", "Lio/netty/handler/codec/http/HttpHeaders;", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "isSignedRequest", "intellij.platform.builtInServer.impl"})
public final class BuiltInWebServerKt {
    @NotNull
    private static final Logger LOG;
    private static final String IDE_TOKEN_FILE = "user.web.token";
    private static final Lazy notificationManager$delegate;
    @NotNull
    public static final String TOKEN_PARAM_NAME = "_ijt";
    @NotNull
    public static final String TOKEN_HEADER_NAME = "x-ijt";
    private static final Lazy STANDARD_COOKIE$delegate;
    private static final Cache<String, Boolean> tokens;
    private static final Lazy secureRandom$delegate;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final SingletonNotificationManager getNotificationManager() {
        Lazy lazy = notificationManager$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (SingletonNotificationManager)lazy.getValue();
    }

    public static final boolean isActivatable() {
        return Registry.is((String)"ide.built.in.web.server.activatable", (boolean)false);
    }

    private static final DefaultCookie getSTANDARD_COOKIE() {
        Lazy lazy = STANDARD_COOKIE$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (DefaultCookie)lazy.getValue();
    }

    private static final SecureRandom getSecureRandom() {
        Lazy lazy = secureRandom$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (SecureRandom)lazy.getValue();
    }

    @NotNull
    public static final String acquireToken() {
        String token = (String)CollectionsKt.firstOrNull((Iterable)tokens.asMap().keySet());
        if (token == null) {
            token = BuiltInWebServerKt.randomToken();
            tokens.put((Object)token, (Object)Boolean.TRUE);
        }
        return token;
    }

    private static final String randomToken() {
        String string = new BigInteger(130, BuiltInWebServerKt.getSecureRandom()).toString(32);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BigInteger(130, secureRandom).toString(32)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean doProcess(QueryStringDecoder urlDecoder, FullHttpRequest request, ChannelHandlerContext context, String projectNameAsHost) {
        block18: {
            decodedPath = urlDecoder.path();
            offset = new Ref.IntRef();
            isEmptyPath = new Ref.BooleanRef();
            isCustomHost = projectNameAsHost != null;
            projectName = new Ref.ObjectRef();
            if (isCustomHost) {
                v0 = projectNameAsHost;
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                projectName.element = v0;
                offset.element = 0;
                v1 = decodedPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"decodedPath");
                var9_9 = v1;
                var21_10 = isEmptyPath;
                var10_11 = 0;
                var21_10.element = var22_13 = var9_9.length() == 0;
            } else {
                v2 = decodedPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"decodedPath");
                offset.element = StringsKt.indexOf$default((CharSequence)v2, (char)'/', (int)1, (boolean)false, (int)4, null);
                var9_9 = decodedPath;
                var10_11 = 1;
                var11_15 = offset.element == -1 ? decodedPath.length() : offset.element;
                var21_10 = projectName;
                var12_17 = false;
                v3 = var9_9.substring(var10_11, var11_15);
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                var22_14 = v3;
                var21_10.element = var22_14;
                isEmptyPath.element = offset.element == -1;
            }
            candidateByDirectoryName = null;
            v4 = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"ProjectManager.getInstance()");
            v5 = v4.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"ProjectManager.getInstance().openProjects");
            $this$firstOrNull$iv = v5;
            $i$f$firstOrNull = false;
            var13_19 = $this$firstOrNull$iv;
            var14_20 = var13_19.length;
            for (var15_22 = 0; var15_22 < var14_20; ++var15_22) {
                block20: {
                    block21: {
                        block19: {
                            project = element$iv = var13_19[var15_22];
                            $i$a$-firstOrNull-BuiltInWebServerKt$doProcess$project$1 = false;
                            if (!project.isDisposed()) break block19;
                            v6 = false;
                            break block20;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)project.getName(), (String)"project.name");
                        if (!isCustomHost) break block21;
                        if (!StringsKt.equals((String)((String)projectName.element), (String)name, (boolean)true)) ** GOTO lbl-1000
                        if (!SystemInfo.isFileSystemCaseSensitive) {
                            projectName.element = name;
                        }
                        v6 = true;
                        break block20;
                    }
                    if (!StringsKt.regionMatches((String)decodedPath, (int)1, (String)name, (int)0, (int)name.length(), (boolean)(SystemInfo.isFileSystemCaseSensitive == false))) ** GOTO lbl-1000
                    v7 = isEmptyPathCandidate = decodedPath.length() == name.length() + 1;
                    if (isEmptyPathCandidate || decodedPath.charAt(name.length() + 1) == '/') {
                        projectName.element = name;
                        offset.element = name.length() + 1;
                        isEmptyPath.element = isEmptyPathCandidate;
                        v6 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if (candidateByDirectoryName == null && BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName.element, project)) {
                            candidateByDirectoryName = project;
                        }
                        v6 = false;
                    }
                }
                if (!v6) continue;
                v8 = element$iv;
                break block18;
            }
            v8 = v9 = null;
        }
        if (v8 == null) {
            v9 = candidateByDirectoryName;
        }
        if (v9 == null) {
            return false;
        }
        project = v9;
        if (BuiltInWebServerKt.isActivatable() && !PropertiesComponent.getInstance().getBoolean("ide.built.in.web.server.active")) {
            v10 = BuiltInWebServerKt.getNotificationManager();
            v11 = BuiltInServerBundle.message((String)"notification.content.built.in.web.server.is.deactivated", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"BuiltInServerBundle.mess\u2026b.server.is.deactivated\")");
            v10.notify(v11, (Project)null);
            return false;
        }
        if (isEmptyPath.element) {
            v12 = (HttpRequest)request;
            v13 = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"context.channel()");
            WebServerPathHandlerKt.redirectToDirectory(v12, v13, (String)projectName.element, null);
            return true;
        }
        path = BuiltInWebServerKt.toIdeaPath(decodedPath, offset.element);
        if (path == null) {
            v14 = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"HttpResponseStatus.BAD_REQUEST");
            v15 = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"HttpResponseStatus.NOT_FOUND");
            v16 = Responses.orInSafeMode((HttpResponseStatus)v14, (HttpResponseStatus)v15);
            v17 = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"context.channel()");
            Responses.send$default((HttpResponseStatus)v16, (Channel)v17, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        for (WebServerPathHandler pathHandler : WebServerPathHandler.Companion.getEP_NAME$intellij_platform_builtInServer_impl().getExtensionList()) {
            $this$runAndLogException$iv = BuiltInWebServerKt.LOG;
            $i$f$runAndLogException = false;
            try {
                $i$a$-runAndLogException-BuiltInWebServerKt$doProcess$1 = false;
                if (!pathHandler.process(path, project, request, context, (String)projectName.element, decodedPath, isCustomHost)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (CancellationException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (Throwable e$iv) {
                $this$runAndLogException$iv.error(e$iv);
            }
        }
        return false;
    }

    public static final boolean isSignedRequest(@NotNull HttpRequest $this$isSignedRequest) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$isSignedRequest, (String)"$this$isSignedRequest");
        if (BuiltInServerOptions.getInstance().allowUnsignedRequests) {
            return true;
        }
        String string2 = $this$isSignedRequest.headers().get(TOKEN_HEADER_NAME);
        if (string2 == null) {
            List list2 = (List)new QueryStringDecoder($this$isSignedRequest.uri()).parameters().get(TOKEN_PARAM_NAME);
            string2 = string = list2 != null ? (String)CollectionsKt.firstOrNull((List)list2) : null;
        }
        if (string2 == null) {
            String string3 = NettyKt.getReferrer((HttpRequest)$this$isSignedRequest);
            if (string3 != null) {
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                List list3 = (List)new QueryStringDecoder(it).parameters().get(TOKEN_PARAM_NAME);
                string = list3 != null ? (String)CollectionsKt.firstOrNull((List)list3) : null;
            } else {
                string = null;
            }
        }
        String token = string;
        return token != null && tokens.getIfPresent((Object)token) != null;
    }

    @Nullable
    public static final HttpHeaders validateToken(@NotNull HttpRequest request2, @NotNull Channel channel, boolean isSignedRequest) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        if (BuiltInServerOptions.getInstance().allowUnsignedRequests) {
            return (HttpHeaders)EmptyHttpHeaders.INSTANCE;
        }
        String string = request2.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            for (Cookie cookie : ServerCookieDecoder.STRICT.decode(it)) {
                if (!Intrinsics.areEqual((Object)cookie.name(), (Object)BuiltInWebServerKt.getSTANDARD_COOKIE().name())) continue;
                if (!Intrinsics.areEqual((Object)cookie.value(), (Object)BuiltInWebServerKt.getSTANDARD_COOKIE().value())) break;
                return (HttpHeaders)EmptyHttpHeaders.INSTANCE;
            }
        }
        if (isSignedRequest) {
            return new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)(ServerCookieEncoder.STRICT.encode((Cookie)BuiltInWebServerKt.getSTANDARD_COOKIE()) + "; SameSite=strict"));
        }
        QueryStringDecoder urlDecoder = new QueryStringDecoder(request2.uri());
        String string3 = urlDecoder.path();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"urlDecoder.path()");
        if (!StringsKt.endsWith$default((String)string3, (String)"/favicon.ico", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append(NettyKt.getUriScheme((Channel)channel)).append("://");
            String string4 = NettyKt.getHost((HttpRequest)request2);
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            String url = stringBuilder.append(string4).append(urlDecoder.path()).toString();
            SwingUtilities.invokeAndWait(new Runnable(url){
                final /* synthetic */ String $url;

                public final void run() {
                    ProjectUtil.focusProjectWindow(null, true);
                    if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"", (String)BuiltInServerBundle.message((String)"dialog.message.page", (Object[])new Object[]{StringUtil.trimMiddle((String)this.$url, (int)50)})).icon(Messages.getWarningIcon())).yesText(BuiltInServerBundle.message((String)"dialog.button.copy.authorization.url.to.clipboard", (Object[])new Object[0]))).show() == 0) {
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.$url + "?" + "_ijt" + "=" + BuiltInWebServerKt.acquireToken()));
                    }
                }
                {
                    this.$url = string;
                }
            });
        }
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.UNAUTHORIZED;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.UNAUTHORIZED");
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.NOT_FOUND;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus2, (String)"HttpResponseStatus.NOT_FOUND");
        Responses.send$default((HttpResponseStatus)Responses.orInSafeMode((HttpResponseStatus)httpResponseStatus, (HttpResponseStatus)httpResponseStatus2), (Channel)channel, (HttpRequest)request2, null, null, (int)12, null);
        return null;
    }

    private static final String toIdeaPath(String decodedPath, int offset) {
        String string = decodedPath;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String path = string3;
        if (!StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
            return null;
        }
        String string4 = FileUtil.toCanonicalPath((String)path, (char)'/');
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"FileUtil.toCanonicalPath(path, '/')");
        string = string4;
        n = 1;
        boolean bl = false;
        String string5 = string;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        return string6;
    }

    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String basePath = project.getBasePath();
        return basePath != null && FileUtilKt.endsWithName(basePath, projectName);
    }

    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        VirtualFile[] children2;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
                children2 = basedir.getChildren();
                if (children2 == null) break block6;
                VirtualFile[] virtualFileArray = children2;
                int n = 0;
                if (!(virtualFileArray.length == 0)) break block7;
            }
            return null;
        }
        for (String indexNamePrefix : new String[]{"index.", "default."}) {
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            VirtualFile[] virtualFileArray = children2;
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                String name;
                VirtualFile child2;
                VirtualFile virtualFile = child2 = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"child");
                if (virtualFile.isDirectory()) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)child2.getName(), (String)"child.name");
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child2;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child2;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final Path findIndexFile(@NotNull Path basedir) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
        Path path = basedir;
        Function1 filter$iv = findIndexFile.children.1.INSTANCE;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
            });
            boolean bl = false;
            Throwable throwable = null;
            try {
                Iterable it = (DirectoryStream)closeable;
                boolean bl2 = false;
                it = CollectionsKt.toList((Iterable)it);
                iterable = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            iterable = null;
        }
        if (iterable == null) {
            return null;
        }
        Iterable children2 = iterable;
        for (String indexNamePrefix : new String[]{"index.", "default."}) {
            Path index = null;
            String preferredName = indexNamePrefix + "html";
            Iterator iterator2 = children2.iterator();
            while (iterator2.hasNext()) {
                Path child2;
                Path path2 = child2 = (Path)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"child");
                if (PathKt.isDirectory((Path)path2)) continue;
                String name = ((Object)child2.getFileName()).toString();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child2;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child2;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOwnHostName(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address;
            InetAddress inetAddress = address = InetAddress.getByName(host);
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"address");
            if (Intrinsics.areEqual((Object)host, (Object)inetAddress.getHostAddress())) return true;
            if (StringsKt.equals((String)host, (String)address.getCanonicalHostName(), (boolean)true)) {
                return true;
            }
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress2, (String)"InetAddress.getLocalHost()");
            String localHostName = inetAddress2.getHostName();
            if (StringsKt.equals((String)localHostName, (String)host, (boolean)true)) return true;
            if (!StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2, null)) return false;
            String string = localHostName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localHostName");
            if (!StringsKt.regionMatches((String)string, (int)0, (String)host, (int)0, (int)(host.length() - ".local".length()), (boolean)true)) return false;
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuiltInWebServer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        notificationManager$delegate = LazyKt.lazy((Function0)notificationManager.2.INSTANCE);
        STANDARD_COOKIE$delegate = LazyKt.lazy((Function0)STANDARD_COOKIE.2.INSTANCE);
        tokens = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        secureRandom$delegate = LazyKt.lazy((Function0)secureRandom.2.INSTANCE);
    }

    public static final /* synthetic */ boolean access$doProcess(QueryStringDecoder urlDecoder, FullHttpRequest request2, ChannelHandlerContext context, String projectNameAsHost) {
        return BuiltInWebServerKt.doProcess(urlDecoder, request2, context, projectNameAsHost);
    }
}

