/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XsContentDFA
extends XmlContentDFA {
    private final XSCMValidator myContentModel;
    private final SubstitutionGroupHandler myHandler;
    private final int[] myState;
    private final XmlElementDescriptor[] myElementDescriptors;

    @Nullable
    public static XmlContentDFA createContentDFA(@NotNull XmlTag parentTag) {
        PsiFile file;
        if (parentTag == null) {
            XsContentDFA.$$$reportNull$$$0(0);
        }
        if (!((file = parentTag.getContainingFile().getOriginalFile()) instanceof XmlFile)) {
            return null;
        }
        XSModel xsModel = (XSModel)ReadAction.compute(() -> XsContentDFA.getXSModel((XmlFile)file));
        if (xsModel == null) {
            return null;
        }
        XSElementDeclaration decl = XsContentDFA.getElementDeclaration(parentTag, xsModel);
        if (decl == null) {
            return null;
        }
        return new XsContentDFA(decl, parentTag);
    }

    XsContentDFA(@NotNull XSElementDeclaration decl, XmlTag parentTag) {
        if (decl == null) {
            XsContentDFA.$$$reportNull$$$0(1);
        }
        XSComplexTypeDecl definition = (XSComplexTypeDecl)decl.getTypeDefinition();
        this.myContentModel = definition.getContentModel(new CMBuilder(new CMNodeFactory()));
        this.myHandler = new SubstitutionGroupHandler((XSElementDeclHelper)new MyXSElementDeclHelper());
        this.myState = this.myContentModel.startContentModel();
        this.myElementDescriptors = (XmlElementDescriptor[])ReadAction.compute(() -> {
            XmlElementDescriptor parentTagDescriptor = parentTag.getDescriptor();
            assert (parentTagDescriptor != null);
            return parentTagDescriptor.getElementsDescriptors(parentTag);
        });
    }

    @Override
    public List<XmlElementDescriptor> getPossibleElements() {
        Vector vector = this.myContentModel.whatCanGoHere(this.myState);
        ArrayList<XmlElementDescriptor> list = new ArrayList<XmlElementDescriptor>();
        for (Object o : vector) {
            if (!(o instanceof XSElementDecl)) continue;
            XSElementDecl elementDecl = (XSElementDecl)o;
            XmlElementDescriptor descriptor = (XmlElementDescriptor)ContainerUtil.find((Object[])this.myElementDescriptors, elementDescriptor -> elementDecl.getName().equals(elementDescriptor.getName()));
            ContainerUtil.addIfNotNull(list, (Object)descriptor);
        }
        return list;
    }

    @Override
    public void transition(XmlTag xmlTag) {
        this.myContentModel.oneTransition(XsContentDFA.createQName(xmlTag), this.myState, this.myHandler);
    }

    private static QName createQName(XmlTag tag) {
        String namespace = tag.getNamespace();
        return new QName(tag.getNamespacePrefix().intern(), tag.getLocalName().intern(), tag.getName().intern(), namespace.isEmpty() ? null : namespace.intern());
    }

    @Nullable
    private static XSElementDeclaration getElementDeclaration(XmlTag tag, XSModel xsModel) {
        ArrayList<XmlTag> ancestors = new ArrayList<XmlTag>();
        for (XmlTag t = tag; t != null; t = t.getParentTag()) {
            ancestors.add(t);
        }
        Collections.reverse(ancestors);
        XSElementDeclaration declaration = null;
        SubstitutionGroupHandler fSubGroupHandler = new SubstitutionGroupHandler((XSElementDeclHelper)new MyXSElementDeclHelper());
        CMBuilder cmBuilder = new CMBuilder(new CMNodeFactory());
        block1: for (XmlTag ancestor : ancestors) {
            if (declaration == null) {
                declaration = xsModel.getElementDeclaration(ancestor.getLocalName(), ancestor.getNamespace());
                if (declaration != null) continue;
                return null;
            }
            XSTypeDefinition typeDefinition = declaration.getTypeDefinition();
            if (!(typeDefinition instanceof XSComplexTypeDecl)) {
                return null;
            }
            XSCMValidator model = ((XSComplexTypeDecl)typeDefinition).getContentModel(cmBuilder);
            int[] ints = model.startContentModel();
            for (XmlTag subTag : ancestor.getParentTag().getSubTags()) {
                QName qName = XsContentDFA.createQName(subTag);
                Object o = model.oneTransition(qName, ints, fSubGroupHandler);
                if (subTag != ancestor) continue;
                if (o instanceof XSElementDecl) {
                    declaration = (XSElementDecl)o;
                    continue block1;
                }
                return null;
            }
        }
        return declaration;
    }

    @Nullable
    private static XSModel getXSModel(XmlFile file) {
        ValidateXmlActionHandler handler = new ValidateXmlActionHandler(false){

            @Override
            protected SAXParser createParser() throws SAXException, ParserConfigurationException {
                SAXParser parser = super.createParser();
                if (parser != null) {
                    parser.getXMLReader().setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                }
                return parser;
            }
        };
        handler.setErrorReporter(new ErrorReporter(handler){
            int count;

            @Override
            public void processError(SAXParseException ex, ValidateXmlActionHandler.ProblemType warning) throws SAXException {
                if (warning != ValidateXmlActionHandler.ProblemType.WARNING && this.count++ > 100) {
                    throw new SAXException(ex);
                }
            }

            @Override
            public boolean isUniqueProblem(SAXParseException e) {
                return true;
            }
        });
        handler.doValidate(file);
        XMLGrammarPool grammarPool = ValidateXmlActionHandler.getGrammarPool(file);
        if (grammarPool == null) {
            return null;
        }
        Object[] grammars = grammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        return grammars.length == 0 ? null : ((XSGrammar)grammars[0]).toXSModel((XSGrammar[])ContainerUtil.map((Object[])grammars, grammar -> (XSGrammar)grammar, (Object[])new XSGrammar[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/xml/XsContentDFA";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createContentDFA";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyXSElementDeclHelper
    implements XSElementDeclHelper {
        private final XSGrammarBucket myBucket = new XSGrammarBucket();

        private MyXSElementDeclHelper() {
        }

        public XSElementDecl getGlobalElementDecl(QName name) {
            SchemaGrammar grammar = this.myBucket.getGrammar(name.uri);
            return grammar == null ? null : grammar.getGlobalElementDecl(name.localpart, name.prefix);
        }
    }
}

