/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.AuthenticationProvider;
import org.jetbrains.idea.svn.auth.ProxySvnAuthentication;

public class SvnAuthenticationManager {
    public static final String PASSWORD = "svn.simple";
    public static final String SSL = "svn.ssl.client-passphrase";
    public static final String SVN_SSH = "svn+ssh";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    private SvnVcs myVcs;
    private Project myProject;
    @NotNull
    private final Path myConfigDirectory;
    private final NotNullLazyValue<Couple<IdeaSVNConfigFile>> myConfigFile;
    private final NotNullLazyValue<Couple<IdeaSVNConfigFile>> myServersFile;
    private SvnConfiguration myConfig;
    private AuthenticationProvider myProvider;
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;

    public SvnAuthenticationManager(@NotNull SvnVcs vcs, @NotNull Path configDirectory) {
        if (vcs == null) {
            SvnAuthenticationManager.$$$reportNull$$$0(0);
        }
        if (configDirectory == null) {
            SvnAuthenticationManager.$$$reportNull$$$0(1);
        }
        this.myConfigFile = new NotNullLazyValue<Couple<IdeaSVNConfigFile>>(){

            @NotNull
            protected Couple<IdeaSVNConfigFile> compute() {
                IdeaSVNConfigFile userConfig = new IdeaSVNConfigFile(SvnAuthenticationManager.this.myConfigDirectory.resolve("config"));
                IdeaSVNConfigFile systemConfig = new IdeaSVNConfigFile(((Path)SvnUtil.SYSTEM_CONFIGURATION_PATH.getValue()).resolve("config"));
                Couple couple = Couple.of((Object)systemConfig, (Object)userConfig);
                if (couple == null) {
                    1.$$$reportNull$$$0(0);
                }
                return couple;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/SvnAuthenticationManager$1", "compute"));
            }
        };
        this.myServersFile = new NotNullLazyValue<Couple<IdeaSVNConfigFile>>(){

            @NotNull
            protected Couple<IdeaSVNConfigFile> compute() {
                IdeaSVNConfigFile userConfig = new IdeaSVNConfigFile(SvnAuthenticationManager.this.myConfigDirectory.resolve("servers"));
                IdeaSVNConfigFile systemConfig = new IdeaSVNConfigFile(((Path)SvnUtil.SYSTEM_CONFIGURATION_PATH.getValue()).resolve("servers"));
                Couple couple = Couple.of((Object)systemConfig, (Object)userConfig);
                if (couple == null) {
                    2.$$$reportNull$$$0(0);
                }
                return couple;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/SvnAuthenticationManager$2", "compute"));
            }
        };
        this.myVcs = vcs;
        this.myProject = this.myVcs.getProject();
        this.myConfigDirectory = configDirectory;
        this.myConfig = this.myVcs.getSvnConfiguration();
        Disposer.register((Disposable)this.myProject, () -> {
            this.myVcs = null;
            this.myProject = null;
            if (this.myConfig != null) {
                this.myConfig.clear();
                this.myConfig = null;
            }
        });
    }

    public AuthenticationData requestFromCache(String kind, String realm) {
        return (AuthenticationData)SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(kind, realm);
    }

    public String getDefaultUsername() {
        return SystemProperties.getUserName();
    }

    public void setAuthenticationProvider(AuthenticationProvider provider) {
        this.myProvider = provider;
    }

    public AuthenticationProvider getProvider() {
        return this.myProvider;
    }

    private SvnConfiguration getConfig() {
        if (this.myConfig == null) {
            throw new ProcessCanceledException();
        }
        return this.myConfig;
    }

    @NotNull
    public HostOptions getHostOptions(@NotNull Url url) {
        if (url == null) {
            SvnAuthenticationManager.$$$reportNull$$$0(2);
        }
        return new HostOptions(url);
    }

    public void acknowledgeAuthentication(String kind, Url url, String realm, AuthenticationData authentication) {
        boolean authStorageEnabled = this.getHostOptions(url).isAuthStorageEnabled();
        AuthenticationData proxy = ProxySvnAuthentication.proxy(authentication, authStorageEnabled);
        this.getConfig().acknowledge(kind, realm, proxy);
    }

    public int getReadTimeout(@NotNull Url url) {
        String protocol;
        if (url == null) {
            SvnAuthenticationManager.$$$reportNull$$$0(3);
        }
        if (HTTP.equals(protocol = url.getProtocol()) || HTTPS.equals(protocol)) {
            String host = url.getHost();
            String timeout = IdeaSVNConfigFile.getPropertyIdea(host, (Couple<IdeaSVNConfigFile>)((Couple)this.myServersFile.getValue()), "http-timeout");
            if (timeout != null) {
                try {
                    return Integer.parseInt(timeout) * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 30000;
        }
        if (SVN_SSH.equals(protocol)) {
            return (int)this.getConfig().getSshReadTimeout();
        }
        return 0;
    }

    public int getConnectTimeout(@NotNull Url url) {
        String protocol;
        if (url == null) {
            SvnAuthenticationManager.$$$reportNull$$$0(4);
        }
        if (SVN_SSH.equals(protocol = url.getProtocol())) {
            return (int)this.getConfig().getSshConnectionTimeout();
        }
        return HTTP.equals(protocol) || HTTPS.equals(protocol) ? 60000 : 0;
    }

    public void warnOnAuthStorageDisabled() {
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)"Cannot store credentials: forbidden by \"store-auth-creds=no\"", (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDirectory";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/auth/SvnAuthenticationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHostOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getReadTimeout";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getConnectTimeout";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class HostOptions {
        @NotNull
        private final Url myUrl;

        private HostOptions(Url url) {
            if (url == null) {
                HostOptions.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
        }

        public boolean isAuthStorageEnabled() {
            boolean storageEnabled;
            String perHostValue = IdeaSVNConfigFile.getPropertyIdea(this.myUrl.getHost(), (Couple<IdeaSVNConfigFile>)((Couple)SvnAuthenticationManager.this.myServersFile.getValue()), "store-auth-creds");
            boolean bl = storageEnabled = perHostValue != null ? IdeaSVNConfigFile.isTurned(perHostValue) : IdeaSVNConfigFile.isTurned(IdeaSVNConfigFile.getValue((Couple<IdeaSVNConfigFile>)((Couple)SvnAuthenticationManager.this.myConfigFile.getValue()), "auth", "store-auth-creds"));
            if (!storageEnabled) {
                SvnAuthenticationManager.this.warnOnAuthStorageDisabled();
            }
            return storageEnabled;
        }

        @Nullable
        public String getSSLClientCertFile() {
            return IdeaSVNConfigFile.getPropertyIdea(this.myUrl.getHost(), (Couple<IdeaSVNConfigFile>)((Couple)SvnAuthenticationManager.this.myServersFile.getValue()), "ssl-client-cert-file");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/auth/SvnAuthenticationManager$HostOptions", "<init>"));
        }
    }
}

