/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.intellij.internal.statistic.eventLog.validator.persistence.WhitelistPathSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EventLogWhitelist", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class EventLogWhitelistSettingsPersistence
implements PersistentStateComponent<Element> {
    public static final String USAGE_STATISTICS_XML = "usage.statistics.xml";
    private final Map<String, Long> myLastModifications = new HashMap<String, Long>();
    private final Map<String, WhitelistPathSettings> myRecorderToPathSettings = new HashMap<String, WhitelistPathSettings>();
    private static final String WHITELIST_MODIFY = "update";
    private static final String RECORDER_ID = "recorder-id";
    private static final String LAST_MODIFIED = "last-modified";
    private static final String PATH = "path";
    private static final String CUSTOM_PATH = "custom-path";
    private static final String USE_CUSTOM_PATH = "use-custom-path";

    public static EventLogWhitelistSettingsPersistence getInstance() {
        return (EventLogWhitelistSettingsPersistence)ServiceManager.getService(EventLogWhitelistSettingsPersistence.class);
    }

    public long getLastModified(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(0);
        }
        return this.myLastModifications.containsKey(recorderId) ? Math.max(this.myLastModifications.get(recorderId), 0L) : 0L;
    }

    public void setLastModified(@NotNull String recorderId, long lastUpdate) {
        if (recorderId == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(1);
        }
        this.myLastModifications.put(recorderId, Math.max(lastUpdate, 0L));
    }

    @Nullable
    public WhitelistPathSettings getPathSettings(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(2);
        }
        return this.myRecorderToPathSettings.get(recorderId);
    }

    public void setPathSettings(@NotNull String recorderId, @NotNull WhitelistPathSettings settings) {
        if (recorderId == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(4);
        }
        this.myRecorderToPathSettings.put(recorderId, settings);
    }

    public void loadState(@NotNull Element element) {
        String recorder;
        if (element == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(5);
        }
        this.myLastModifications.clear();
        for (Element update : element.getChildren(WHITELIST_MODIFY)) {
            recorder = update.getAttributeValue(RECORDER_ID);
            if (!StringUtil.isNotEmpty((String)recorder)) continue;
            long lastUpdate = EventLogWhitelistSettingsPersistence.parseLastUpdate(update);
            this.myLastModifications.put(recorder, lastUpdate);
        }
        this.myRecorderToPathSettings.clear();
        for (Element path : element.getChildren(PATH)) {
            String customPath;
            recorder = path.getAttributeValue(RECORDER_ID);
            if (!StringUtil.isNotEmpty((String)recorder) || (customPath = path.getAttributeValue(CUSTOM_PATH)) == null) continue;
            boolean useCustomPath = EventLogWhitelistSettingsPersistence.parseUseCustomPath(path);
            this.myRecorderToPathSettings.put(recorder, new WhitelistPathSettings(customPath, useCustomPath));
        }
    }

    private static boolean parseUseCustomPath(@NotNull Element update) {
        if (update == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(6);
        }
        try {
            return Boolean.parseBoolean(update.getAttributeValue(USE_CUSTOM_PATH, "false"));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static long parseLastUpdate(@NotNull Element update) {
        if (update == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(7);
        }
        try {
            return Long.parseLong(update.getAttributeValue(LAST_MODIFIED, "0"));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<String, Long> entry : this.myLastModifications.entrySet()) {
            Element update = new Element(WHITELIST_MODIFY);
            update.setAttribute(RECORDER_ID, entry.getKey());
            update.setAttribute(LAST_MODIFIED, String.valueOf(entry.getValue()));
            element.addContent(update);
        }
        for (Map.Entry<String, Object> entry : this.myRecorderToPathSettings.entrySet()) {
            Element path = new Element(PATH);
            path.setAttribute(RECORDER_ID, entry.getKey());
            WhitelistPathSettings value = (WhitelistPathSettings)entry.getValue();
            path.setAttribute(CUSTOM_PATH, value.getCustomPath());
            path.setAttribute(USE_CUSTOM_PATH, String.valueOf(value.isUseCustomPath()));
            element.addContent(path);
        }
        return element;
    }

    public void noStateLoaded() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = WHITELIST_MODIFY;
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogWhitelistSettingsPersistence";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastModified";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setLastModified";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setPathSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseUseCustomPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLastUpdate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

