/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vcs.update.FilesCollector;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronouslyKt;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.Wrapper;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J*\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\rH\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J\u0016\u0010\u0013\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0016\u0010\u0017\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bH\u0007J\u0016\u0010\u0019\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/update/RefreshVFsSynchronously;", "", "()V", "findValidParent", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Ljava/io/File;", "refresh", "", "T", "changes", "", "wrapper", "Lcom/intellij/openapi/vcs/update/Wrapper;", "Lcom/intellij/openapi/vcs/update/FilePathChange;", "isRollback", "", "refreshDeletedFiles", "files", "refreshFiles", "updateAllChanged", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "updateChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "updateChangesForRollback", "", "intellij.platform.vcs.impl"})
public final class RefreshVFsSynchronously {
    public static final RefreshVFsSynchronously INSTANCE;

    @JvmStatic
    public static final void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        Intrinsics.checkParameterIsNotNull((Object)updatedFiles, (String)"updatedFiles");
        FilesCollector collector = new FilesCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, collector);
        INSTANCE.refreshDeletedFiles((Collection<? extends File>)collector.getDeletedFiles());
        RefreshVFsSynchronously.refreshFiles((Collection<? extends File>)collector.getFiles());
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void refreshFiles(@NotNull Collection<? extends File> files) {
        VirtualFile[] virtualFileArray;
        void $this$toTypedArray$iv;
        Collection $this$mapNotNullTo$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Iterable iterable = files;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            File it = (File)element$iv;
            boolean bl3 = false;
            if (INSTANCE.findValidParent(it) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            VirtualFile it$iv = virtualFile;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)destination$iv;
        $this$mapNotNullTo$iv = toRefresh;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray2 = thisCollection$iv.toArray(new VirtualFile[0]);
        if (virtualFileArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        VirtualFile[] virtualFileArray3 = virtualFileArray = virtualFileArray2;
        VfsUtil.markDirtyAndRefresh((boolean)bl9, (boolean)bl8, (boolean)bl7, (VirtualFile[])Arrays.copyOf(virtualFileArray3, virtualFileArray3.length));
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshDeletedFiles(Collection<? extends File> files) {
        VirtualFile[] virtualFileArray;
        void $this$toTypedArray$iv;
        Collection $this$mapNotNullTo$iv;
        Iterable iterable = files;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            File it = (File)element$iv;
            boolean bl3 = false;
            if (INSTANCE.findValidParent(it.getParentFile()) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            VirtualFile it$iv = virtualFile;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)destination$iv;
        $this$mapNotNullTo$iv = toRefresh;
        boolean bl7 = false;
        boolean bl8 = true;
        boolean bl9 = false;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray2 = thisCollection$iv.toArray(new VirtualFile[0]);
        if (virtualFileArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        VirtualFile[] virtualFileArray3 = virtualFileArray = virtualFileArray2;
        VfsUtil.markDirtyAndRefresh((boolean)bl9, (boolean)bl8, (boolean)bl7, (VirtualFile[])Arrays.copyOf(virtualFileArray3, virtualFileArray3.length));
    }

    private final VirtualFile findValidParent(File file) {
        Object v1;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)file, (Function1)findValidParent.1.INSTANCE), (Function1)findValidParent.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                VirtualFile virtualFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                if (!virtualFile.isValid()) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @JvmStatic
    public static final void updateChangesForRollback(@NotNull List<? extends Change> changes) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        INSTANCE.refresh((Collection)changes, RefreshVFsSynchronouslyKt.access$getREVERSED_CHANGE_WRAPPER$p());
    }

    @JvmStatic
    public static final void updateChanges(@NotNull Collection<? extends Change> changes) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        INSTANCE.refresh(changes, RefreshVFsSynchronouslyKt.access$getCHANGE_WRAPPER$p());
    }

    public final void refresh(@NotNull Collection<? extends FilePathChange> changes, boolean isRollback) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        this.refresh(changes, isRollback ? RefreshVFsSynchronouslyKt.access$getREVERSED_FILE_PATH_CHANGE_WRAPPER$p() : RefreshVFsSynchronouslyKt.access$getFILE_PATH_CHANGE_WRAPPER$p());
    }

    public static /* synthetic */ void refresh$default(RefreshVFsSynchronously refreshVFsSynchronously, Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        refreshVFsSynchronously.refresh(collection, bl);
    }

    private final <T> void refresh(Collection<? extends T> changes, Wrapper<T> wrapper) {
        boolean bl = false;
        Set files = new LinkedHashSet();
        boolean bl2 = false;
        Set deletedFiles = new LinkedHashSet();
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            File file;
            Collection collection;
            FilePath it;
            FilePath filePath;
            boolean bl4;
            boolean bl5;
            Object element$iv;
            Object change = element$iv = iterator.next();
            boolean bl6 = false;
            FilePath beforePath = wrapper.getBeforePath(change);
            FilePath afterPath = wrapper.getAfterPath(change);
            if (beforePath != null) {
                bl5 = false;
                bl4 = false;
                it = filePath;
                boolean bl7 = false;
                collection = wrapper.isBeforePathDeleted(change) ? deletedFiles : files;
                file = it.getIOFile();
                bl3 = false;
                collection.add(file);
            }
            if (afterPath == null) continue;
            bl5 = false;
            bl4 = false;
            it = filePath;
            boolean bl8 = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)beforePath) ^ true)) continue;
            collection = files;
            file = it.getIOFile();
            bl3 = false;
            collection.add(file);
        }
        RefreshVFsSynchronously.refreshFiles(files);
        this.refreshDeletedFiles(deletedFiles);
    }

    private RefreshVFsSynchronously() {
    }

    static {
        RefreshVFsSynchronously refreshVFsSynchronously;
        INSTANCE = refreshVFsSynchronously = new RefreshVFsSynchronously();
    }
}

