/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.clean;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.extract.clean.ExtractCleanOptionsPanelController;
import tr.extract.clean.ExtractCleanPrefs;

final class ExtractCleanPanel
extends JPanel {
    private final ExtractCleanOptionsPanelController controller;
    private final Item[] intervals = new Item[]{new Item(this.getMsg("Run_Every_Startup"), 0), new Item(this.getMsg("Run_Every_Day"), 1), new Item(this.getMsg("Run_Every_Week"), 7), new Item(this.getMsg("Run_Every_2_Weeks"), 14), new Item(this.getMsg("Run_Every_3_Weeks"), 21), new Item(this.getMsg("Run_Every_4_Weeks"), 28), new Item(this.getMsg("Run_Never"), Integer.MAX_VALUE)};
    private final Item[] ages = new Item[]{new Item(this.getMsg("Age_1_Day"), 1), new Item(this.getMsg("Age_1_Week"), 7), new Item(this.getMsg("Age_2_Weeks"), 14), new Item(this.getMsg("Age_3_Weeks"), 21), new Item(this.getMsg("Age_4_Weeks"), 28)};
    private JComboBox ageCombo;
    private JLabel ageLabel;
    private JComboBox runCombo;
    private JLabel runLabel;

    ExtractCleanPanel(ExtractCleanOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.runLabel = new JLabel(this.getMsg("Run_Label"));
        this.ageLabel = new JLabel(this.getMsg("Age_Label"));
        this.runCombo = new JComboBox<Item>(new DefaultComboBoxModel<Item>(this.intervals));
        this.runCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractCleanPanel.this.controller.changed();
            }
        });
        this.ageCombo = new JComboBox<Item>(new DefaultComboBoxModel<Item>(this.ages));
        this.ageCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractCleanPanel.this.controller.changed();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[]0", "0[]2[]0"));
        panel.add((Component)this.runLabel, "align right");
        panel.add((Component)this.runCombo, "align left, wrap");
        panel.add((Component)this.ageLabel, "align right");
        panel.add((Component)this.ageCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    void load() {
        this.runCombo.setSelectedItem(this.getInterval(ExtractCleanPrefs.getCleanIntervalDays()));
        this.ageCombo.setSelectedItem(this.getAge(ExtractCleanPrefs.getCleanAgeDays()));
    }

    private Item getInterval(int value) {
        for (int i = 0; i < this.intervals.length; ++i) {
            if (this.intervals[i].value != value) continue;
            return this.intervals[i];
        }
        return this.intervals[0];
    }

    private Item getAge(int value) {
        for (int i = 0; i < this.ages.length; ++i) {
            if (this.ages[i].value != value) continue;
            return this.ages[i];
        }
        return this.ages[0];
    }

    void store() {
        int value;
        Item intervalItem;
        int value2;
        Item ageItem = (Item)this.ageCombo.getSelectedItem();
        if (ageItem != null && ageItem.value != (value2 = ExtractCleanPrefs.getCleanAgeDays())) {
            ExtractCleanPrefs.setCleanAgeDays(ageItem.value);
        }
        if ((intervalItem = (Item)this.runCombo.getSelectedItem()) != null && intervalItem.value != (value = ExtractCleanPrefs.getCleanIntervalDays())) {
            ExtractCleanPrefs.setCleanIntervalDays(intervalItem.value);
        }
    }

    boolean valid() {
        return true;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private static final class Item {
        public String label;
        public int value;

        public Item(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }
    }
}

