/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class EasyTrackProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*").expression("..,").number("(d+),").expression("([^,]{2}),").expression("([AV]),").number("(xx)(xx)(xx),").number("(xx)(xx)(xx),").number("(x)(x{7}),").number("(x)(x{7}),").number("(x{4}),").number("(x{4}),").number("(x{8}),").number("(x+),").number("(d+),").number("(x{4}),").number("(x+),?").number("(d+)?").any().compile();

    public EasyTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(long status) {
        if ((status & 0x2000000L) != 0L) {
            return "geofenceEnter";
        }
        if ((status & 0x4000000L) != 0L) {
            return "geofenceExit";
        }
        if ((status & 0x8000000L) != 0L) {
            return "lowBattery";
        }
        if ((status & 0x20000000L) != 0L) {
            return "vibration";
        }
        if ((status & Integer.MIN_VALUE) != 0L) {
            return "overspeed";
        }
        if ((status & 0x10000L) != 0L) {
            return "sos";
        }
        if ((status & 0x40000L) != 0L) {
            return "powerCut";
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("command", parser.next());
        position.setValid(parser.next().equals("A"));
        DateBuilder dateBuilder = new DateBuilder().setDate(parser.nextHexInt(0), parser.nextHexInt(0), parser.nextHexInt(0)).setTime(parser.nextHexInt(0), parser.nextHexInt(0), parser.nextHexInt(0));
        position.setTime(dateBuilder.getDate());
        if (BitUtil.check(parser.nextHexInt(0), 3)) {
            position.setLatitude((double)(-parser.nextHexInt(0)) / 600000.0);
        } else {
            position.setLatitude((double)parser.nextHexInt(0) / 600000.0);
        }
        if (BitUtil.check(parser.nextHexInt(0), 3)) {
            position.setLongitude((double)(-parser.nextHexInt(0)) / 600000.0);
        } else {
            position.setLongitude((double)parser.nextHexInt(0) / 600000.0);
        }
        position.setSpeed(UnitsConverter.knotsFromKph((double)parser.nextHexInt(0) / 100.0));
        position.setCourse((double)parser.nextHexInt(0) / 100.0);
        long status = parser.nextHexLong();
        position.set("status", status);
        position.set("alarm", this.decodeAlarm(status));
        position.set("signal", parser.next());
        position.set("power", parser.nextDouble(0.0));
        position.set("oil", parser.nextHexInt(0));
        position.set("odometer", parser.nextHexInt(0) * 100);
        position.setAltitude(parser.nextDouble(0.0));
        return position;
    }
}

