/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTransform
extends org.w3c.css.properties.css.CssTransform {
    static final String matrix = "matrix";
    static final String translate = "translate";
    static final String translateX = "translatex";
    static final String translateY = "translatey";
    static final String scale = "scale";
    static final String scaleX = "scalex";
    static final String scaleY = "scaley";
    static final String rotate = "rotate";
    static final String skew = "skew";
    static final String skewX = "skewx";
    static final String skewY = "skewy";
    static final String matrix3d = "matrix3d";
    static final String translate3d = "translate3d";
    static final String translateZ = "translatez";
    static final String scale3d = "scale3d";
    static final String scaleZ = "scalez";
    static final String rotate3d = "rotate3d";
    static final String rotateX = "rotatex";
    static final String rotateY = "rotatey";
    static final String rotateZ = "rotatez";
    static final String perspective = "perspective";

    public CssTransform() {
        this.value = initial;
    }

    public CssTransform(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean singleVal = false;
        Object sValue = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 11: {
                    CssTransform.parseFunctionValues(ac, val, this);
                    values.add(val);
                    break;
                }
                case 0: {
                    if (inherit.equals(val)) {
                        singleVal = true;
                        sValue = inherit;
                        values.add(inherit);
                        break;
                    }
                    if (none.equals(val)) {
                        singleVal = true;
                        sValue = none;
                        values.add(none);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (expression.end() || op == ' ') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (singleVal && values.size() > 1) {
            throw new InvalidParamException("value", sValue.toString(), this.getPropertyName(), ac);
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    public CssTransform(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    protected static void parseFunctionValues(ApplContext ac, CssValue func, CssProperty caller) throws InvalidParamException {
        String fname;
        CssFunction function = (CssFunction)func;
        switch (fname = function.getName().toLowerCase()) {
            case "matrix": {
                CssTransform.parseExactlyNX(ac, function.getParameters(), 6, 5, caller);
                break;
            }
            case "translate": {
                CssTransform.parseTranslateFunction(ac, function.getParameters(), caller);
                break;
            }
            case "translatex": 
            case "translatey": {
                CssTransform.parseTranslateAxisFunction(ac, function.getParameters(), caller);
                break;
            }
            case "scale": {
                CssTransform.parseAtMostX(ac, function.getParameters(), 2, 5, caller);
                break;
            }
            case "scalex": 
            case "scaley": {
                CssTransform.parseOneX(ac, function.getParameters(), 5, caller);
                break;
            }
            case "rotate": {
                CssTransform.parseOneX(ac, function.getParameters(), 7, caller);
                break;
            }
            case "skew": {
                CssTransform.parseAtMostX(ac, function.getParameters(), 2, 7, caller);
                break;
            }
            case "skewx": 
            case "skewy": {
                CssTransform.parseOneX(ac, function.getParameters(), 7, caller);
                break;
            }
            case "matrix3d": {
                CssTransform.parseExactlyNX(ac, function.getParameters(), 16, 5, caller);
                break;
            }
            case "translate3d": {
                CssTransform.parseTranslate3dFunction(ac, function.getParameters(), caller);
                break;
            }
            case "translatez": {
                CssTransform.parseOneX(ac, function.getParameters(), 6, caller);
                break;
            }
            case "scale3d": {
                CssTransform.parseExactlyNX(ac, function.getParameters(), 3, 5, caller);
                break;
            }
            case "scalez": {
                CssTransform.parseOneX(ac, function.getParameters(), 5, caller);
                break;
            }
            case "rotate3d": {
                CssTransform.parseRotate3dFunction(ac, function.getParameters(), caller);
                break;
            }
            case "rotatex": 
            case "rotatey": 
            case "rotatez": {
                CssTransform.parseOneX(ac, function.getParameters(), 7, caller);
                break;
            }
            case "perspective": {
                CssTransform.parseOneX(ac, function.getParameters(), 6, caller);
                break;
            }
            default: {
                throw new InvalidParamException("value", func.toString(), caller.getPropertyName(), ac);
            }
        }
    }

    private static void parseExactlyNX(ApplContext ac, CssExpression expression, int n, int type, CssProperty caller) throws InvalidParamException {
        if (expression.getCount() < n) {
            throw new InvalidParamException("few-value", caller.getPropertyName(), ac);
        }
        CssTransform.parseAtMostX(ac, expression, n, 5, caller);
    }

    private static void parseAtMostX(ApplContext ac, CssExpression expression, int atMost, int type, CssProperty caller) throws InvalidParamException {
        if (expression.getCount() > atMost) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!expression.end()) {
            char op;
            block9: {
                CssValue val;
                block8: {
                    val = expression.getValue();
                    op = expression.getOperator();
                    if (val.getType() != 5) break block8;
                    switch (type) {
                        case 6: {
                            val.getLength();
                            break block9;
                        }
                        case 7: {
                            val.getAngle();
                        }
                        case 5: {
                            break block9;
                        }
                        default: {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                    }
                }
                if (val.getType() != type) {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            expression.next();
            if (expression.end() || op == ',') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
    }

    private static void parseOneX(ApplContext ac, CssExpression expression, int type, CssProperty caller) throws InvalidParamException {
        if (expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        if (expression.getCount() == 0) {
            throw new InvalidParamException("few-value", caller.getPropertyName(), ac);
        }
        CssValue val = expression.getValue();
        if (val.getType() == 5 && (type == 6 || type == 7) && val.getNumber().isZero()) {
            expression.next();
            return;
        }
        if (val.getType() != type) {
            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
        }
        expression.next();
    }

    private static void parseTranslateFunction(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        if (expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        if (expression.getCount() == 0) {
            throw new InvalidParamException("few-value", caller.getPropertyName(), ac);
        }
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getLength();
                }
                case 4: 
                case 6: {
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            expression.next();
            if (expression.end() || op == ',') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
    }

    private static void parseTranslateAxisFunction(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        if (expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        if (expression.getCount() == 0) {
            throw new InvalidParamException("few-value", caller.getPropertyName(), ac);
        }
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 5: {
                val.getLength();
            }
            case 4: 
            case 6: {
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    private static void parseTranslate3dFunction(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        CssValue val;
        if (expression.getCount() < 3) {
            throw new InvalidParamException("few-value", caller.getPropertyName(), ac);
        }
        if (expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        for (int i = 0; i < 2; ++i) {
            val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getLength();
                }
                case 4: 
                case 6: {
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ',') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        val = expression.getValue();
        if (val.getType() == 5) {
            val.getLength();
        } else if (val.getType() != 6) {
            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
        }
        expression.next();
    }

    private static void parseRotate3dFunction(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        CssValue val;
        if (expression.getCount() < 4) {
            throw new InvalidParamException("few-value", caller.getPropertyName(), ac);
        }
        if (expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        for (int i = 0; i < 3; ++i) {
            val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 5) {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
            expression.next();
            if (op == ',') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        val = expression.getValue();
        if (val.getType() != 7) {
            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
        }
        expression.next();
    }
}

