(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/websocket#wsmagic '"258EAFA5-E914-47DA-95CA-C5AB0DC85B11")
  (define std/net/websocket#open-websocket-client__%
    (lambda (_g118728_
             _redirect118592118598_
             _headers118593118600_
             _cookies118594118602_
             _params118595118604_
             _url118606_)
      (let* ((_redirect118608_
              (if (eq? _redirect118592118598_ absent-value)
                  '#t
                  _redirect118592118598_))
             (_headers118610_
              (if (eq? _headers118593118600_ absent-value)
                  '#f
                  _headers118593118600_))
             (_cookies118612_
              (if (eq? _cookies118594118602_ absent-value)
                  '#f
                  _cookies118594118602_))
             (_params118614_
              (if (eq? _params118595118604_ absent-value)
                  '#f
                  _params118595118604_))
             (_url118616_ (std/net/websocket#url->request-url _url118606_))
             (_nonce118618_ (std/crypto/etc#random-bytes '16))
             (_nonce64118620_
              (std/text/base64#u8vector->base64-string _nonce118618_))
             (_headers118625_
              (cons (cons '"Upgrade" '"websocket")
                    (cons (cons '"Connection" '"Upgrade")
                          (cons (cons '"Sec-WebSocket-Key" _nonce64118620_)
                                (cons (cons '"Sec-WebSocket-Version" '13)
                                      (let ((_$e118622_ _headers118610_))
                                        (if _$e118622_ _$e118622_ '())))))))
             (_req118627_
              (std/net/request#http-get__%
               '#f
               _redirect118608_
               _headers118625_
               _cookies118612_
               _params118614_
               _url118616_)))
        (with-exception-catcher
         (lambda (_g118629118631_)
           (if '#t
               (let ((_e118634_ _g118629118631_))
                 (std/net/request#request-close _req118627_)
                 (raise _e118634_))
               (raise _g118629118631_)))
         (lambda ()
           (let ((_status118637_
                  (##structure-ref
                   _req118627_
                   '4
                   std/net/request#request::t
                   '#f)))
             (if (##fx= _status118637_ '101)
                 '#!void
                 (std/error#raise-io-error
                  'open-websocket-client
                  '"Unexpected server response"
                  _url118616_
                  _status118637_)))
           (let* ((_rheaders118639_
                   (##structure-ref
                    _req118627_
                    '6
                    std/net/request#request::t
                    '#f))
                  (_Connection118641_ (assoc '"Connection" _rheaders118639_))
                  (_Upgrade118643_ (assoc '"Upgrade" _rheaders118639_))
                  (_Sec-WebSocket-Accept118645_
                   (assoc '"Sec-Websocket-Accept" _rheaders118639_))
                  (_Sec-WebSocket-Extensions118647_
                   (assoc '"Sec-Websocket-Extensions" _rheaders118639_))
                  (_Sec-WebSocket-Protocol118649_
                   (assoc '"Sec-Websocket-Protocol" _rheaders118639_)))
             (if (and _Connection118641_
                      (equal? (std/srfi/13#string-downcase__0
                               (cdr _Connection118641_))
                              '"upgrade"))
                 '#!void
                 (std/error#raise-io-error
                  'open-websocket-client
                  '"Bad server response; no connection upgrade"
                  _url118616_
                  _Connection118641_))
             (if (and _Upgrade118643_
                      (equal? (std/srfi/13#string-downcase__0
                               (cdr _Upgrade118643_))
                              '"websocket"))
                 '#!void
                 (std/error#raise-io-error
                  'open-websocket-client
                  '"Bad server response; no websocket upgrade"
                  _url118616_
                  _Upgrade118643_))
             (let* ((_accept64118652_
                     (if _Sec-WebSocket-Accept118645_
                         (cdr _Sec-WebSocket-Accept118645_)
                         '#f))
                    (_digest118654_
                     (let ((__obj118725
                            (make-object std/crypto/digest#digest::t '2)))
                       (std/crypto/digest#digest:::init!
                        __obj118725
                        std/crypto/digest#digest::sha1)
                       __obj118725))
                    (_g118729_
                     (std/crypto/digest#digest-update!__0
                      _digest118654_
                      (std/text/utf8#string->utf8__0 _nonce64118620_)))
                    (_g118730_
                     (std/crypto/digest#digest-update!__0
                      _digest118654_
                      (std/text/utf8#string->utf8__0
                       std/net/websocket#wsmagic)))
                    (_verify118658_
                     (std/crypto/digest#digest-final!__0 _digest118654_))
                    (_verify64118660_
                     (std/text/base64#u8vector->base64-string _verify118658_)))
               (if (equal? _accept64118652_ _verify64118660_)
                   '#!void
                   (std/error#raise-io-error
                    'open-websocket-client
                    '"Bad server response; nonce verification failure"
                    _url118616_
                    _nonce64118620_
                    _accept64118652_
                    _verify64118660_)))
             (if _Sec-WebSocket-Extensions118647_
                 (std/error#raise-io-error
                  'open-websocket-client
                  '"Bad server response; includes unsupported exensions"
                  _url118616_
                  _Sec-WebSocket-Extensions118647_)
                 '#!void)
             (if _Sec-WebSocket-Protocol118649_
                 (let* ((_proto118663_ (cdr _Sec-WebSocket-Protocol118649_))
                        (_uproto118665_
                         (assoc '"Sec-WebSocket-Protocol" _headers118625_))
                        (_uproto118667_
                         (string-split
                          (if _uproto118665_ (cdr _uproto118665_) '#f)
                          '#\,)))
                   (if (member _proto118663_ _uproto118667_)
                       '#!void
                       (std/error#raise-io-error
                        'open-websocket-client
                        '"Bad server response; unexpected protocol"
                        _url118616_
                        _Sec-WebSocket-Protocol118649_)))
                 '#!void))
           (std/net/websocket#make-websocket-client
            (##structure-ref
             _req118627_
             '1
             std/net/request#request::t
             '#f)))))))
  (define std/net/websocket#open-websocket-client__@
    (lambda (_keys118591118673_ . _args118675_)
      (apply std/net/websocket#open-websocket-client__%
             _keys118591118673_
             (table-ref _keys118591118673_ 'redirect: absent-value)
             (table-ref _keys118591118673_ 'headers: absent-value)
             (table-ref _keys118591118673_ 'cookies: absent-value)
             (table-ref _keys118591118673_ 'params: absent-value)
             _args118675_)))
  (define std/net/websocket#open-websocket-client
    (lambda _args118596118681_
      (apply keyword-dispatch
             '#(params:
                cookies:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                redirect:
                headers:
                #f
                #f
                #f
                #f)
             std/net/websocket#open-websocket-client__@
             _args118596118681_)))
  (define std/net/websocket#url->request-url
    (lambda (_url118580_)
      (let ((_colon118582_ (std/srfi/13#string-index__0 _url118580_ '#\:)))
        (if _colon118582_
            (let* ((_scheme118585_ (substring _url118580_ '0 _colon118582_))
                   (_$e118587_ _scheme118585_))
              (if (equal? '"ws" _$e118587_)
                  (string-append
                   '"http"
                   (substring
                    _url118580_
                    _colon118582_
                    (string-length _url118580_)))
                  (if (equal? '"wss" _$e118587_)
                      (string-append
                       '"https"
                       (substring
                        _url118580_
                        _colon118582_
                        (string-length _url118580_)))
                      _url118580_)))
            _url118580_))))
  (define std/net/websocket#websocket::t
    (make-struct-type
     'std/net/websocket#websocket::t
     '#f
     '7
     'websocket
     '((final: . #t))
     ':init!
     '(port rd wr cs q mx cv)))
  (define std/net/websocket#websocket?
    (make-struct-predicate std/net/websocket#websocket::t))
  (define std/net/websocket#make-websocket
    (lambda _$args118577_
      (apply make-struct-instance
             std/net/websocket#websocket::t
             _$args118577_)))
  (define std/net/websocket#websocket-port
    (make-struct-field-accessor std/net/websocket#websocket::t '0))
  (define std/net/websocket#websocket-rd
    (make-struct-field-accessor std/net/websocket#websocket::t '1))
  (define std/net/websocket#websocket-wr
    (make-struct-field-accessor std/net/websocket#websocket::t '2))
  (define std/net/websocket#websocket-cs
    (make-struct-field-accessor std/net/websocket#websocket::t '3))
  (define std/net/websocket#websocket-q
    (make-struct-field-accessor std/net/websocket#websocket::t '4))
  (define std/net/websocket#websocket-mx
    (make-struct-field-accessor std/net/websocket#websocket::t '5))
  (define std/net/websocket#websocket-cv
    (make-struct-field-accessor std/net/websocket#websocket::t '6))
  (define std/net/websocket#websocket-port-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '0))
  (define std/net/websocket#websocket-rd-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '1))
  (define std/net/websocket#websocket-wr-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '2))
  (define std/net/websocket#websocket-cs-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '3))
  (define std/net/websocket#websocket-q-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '4))
  (define std/net/websocket#websocket-mx-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '5))
  (define std/net/websocket#websocket-cv-set!
    (make-struct-field-mutator std/net/websocket#websocket::t '6))
  (define std/net/websocket#websocket:::init!
    (lambda (_self118574_ _port118575_)
      (if (##fx< '7 (##vector-length _self118574_))
          (begin
            (##vector-set! _self118574_ '1 _port118575_)
            (##vector-set! _self118574_ '2 '#f)
            (##vector-set! _self118574_ '3 '#f)
            (##vector-set! _self118574_ '4 '#f)
            (##vector-set!
             _self118574_
             '5
             (let ((__obj118726 (make-object std/misc/queue#queue::t '3)))
               (std/misc/queue#queue:::init! __obj118726)
               __obj118726))
            (##vector-set! _self118574_ '6 (make-mutex))
            (##vector-set! _self118574_ '7 (make-condition-variable)))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self118574_))))
  (bind-method!
   std/net/websocket#websocket::t
   ':init!
   std/net/websocket#websocket:::init!
   '#f)
  (define std/net/websocket#make-websocket-client
    (lambda (_port118442_)
      (std/logger#start-logger!__0)
      (let* ((_ws118444_
              (let ((__obj118727
                     (make-object std/net/websocket#websocket::t '7)))
                (std/net/websocket#websocket:::init! __obj118727 _port118442_)
                __obj118727))
             (_reader118446_
              (gerbil/gambit/threads#spawn/name
               'websocket-reader
               std/net/websocket#websocket-reader
               _ws118444_))
             (_writer118448_
              (gerbil/gambit/threads#spawn/name
               'websocket-writer
               std/net/websocket#websocket-writer
               _ws118444_)))
        (##direct-structure-set!
         _ws118444_
         _reader118446_
         '2
         std/net/websocket#websocket::t
         '#f)
        (##direct-structure-set!
         _ws118444_
         _writer118448_
         '3
         std/net/websocket#websocket::t
         '#f)
        _ws118444_)))
  (define std/net/websocket#websocket-send
    (lambda (_ws118430_ _bytes118431_ _type118432_)
      (if (not (u8vector? _bytes118431_))
          (error '"Bad argument; expected u8vector" _bytes118431_)
          (if (not (or (eq? _type118432_ 'binary) (eq? _type118432_ 'text)))
              (error '"Bad argument; expected 'binary or 'text" _type118432_)
              (let ((_$e118437_
                     (##direct-structure-ref
                      _ws118430_
                      '4
                      std/net/websocket#websocket::t
                      '#f)))
                (if _$e118437_
                    ((lambda (_how118440_)
                       (std/error#raise-io-error
                        'websocket-send
                        '"Websocket has been closed"
                        _ws118430_
                        _how118440_))
                     _$e118437_)
                    (thread-send
                     (##direct-structure-ref
                      _ws118430_
                      '3
                      std/net/websocket#websocket::t
                      '#f)
                     (cons _type118432_ _bytes118431_))))))))
  (define std/net/websocket#websocket-write
    (lambda (_ws118427_ _obj118428_)
      (if (string? _obj118428_)
          (std/net/websocket#websocket-send
           _ws118427_
           (std/text/utf8#string->utf8__0 _obj118428_)
           'text)
          (if (u8vector? _obj118428_)
              (std/net/websocket#websocket-send _ws118427_ _obj118428_ 'binary)
              (error '"Bad argument; expected bytes or string" _obj118428_)))))
  (define std/net/websocket#websocket-recv__%
    (lambda (_ws118315_ _timeo118316_ _raise?118317_)
      (let* ((_timeo118319_ (std/misc/timeout#make-timeout__0 _timeo118316_))
             (_ws118320118332_ _ws118315_)
             (_E118322118336_
              (lambda () (error '"No clause matching" _ws118320118332_)))
             (_K118323118379_
              (lambda (_cv118339_ _mx118340_ _q118341_)
                (let _lp118343_ ()
                  (mutex-lock! _mx118340_)
                  (if (not (std/misc/queue#queue-empty? _q118341_))
                      (let* ((_g118345118352_
                              (std/misc/queue#dequeue!__0 _q118341_))
                             (_E118347118356_
                              (lambda ()
                                (error '"No clause matching" _g118345118352_)))
                             (_K118348118362_
                              (lambda (_data118359_ _type118360_)
                                (mutex-unlock! _mx118340_)
                                (values _data118359_ _type118360_))))
                        (if (##pair? _g118345118352_)
                            (let ((_hd118349118365_ (##car _g118345118352_))
                                  (_tl118350118367_ (##cdr _g118345118352_)))
                              (let* ((_type118370_ _hd118349118365_)
                                     (_data118372_ _tl118350118367_))
                                (_K118348118362_ _data118372_ _type118370_)))
                            (_E118347118356_)))
                      (let ((_$e118374_
                             (##direct-structure-ref
                              _ws118315_
                              '4
                              std/net/websocket#websocket::t
                              '#f)))
                        (if _$e118374_
                            ((lambda (_how118377_)
                               (mutex-unlock! _mx118340_)
                               (if _raise?118317_
                                   (std/error#raise-io-error
                                    'websocket-recv
                                    '"Websocket has been closed"
                                    _ws118315_
                                    _how118377_)
                                   '#!eof))
                             _$e118374_)
                            (if (mutex-unlock!
                                 _mx118340_
                                 _cv118339_
                                 _timeo118319_)
                                (_lp118343_)
                                (if _raise?118317_
                                    (std/error#raise-timeout
                                     'websocket-recv
                                     '"timeout"
                                     _ws118315_)
                                    '#f)))))))))
        (if (##structure-direct-instance-of?
             _ws118320118332_
             'std/net/websocket#websocket::t)
            (let* ((_e118324118382_ (##vector-ref _ws118320118332_ '1))
                   (_e118325118385_ (##vector-ref _ws118320118332_ '2))
                   (_e118326118388_ (##vector-ref _ws118320118332_ '3))
                   (_e118327118391_ (##vector-ref _ws118320118332_ '4))
                   (_e118328118394_ (##vector-ref _ws118320118332_ '5))
                   (_q118397_ _e118328118394_)
                   (_e118329118399_ (##vector-ref _ws118320118332_ '6))
                   (_mx118402_ _e118329118399_)
                   (_e118330118404_ (##vector-ref _ws118320118332_ '7))
                   (_cv118407_ _e118330118404_))
              (_K118323118379_ _cv118407_ _mx118402_ _q118397_))
            (_E118322118336_)))))
  (define std/net/websocket#websocket-recv__0
    (lambda (_ws118412_)
      (let* ((_timeo118414_ '#f) (_raise?118416_ '#t))
        (std/net/websocket#websocket-recv__%
         _ws118412_
         _timeo118414_
         _raise?118416_))))
  (define std/net/websocket#websocket-recv__1
    (lambda (_ws118418_ _timeo118419_)
      (let ((_raise?118421_ '#t))
        (std/net/websocket#websocket-recv__%
         _ws118418_
         _timeo118419_
         _raise?118421_))))
  (define std/net/websocket#websocket-recv
    (lambda _g118732_
      (let ((_g118731_ (length _g118732_)))
        (cond ((##fx= _g118731_ 1)
               (apply std/net/websocket#websocket-recv__0 _g118732_))
              ((##fx= _g118731_ 2)
               (apply std/net/websocket#websocket-recv__1 _g118732_))
              ((##fx= _g118731_ 3)
               (apply std/net/websocket#websocket-recv__% _g118732_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/websocket#websocket-recv
                _g118732_))))))
  (define std/net/websocket#websocket-read__%
    (lambda (_ws118232_ _timeo118233_ _raise?118234_)
      (let* ((_g118235118248_
              (std/net/websocket#websocket-recv__%
               _ws118232_
               _timeo118233_
               _raise?118234_))
             (_E118239118252_
              (lambda () (error '"No clause matching" _g118235118248_))))
        (let ((_K118244118285_ (lambda (_data118283_) _data118283_))
              (_K118241118269_
               (lambda (_data118267_)
                 (std/text/utf8#utf8->string__0 _data118267_)))
              (_K118240118258_ (lambda (_r118256_) _r118256_)))
          (if (##fx= (if (##values? _g118235118248_)
                         (##vector-length _g118235118248_)
                         '1)
                     '2)
              (let* ((_e118245118288_ (##vector-ref _g118235118248_ '0))
                     (_e118246118293_ (##vector-ref _g118235118248_ '1)))
                (if (##eq? _e118246118293_ 'binary)
                    (let ((_data118291_ _e118245118288_))
                      (_K118244118285_ _data118291_))
                    (if (##eq? _e118246118293_ 'text)
                        (let ((_data118275_ _e118245118288_))
                          (std/text/utf8#utf8->string__0 _data118275_))
                        (let ((_r118261_ _g118235118248_))
                          (_K118240118258_ _r118261_)))))
              (let ((_r118261_ _g118235118248_))
                (_K118240118258_ _r118261_)))))))
  (define std/net/websocket#websocket-read__0
    (lambda (_ws118299_)
      (let* ((_timeo118301_ '#f) (_raise?118303_ '#f))
        (std/net/websocket#websocket-read__%
         _ws118299_
         _timeo118301_
         _raise?118303_))))
  (define std/net/websocket#websocket-read__1
    (lambda (_ws118305_ _timeo118306_)
      (let ((_raise?118308_ '#f))
        (std/net/websocket#websocket-read__%
         _ws118305_
         _timeo118306_
         _raise?118308_))))
  (define std/net/websocket#websocket-read
    (lambda _g118734_
      (let ((_g118733_ (length _g118734_)))
        (cond ((##fx= _g118733_ 1)
               (apply std/net/websocket#websocket-read__0 _g118734_))
              ((##fx= _g118733_ 2)
               (apply std/net/websocket#websocket-read__1 _g118734_))
              ((##fx= _g118733_ 3)
               (apply std/net/websocket#websocket-read__% _g118734_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/websocket#websocket-read
                _g118734_))))))
  (define std/net/websocket#websocket-close__%__%
    (lambda (__118128118131_ _hard?118126118133_ _ws118135_ _how118136_)
      (let* ((_hard?118138_
              (if (eq? _hard?118126118133_ absent-value)
                  '#f
                  _hard?118126118133_))
             (_ws118139118151_ _ws118135_)
             (_E118141118155_
              (lambda () (error '"No clause matching" _ws118139118151_)))
             (_K118142118167_
              (lambda (_cv118158_
                       _mx118159_
                       _q118160_
                       _cs118161_
                       _writer118162_
                       _port118163_)
                (if _hard?118138_ (close-port _port118163_) '#!void)
                (if _cs118161_
                    '#!void
                    (begin
                      (mutex-lock! _mx118159_)
                      (if (##direct-structure-ref
                           _ws118135_
                           '4
                           std/net/websocket#websocket::t
                           '#f)
                          (mutex-unlock! _mx118159_)
                          (let ((_how118165_
                                 (if _hard?118138_ 'abort _how118136_)))
                            (##direct-structure-set!
                             _ws118135_
                             _how118165_
                             '4
                             std/net/websocket#websocket::t
                             '#f)
                            (thread-send
                             _writer118162_
                             (cons 'close _how118165_))
                            (condition-variable-broadcast! _cv118158_)
                            (mutex-unlock! _mx118159_))))))))
        (if (##structure-direct-instance-of?
             _ws118139118151_
             'std/net/websocket#websocket::t)
            (let* ((_e118143118170_ (##vector-ref _ws118139118151_ '1))
                   (_port118173_ _e118143118170_)
                   (_e118144118175_ (##vector-ref _ws118139118151_ '2))
                   (_e118145118178_ (##vector-ref _ws118139118151_ '3))
                   (_writer118181_ _e118145118178_)
                   (_e118146118183_ (##vector-ref _ws118139118151_ '4))
                   (_cs118186_ _e118146118183_)
                   (_e118147118188_ (##vector-ref _ws118139118151_ '5))
                   (_q118191_ _e118147118188_)
                   (_e118148118193_ (##vector-ref _ws118139118151_ '6))
                   (_mx118196_ _e118148118193_)
                   (_e118149118198_ (##vector-ref _ws118139118151_ '7))
                   (_cv118201_ _e118149118198_))
              (_K118142118167_
               _cv118201_
               _mx118196_
               _q118191_
               _cs118186_
               _writer118181_
               _port118173_))
            (_E118141118155_)))))
  (define std/net/websocket#websocket-close__%__0
    (lambda (__118128118206_ _hard?118126118207_ _ws118208_)
      (let ((_how118210_ '1000))
        (std/net/websocket#websocket-close__%__%
         __118128118206_
         _hard?118126118207_
         _ws118208_
         _how118210_))))
  (define std/net/websocket#websocket-close__%
    (lambda _g118736_
      (let ((_g118735_ (length _g118736_)))
        (cond ((##fx= _g118735_ 3)
               (apply std/net/websocket#websocket-close__%__0 _g118736_))
              ((##fx= _g118735_ 4)
               (apply std/net/websocket#websocket-close__%__% _g118736_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/websocket#websocket-close__%
                _g118736_))))))
  (define std/net/websocket#websocket-close__@
    (lambda (_keys118125118220_ . _args118222_)
      (apply std/net/websocket#websocket-close__%
             _keys118125118220_
             (table-ref _keys118125118220_ 'hard: absent-value)
             _args118222_)))
  (define std/net/websocket#websocket-close
    (lambda _args118127118228_
      (apply keyword-dispatch
             '#(hard:)
             std/net/websocket#websocket-close__@
             _args118127118228_)))
  (define std/net/websocket#max-frame-size (expt '2 '20))
  (define std/net/websocket#max-message-size (expt '2 '20))
  (define std/net/websocket#set-websocket-max-frame-size!
    (lambda (_sz118122_) (set! std/net/websocket#max-frame-size _sz118122_)))
  (define std/net/websocket#set-websocket-max-message-size!
    (lambda (_sz118120_) (set! std/net/websocket#max-message-size _sz118120_)))
  (define std/net/websocket#websocket-reader
    (lambda (_ws117923_)
      (letrec* ((_buf117925_ (make-u8vector '1024))
                (_skip-to-eof117926_
                 (lambda (_port118111_)
                   (let ((_len118113_ (u8vector-length _buf117925_)))
                     (let _lp118115_ ()
                       (let ((_rd118118_
                              (read-subu8vector
                               _buf117925_
                               '0
                               _len118113_
                               _port118111_)))
                         (if (##fx= _len118113_ _rd118118_)
                             (_lp118115_)
                             '#!void))))))
                (_skip-payload117927_
                 (lambda (_port118095_ _plen118096_)
                   (let ((_len118098_ (u8vector-length _buf117925_)))
                     (let _lp118100_ ((_need118102_ _plen118096_))
                       (let ((_$e118104_ (##fxzero? _need118102_)))
                         (if _$e118104_
                             _$e118104_
                             (if (##fx<= _need118102_ _len118098_)
                                 (let ((_rd118107_
                                        (read-subu8vector
                                         _buf117925_
                                         '0
                                         _need118102_
                                         _port118095_)))
                                   (if (##fx< _rd118107_ _need118102_)
                                       (_read-eof117932_)
                                       '#!void))
                                 (let ((_rd118109_
                                        (read-subu8vector
                                         _buf117925_
                                         '0
                                         _len118098_
                                         _port118095_)))
                                   (if (##fx< _rd118109_ _len118098_)
                                       (_read-eof117932_)
                                       (_lp118100_
                                        (##fx- _need118102_
                                               _len118098_)))))))))))
                (_read-header117928_
                 (lambda (_port118086_)
                   (let* ((_b0118088_ (read-u8 _port118086_))
                          (_g118737_
                           (if (eof-object? _b0118088_)
                               (_read-eof117932_)
                               '#!void))
                          (_b1118091_ (read-u8 _port118086_))
                          (_g118738_
                           (if (eof-object? _b1118091_)
                               (_read-eof117932_)
                               '#!void)))
                     (values (##fxand _b0118088_ '128)
                             (##fxand _b0118088_ '15)
                             (##fxand _b1118091_ '128)
                             (##fxand _b1118091_ '127)))))
                (_read-payload117929_
                 (lambda (_port118078_ _plen118079_)
                   (if (##fxzero? _plen118079_)
                       '#u8()
                       (let* ((_data118081_ (make-u8vector _plen118079_))
                              (_rd118083_
                               (read-subu8vector
                                _data118081_
                                '0
                                _plen118079_
                                _port118078_)))
                         (if (##fx< _rd118083_ _plen118079_)
                             (_read-eof117932_)
                             _data118081_)))))
                (_read-u16117930_
                 (lambda (_port118069_)
                   (let* ((_b0118071_ (read-u8 _port118069_))
                          (_g118739_
                           (if (eof-object? _b0118071_)
                               (_read-eof117932_)
                               '#!void))
                          (_b1118074_ (read-u8 _port118069_))
                          (_g118740_
                           (if (eof-object? _b1118074_)
                               (_read-eof117932_)
                               '#!void)))
                     (##fxior (##fxarithmetic-shift _b0118071_ '8)
                              _b1118074_))))
                (_read-u64117931_
                 (lambda (_port118060_)
                   (let ((_rd118062_
                          (read-subu8vector _buf117925_ '0 '8 _port118060_)))
                     (if (##fx= _rd118062_ '8)
                         (let _lp118064_ ((_k118066_ '0) (_r118067_ '0))
                           (if (##fx< _k118066_ '8)
                               (_lp118064_
                                (##fx+ _k118066_ '1)
                                (bitwise-ior
                                 (arithmetic-shift _r118067_ '8)
                                 (##u8vector-ref _buf117925_ _k118066_)))
                               _r118067_))
                         (_read-eof117932_)))))
                (_read-eof117932_ (lambda () (raise 'eof))))
        (let* ((_ws117933117945_ _ws117923_)
               (_E117935117949_
                (lambda () (error '"No clause matching" _ws117933117945_)))
               (_K117936118025_
                (lambda (_cv117952_
                         _mx117953_
                         _q117954_
                         _writer117955_
                         _port117956_)
                  (letrec ((_receive117958_
                            (lambda (_type118022_ _data118023_)
                              (mutex-lock! _mx117953_)
                              (if (##direct-structure-ref
                                   _ws117923_
                                   '4
                                   std/net/websocket#websocket::t
                                   '#f)
                                  (begin
                                    (mutex-unlock! _mx117953_)
                                    (raise 'abort))
                                  (begin
                                    (std/misc/queue#enqueue!
                                     _q117954_
                                     (cons _type118022_ _data118023_))
                                    (condition-variable-broadcast! _cv117952_)
                                    (mutex-unlock! _mx117953_))))))
                    (with-unwind-protect
                     (lambda ()
                       (with-exception-catcher
                        (lambda (_g117959117962_)
                          (if '#t
                              (let ((_e117965_ _g117959117962_))
                                (let ((_$e117967_ _e117965_))
                                  (if (eq? 'eof _$e117967_)
                                      (std/net/websocket#websocket-close__%__%
                                       '#f
                                       absent-value
                                       _ws117923_
                                       'eof)
                                      (if (eq? 'abort _$e117967_)
                                          '#!void
                                          (begin
                                            (std/logger#log-error
                                             '"unhandled exception"
                                             _e117965_)
                                            (std/net/websocket#websocket-close__%__%
                                             '#f
                                             absent-value
                                             _ws117923_
                                             'abort)
                                            (raise _e117965_)))))
                                _e117965_)
                              (raise _g117959117962_)))
                        (lambda ()
                          (let _lp117971_ ((_type117973_ '#f)
                                           (_frags117974_ '()))
                            (let ((_g118741_
                                   (_read-header117928_ _port117956_)))
                              (begin
                                (let ((_g118742_
                                       (if (##values? _g118741_)
                                           (##vector-length _g118741_)
                                           1)))
                                  (if (not (##fx= _g118742_ 4))
                                      (error "Context expects 4 values"
                                             _g118742_)))
                                (let ((_fin117976_ (##vector-ref _g118741_ 0))
                                      (_opcode117977_
                                       (##vector-ref _g118741_ 1))
                                      (_mask117978_ (##vector-ref _g118741_ 2))
                                      (_plen117979_
                                       (##vector-ref _g118741_ 3)))
                                  (let ((_plen117984_
                                         (let ((_$e117981_ _plen117979_))
                                           (if (eq? '126 _$e117981_)
                                               (_read-u16117930_ _port117956_)
                                               (if (eq? '127 _$e117981_)
                                                   (_read-u64117931_
                                                    _port117956_)
                                                   _plen117979_)))))
                                    (if (not (##fxzero? _mask117978_))
                                        (begin
                                          (std/logger#warning
                                           '"server sent masked frame; closing websocket connection")
                                          (std/net/websocket#websocket-close__%__%
                                           '#f
                                           absent-value
                                           _ws117923_
                                           '1002)
                                          (_skip-to-eof117926_ _port117956_))
                                        (if (> _plen117984_
                                               std/net/websocket#max-frame-size)
                                            (begin
                                              (std/logger#warning
                                               '"frame size ~a exceeds max frame size; closing websocket connection"
                                               _plen117984_)
                                              (std/net/websocket#websocket-close__%__%
                                               '#f
                                               absent-value
                                               _ws117923_
                                               '1009)
                                              (_skip-to-eof117926_
                                               _port117956_))
                                            (let ((_$e117987_ _opcode117977_))
                                              (let ((_default117989117993_
                                                     (lambda ()
                                                       (std/logger#warning
                                                        '"unexpected frame ~x from server; closing websocket connection"
                                                        _opcode117977_)
                                                       (std/net/websocket#websocket-close__%__%
                                                        '#f
                                                        absent-value
                                                        _ws117923_
                                                        '1002)
                                                       (_skip-to-eof117926_
                                                        _port117956_)))
                                                    (_table117990117995_
                                                     '#(0
                                                        1
                                                        1
                                                        #f
                                                        #f
                                                        #f
                                                        #f
                                                        #f
                                                        2
                                                        3
                                                        4)))
                                                (if (fixnum? _$e117987_)
                                                    (if (and (##fx>= _$e117987_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             '0)
                     (##fx< _$e117987_ '11))
                (let ((_x117998_
                       (##vector-ref _table117990117995_ _$e117987_)))
                  (if _x117998_
                      (if (##fx< _x117998_ '2)
                          (if (##fx= _x117998_ '0)
                              (let ((_dlen118001_
                                     (foldl1 ##fx+
                                             _plen117984_
                                             (map u8vector-length
                                                  _frags117974_))))
                                (if (not _type117973_)
                                    (begin
                                      (std/logger#warning
                                       '"unexpected continuation frame from server; closing websocket connection")
                                      (std/net/websocket#websocket-close__%__%
                                       '#f
                                       absent-value
                                       _ws117923_
                                       '1002)
                                      (_skip-to-eof117926_ _port117956_))
                                    (if (##fx> _dlen118001_
                                               std/net/websocket#max-message-size)
                                        (begin
                                          (std/logger#warning
                                           '"message length ~a exceeds max message size; closing websocket connection"
                                           _dlen118001_)
                                          (std/net/websocket#websocket-close__%__%
                                           '#f
                                           absent-value
                                           _ws117923_
                                           '1009)
                                          (_skip-to-eof117926_ _port117956_))
                                        (if (##fxzero? _fin117976_)
                                            (if (##fxzero? _plen117984_)
                                                (_lp117971_
                                                 _type117973_
                                                 _frags117974_)
                                                (let ((_data118003_
                                                       (_read-payload117929_
                                                        _port117956_
                                                        _plen117984_)))
                                                  (_lp117971_
                                                   _type117973_
                                                   (cons _data118003_
                                                         _frags117974_))))
                                            (let* ((_data118005_
                                                    (_read-payload117929_
                                                     _port117956_
                                                     _plen117984_))
                                                   (_message118007_
                                                    (append-u8vectors
                                                     (reverse (cons _data118005_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _frags117974_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              (_receive117958_
                                               _type117973_
                                               _message118007_)
                                              (_lp117971_ '#f '()))))))
                              (let ((_xtype118010_
                                     (if (##fx= _opcode117977_ '1)
                                         'text
                                         'binary)))
                                (if _type117973_
                                    (begin
                                      (std/logger#warning
                                       '"unexpected frame ~x from server; closing websocket connection"
                                       _opcode117977_)
                                      (std/net/websocket#websocket-close__%__%
                                       '#f
                                       absent-value
                                       _ws117923_
                                       '1002)
                                      (_skip-to-eof117926_ _port117956_))
                                    (if (##fxzero? _fin117976_)
                                        (let ((_data118012_
                                               (_read-payload117929_
                                                _port117956_
                                                _plen117984_)))
                                          (_lp117971_
                                           _xtype118010_
                                           (cons _data118012_ '())))
                                        (let ((_data118014_
                                               (_read-payload117929_
                                                _port117956_
                                                _plen117984_)))
                                          (_receive117958_
                                           _xtype118010_
                                           _data118014_)
                                          (_lp117971_ '#f '()))))))
                          (if (##fx= _x117998_ '2)
                              (let ((_how118016_
                                     (_read-u16117930_ _port117956_)))
                                (std/net/websocket#websocket-close__%__%
                                 '#f
                                 absent-value
                                 _ws117923_
                                 _how118016_)
                                (_skip-to-eof117926_ _port117956_))
                              (if (##fx= _x117998_ '3)
                                  (let ((_data118018_
                                         (_read-payload117929_
                                          _port117956_
                                          _plen117984_)))
                                    (thread-send
                                     _writer117955_
                                     (cons 'pong _data118018_))
                                    (_lp117971_ _type117973_ _frags117974_))
                                  (begin
                                    (_skip-payload117927_
                                     _port117956_
                                     _plen117984_)
                                    (_lp117971_ _type117973_ _frags117974_)))))
                      (_default117989117993_)))
                (_default117989117993_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (_default117989117993_))))))))))))))
                     (lambda ()
                       (with-exception-catcher
                        void
                        (lambda () (close-input-port _port117956_)))))))))
          (if (##structure-direct-instance-of?
               _ws117933117945_
               'std/net/websocket#websocket::t)
              (let* ((_e117937118028_ (##vector-ref _ws117933117945_ '1))
                     (_port118031_ _e117937118028_)
                     (_e117938118033_ (##vector-ref _ws117933117945_ '2))
                     (_e117939118036_ (##vector-ref _ws117933117945_ '3))
                     (_writer118039_ _e117939118036_)
                     (_e117940118041_ (##vector-ref _ws117933117945_ '4))
                     (_e117941118044_ (##vector-ref _ws117933117945_ '5))
                     (_q118047_ _e117941118044_)
                     (_e117942118049_ (##vector-ref _ws117933117945_ '6))
                     (_mx118052_ _e117942118049_)
                     (_e117943118054_ (##vector-ref _ws117933117945_ '7))
                     (_cv118057_ _e117943118054_))
                (_K117936118025_
                 _cv118057_
                 _mx118052_
                 _q118047_
                 _writer118039_
                 _port118031_))
              (_E117935117949_))))))
  (define std/net/websocket#websocket-writer
    (lambda (_ws117731_)
      (letrec* ((_buf117733_ (make-u8vector '65535))
                (_mask-bytes117734_ (make-u8vector '4))
                (_write-u16117735_
                 (lambda (_plen117920_ _port117921_)
                   (write-u8
                    (##fxand (##fxarithmetic-shift _plen117920_ '-8) '255)
                    _port117921_)
                   (write-u8 (##fxand _plen117920_ '255) _port117921_)))
                (_write-payload117736_
                 (lambda (_mask117909_
                          _data117910_
                          _start117911_
                          _end117912_
                          _port117913_)
                   (let _lp117915_ ((_k117917_ _start117911_) (_x117918_ '0))
                     (if (##fx< _k117917_ _end117912_)
                         (begin
                           (##u8vector-set!
                            _buf117733_
                            _x117918_
                            (##fxxor (##u8vector-ref _data117910_ _k117917_)
                                     (##u8vector-ref
                                      _mask117909_
                                      (##fxmodulo _x117918_ '4))))
                           (_lp117915_
                            (##fx+ _k117917_ '1)
                            (##fx+ _x117918_ '1)))
                         (write-subu8vector
                          _buf117733_
                          '0
                          _x117918_
                          _port117913_)))))
                (_send-frame117737_
                 (lambda (_port117891_
                          _fin117892_
                          _opcode117893_
                          _data117894_
                          _start117895_
                          _end117896_)
                   (let* ((_plen117898_ (##fx- _end117896_ _start117895_))
                          (_fin117900_ (##fxarithmetic-shift _fin117892_ '7))
                          (_b0117902_ (##fxior _fin117900_ _opcode117893_))
                          (_mask117904_ (##fxarithmetic-shift '1 '7))
                          (_b1117906_
                           (##fxior _mask117904_
                                    (if (##fx< _plen117898_ '126)
                                        _plen117898_
                                        '126))))
                     (std/crypto/etc#random-bytes!__0 _mask-bytes117734_)
                     (write-u8 _b0117902_ _port117891_)
                     (write-u8 _b1117906_ _port117891_)
                     (if (##fx< _plen117898_ '126)
                         '#!void
                         (_write-u16117735_ _plen117898_ _port117891_))
                     (write-subu8vector _mask-bytes117734_ '0 '4 _port117891_)
                     (_write-payload117736_
                      _mask-bytes117734_
                      _data117894_
                      _start117895_
                      _end117896_
                      _port117891_)
                     (force-output _port117891_))))
                (_send117738_
                 (lambda (_port117876_ _opcode117877_ _data117878_)
                   (let ((_end117880_ (u8vector-length _data117878_)))
                     (let _lp117882_ ((_start117884_ '0)
                                      (_opcode117885_ _opcode117877_))
                       (let ((_have117887_ (##fx- _end117880_ _start117884_)))
                         (if (##fx< _have117887_ '65536)
                             (_send-frame117737_
                              _port117876_
                              '1
                              _opcode117885_
                              _data117878_
                              _start117884_
                              _end117880_)
                             (let ((_xend117889_ (##fx+ _start117884_ '65535)))
                               (_send-frame117737_
                                _port117876_
                                '0
                                _opcode117885_
                                _data117878_
                                _start117884_
                                _xend117889_)
                               (_lp117882_ _xend117889_ '0)))))))))
        (let* ((_ws117739117745_ _ws117731_)
               (_E117741117749_
                (lambda () (error '"No clause matching" _ws117739117745_)))
               (_K117742117868_
                (lambda (_port117752_)
                  (with-unwind-protect
                   (lambda ()
                     (with-exception-catcher
                      (lambda (_g117753117756_)
                        (if '#t
                            (let ((_e117759_ _g117753117756_))
                              (std/logger#log-error
                               '"unhandled exception"
                               _e117759_)
                              (std/net/websocket#websocket-close__%__%
                               '#f
                               absent-value
                               _ws117731_
                               'abort)
                              (with-exception-catcher
                               void
                               (lambda () (close-port _port117752_))))
                            (raise _g117753117756_)))
                      (lambda ()
                        (let _lp117763_ ()
                          (let* ((_g117765117786_ (thread-receive))
                                 (_E117771117790_
                                  (lambda ()
                                    (error '"No clause matching"
                                           _g117765117786_))))
                            (let ((_K117782117856_
                                   (lambda (_data117854_)
                                     (_send117738_
                                      _port117752_
                                      '1
                                      _data117854_)
                                     (_lp117763_)))
                                  (_K117779117841_
                                   (lambda (_data117839_)
                                     (_send117738_
                                      _port117752_
                                      '2
                                      _data117839_)
                                     (_lp117763_)))
                                  (_K117776117825_
                                   (lambda (_data117823_)
                                     (_send117738_
                                      _port117752_
                                      '10
                                      _data117823_)
                                     (_lp117763_)))
                                  (_K117773117809_
                                   (lambda (_how117805_)
                                     (if (fixnum? _how117805_)
                                         (let ((_bytes117807_
                                                (make-u8vector '2)))
                                           (##u8vector-set!
                                            _bytes117807_
                                            '0
                                            (##fxand (##fxarithmetic-shift
                                                      _how117805_
                                                      '-8)
                                                     '255))
                                           (##u8vector-set!
                                            _bytes117807_
                                            '1
                                            (##fxand _how117805_ '255))
                                           (_send117738_
                                            _port117752_
                                            '8
                                            _bytes117807_))
                                         '#!void)))
                                  (_K117772117796_
                                   (lambda (_bogus117794_)
                                     (std/logger#warning
                                      '"unexpected message ~a"
                                      _bogus117794_)
                                     (_lp117763_))))
                              (if (##pair? _g117765117786_)
                                  (let ((_tl117784117861_
                                         (##cdr _g117765117786_))
                                        (_hd117783117859_
                                         (##car _g117765117786_)))
                                    (if (##eq? _hd117783117859_ 'text)
                                        (let ((_data117864_ _tl117784117861_))
                                          (_K117782117856_ _data117864_))
                                        (if (##eq? _hd117783117859_ 'binary)
                                            (let ((_data117849_
                                                   _tl117784117861_))
                                              (_K117779117841_ _data117849_))
                                            (if (##eq? _hd117783117859_ 'pong)
                                                (let ((_data117833_
                                                       _tl117784117861_))
                                                  (_K117776117825_
                                                   _data117833_))
                                                (if (##eq? _hd117783117859_
                                                           'close)
                                                    (let ((_how117817_
                                                           _tl117784117861_))
                                                      (_K117773117809_
                                                       _how117817_))
                                                    (let ((_bogus117799_
                                                           _g117765117786_))
                                                      (_K117772117796_
                                                       _bogus117799_)))))))
                                  (let ((_bogus117799_ _g117765117786_))
                                    (_K117772117796_ _bogus117799_)))))))))
                   (lambda ()
                     (with-exception-catcher
                      void
                      (lambda () (close-output-port _port117752_))))))))
          (if (##structure-direct-instance-of?
               _ws117739117745_
               'std/net/websocket#websocket::t)
              (let* ((_e117743117871_ (##vector-ref _ws117739117745_ '1))
                     (_port117874_ _e117743117871_))
                (_K117742117868_ _port117874_))
              (_E117741117749_)))))))
