(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/kqueue#kqueue
    (lambda ()
      (let* ((_fd145315_
              (let ((_r145312_ (std/os/kqueue#_kqueue)))
                (if (not (##fxnegative? _r145312_))
                    _r145312_
                    (std/os/error#raise-os-error
                     (##fx- _r145312_)
                     std/os/kqueue#kqueue))))
             (_raw145317_ (std/os/fd#fdopen _fd145315_ 'in 'kqueue)))
        (std/os/fcntl#fd-set-closeonexec _raw145317_)
        _raw145317_)))
  (define std/os/kqueue#kqueue-close
    (lambda (_kq145309_) (close-port _kq145309_)))
  (define std/os/kqueue#make-kevents
    (lambda (_size145304_)
      (let ((_r145306_ (std/os/kqueue#make_kevents _size145304_)))
        (if _r145306_
            _r145306_
            (error '"Error allocating memory" 'make_kevents)))))
  (define std/os/kqueue#kevent-set!__%
    (lambda (_g145319_
             _ident145255145263_
             _filter145256145265_
             _flags145257145267_
             _filter-flags145258145269_
             _data145259145271_
             _user-data145260145273_
             _kevts145275_
             _ix145276_)
      (let* ((_ident145278_
              (if (eq? _ident145255145263_ absent-value)
                  (error '"Missing required keyword argument" 'ident:)
                  _ident145255145263_))
             (_filter145280_
              (if (eq? _filter145256145265_ absent-value)
                  (error '"Missing required keyword argument" 'filter:)
                  _filter145256145265_))
             (_flags145282_
              (if (eq? _flags145257145267_ absent-value)
                  '0
                  _flags145257145267_))
             (_filter-flags145284_
              (if (eq? _filter-flags145258145269_ absent-value)
                  '0
                  _filter-flags145258145269_))
             (_data145286_
              (if (eq? _data145259145271_ absent-value) '0 _data145259145271_))
             (_user-data145288_
              (if (eq? _user-data145260145273_ absent-value)
                  '#f
                  _user-data145260145273_)))
        (std/os/kqueue#ev_set
         _kevts145275_
         _ix145276_
         _ident145278_
         _filter145280_
         _flags145282_
         _filter-flags145284_
         _data145286_
         _user-data145288_))))
  (define std/os/kqueue#kevent-set!__@
    (lambda (_keys145254145293_ . _args145295_)
      (apply std/os/kqueue#kevent-set!__%
             _keys145254145293_
             (table-ref _keys145254145293_ 'ident: absent-value)
             (table-ref _keys145254145293_ 'filter: absent-value)
             (table-ref _keys145254145293_ 'flags: absent-value)
             (table-ref _keys145254145293_ 'filter-flags: absent-value)
             (table-ref _keys145254145293_ 'data: absent-value)
             (table-ref _keys145254145293_ 'user-data: absent-value)
             _args145295_)))
  (define std/os/kqueue#kevent-set!
    (lambda _args145261145301_
      (apply keyword-dispatch
             '#(#f
                #f
                #f
                #f
                #f
                filter:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                data:
                #f
                filter-flags:
                #f
                #f
                flags:
                #f
                #f
                ident:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                user-data:
                #f
                #f
                #f
                #f
                #f
                #f)
             std/os/kqueue#kevent-set!__@
             _args145261145301_)))
  (define std/os/kqueue#kevent
    (lambda (_kqueue145237_
             _change-list145238_
             _nchanges145239_
             _event-list145240_
             _nevents145241_)
      (let _lp145243_ ()
        (let ((_r145247_
               (std/os/kqueue#_kevent
                (std/os/fd#fd-e _kqueue145237_)
                _change-list145238_
                _nchanges145239_
                _event-list145240_
                _nevents145241_
                std/os/kqueue#timespec-zero)))
          (if (not (##fxnegative? _r145247_))
              _r145247_
              (let ((_errno145250_ (##fx- _r145247_)))
                (if '#f
                    '#f
                    (if (eq? _errno145250_ std/os/error#EINTR)
                        (_lp145243_)
                        (std/os/error#raise-os-error
                         _errno145250_
                         std/os/kqueue#kevent
                         _kqueue145237_
                         _change-list145238_
                         _nchanges145239_
                         _event-list145240_
                         _nevents145241_)))))))))
  (define std/os/kqueue#kqueue-poll
    (lambda (_kqueue145233_ _events145234_ _nevents145235_)
      (std/os/kqueue#kevent
       _kqueue145233_
       '#f
       '0
       _events145234_
       _nevents145235_)))
  (define std/os/kqueue#kqueue-kevent-add__%
    (lambda (_kqueue145187_
             _dev145188_
             _filter145189_
             _additional-flags145190_
             _filter-flags145191_
             _data145192_)
      (let ((_kevt145194_ (std/os/kqueue#get-kevent-ptr)))
        (std/os/kqueue#kevent-set!__%
         '#f
         (if (std/os/fd#fd? _dev145188_)
             (std/os/fd#fd-e _dev145188_)
             _dev145188_)
         _filter145189_
         (##fxior std/os/kqueue#EV_ADD _additional-flags145190_)
         _filter-flags145191_
         _data145192_
         absent-value
         _kevt145194_
         '0)
        (std/os/kqueue#kevent _kqueue145187_ _kevt145194_ '1 '#f '0))))
  (define std/os/kqueue#kqueue-kevent-add__0
    (lambda (_kqueue145199_ _dev145200_ _filter145201_)
      (let* ((_additional-flags145203_ '0)
             (_filter-flags145205_ '0)
             (_data145207_ '0))
        (std/os/kqueue#kqueue-kevent-add__%
         _kqueue145199_
         _dev145200_
         _filter145201_
         _additional-flags145203_
         _filter-flags145205_
         _data145207_))))
  (define std/os/kqueue#kqueue-kevent-add__1
    (lambda (_kqueue145209_
             _dev145210_
             _filter145211_
             _additional-flags145212_)
      (let* ((_filter-flags145214_ '0) (_data145216_ '0))
        (std/os/kqueue#kqueue-kevent-add__%
         _kqueue145209_
         _dev145210_
         _filter145211_
         _additional-flags145212_
         _filter-flags145214_
         _data145216_))))
  (define std/os/kqueue#kqueue-kevent-add__2
    (lambda (_kqueue145218_
             _dev145219_
             _filter145220_
             _additional-flags145221_
             _filter-flags145222_)
      (let ((_data145224_ '0))
        (std/os/kqueue#kqueue-kevent-add__%
         _kqueue145218_
         _dev145219_
         _filter145220_
         _additional-flags145221_
         _filter-flags145222_
         _data145224_))))
  (define std/os/kqueue#kqueue-kevent-add
    (lambda _g145321_
      (let ((_g145320_ (length _g145321_)))
        (cond ((##fx= _g145320_ 3)
               (apply std/os/kqueue#kqueue-kevent-add__0 _g145321_))
              ((##fx= _g145320_ 4)
               (apply std/os/kqueue#kqueue-kevent-add__1 _g145321_))
              ((##fx= _g145320_ 5)
               (apply std/os/kqueue#kqueue-kevent-add__2 _g145321_))
              ((##fx= _g145320_ 6)
               (apply std/os/kqueue#kqueue-kevent-add__% _g145321_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/kqueue#kqueue-kevent-add
                _g145321_))))))
  (define std/os/kqueue#kqueue-kevent-del
    (lambda (_kqueue145180_ _dev145181_ _filter145182_)
      (let ((_kevt145184_ (std/os/kqueue#get-kevent-ptr)))
        (std/os/kqueue#kevent-set!__%
         '#f
         (if (std/os/fd#fd? _dev145181_)
             (std/os/fd#fd-e _dev145181_)
             _dev145181_)
         _filter145182_
         std/os/kqueue#EV_DELETE
         absent-value
         absent-value
         absent-value
         _kevt145184_
         '0)
        (std/os/kqueue#kevent _kqueue145180_ _kevt145184_ '1 '#f '0))))
  (define std/os/kqueue#kqueue-kevent-disable
    (lambda (_kqueue145174_ _dev145175_ _filter145176_)
      (let ((_kevt145178_ (std/os/kqueue#get-kevent-ptr)))
        (std/os/kqueue#kevent-set!__%
         '#f
         (if (std/os/fd#fd? _dev145175_)
             (std/os/fd#fd-e _dev145175_)
             _dev145175_)
         _filter145176_
         std/os/kqueue#EV_DISABLE
         absent-value
         absent-value
         absent-value
         _kevt145178_
         '0)
        (std/os/kqueue#kevent _kqueue145174_ _kevt145178_ '1 '#f '0))))
  (define std/os/kqueue#kevent-ptr-key 'std/os/kqueue#kevent-ptr)
  (define std/os/kqueue#get-kevent-ptr
    (lambda ()
      (let ((_$e145166_
             (gerbil/gambit/threads#thread-local-get
              std/os/kqueue#kevent-ptr-key)))
        (if _$e145166_
            (values _$e145166_)
            (let ((_kevent-ptr145172_
                   (let ((_r145169_ (std/os/kqueue#make_kevents '1)))
                     (if _r145169_
                         _r145169_
                         (error '"Error allocating memory" 'make_kevents)))))
              (gerbil/gambit/threads#thread-local-set!
               std/os/kqueue#kevent-ptr-key
               _kevent-ptr145172_)
              _kevent-ptr145172_)))))
  (define std/os/kqueue#timespec-zero (std/os/kqueue#make-timespec '0 '0))
  (define std/os/kqueue#make-timespec
    (lambda (_seconds145157_ _nanoseconds145158_)
      (let ((_timespec145163_
             (let ((_r145160_ (std/os/kqueue#make_timespec)))
               (if _r145160_
                   _r145160_
                   (error '"Error allocating memory" 'make_timespec)))))
        (std/os/kqueue#timespec_seconds_set _timespec145163_ _seconds145157_)
        (std/os/kqueue#timespec_nanoseconds_set
         _timespec145163_
         _nanoseconds145158_)
        _timespec145163_)))
  (define std/os/kqueue#kevent-ident std/os/kqueue#kevent_ident)
  (define std/os/kqueue#kevent-filter std/os/kqueue#kevent_filter)
  (define std/os/kqueue#kevent-flags std/os/kqueue#kevent_flags)
  (define std/os/kqueue#kevent-fflags std/os/kqueue#kevent_fflags)
  (define std/os/kqueue#kevent-data std/os/kqueue#kevent_data)
  (define std/os/kqueue#kevent-udata std/os/kqueue#kevent_udata)
  (define std/os/kqueue#set-kevent-ident! std/os/kqueue#kevent_ident_set)
  (define std/os/kqueue#set-kevent-filter! std/os/kqueue#kevent_filter_set)
  (define std/os/kqueue#set-kevent-flags! std/os/kqueue#kevent_flags_set)
  (define std/os/kqueue#set-kevent-fflags! std/os/kqueue#kevent_fflags_set)
  (define std/os/kqueue#set-kevent-data! std/os/kqueue#kevent_data_set)
  (define std/os/kqueue#set-kevent-udata! std/os/kqueue#kevent_udata_set)
  (define-cond-expand-feature openbsd)
  (c-declare "#include <errno.h>")
  (c-declare "#include <stdlib.h>")
  (c-declare "#include <sys/types.h>")
  (c-declare "#include <sys/event.h>")
  (c-declare "#include <sys/time.h>")
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (##symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (##symbol->string symbol))
           (ref (##string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args))) (if (##fx< r 0) (##fx- (__errno)) r))))
  (namespace
   ("std/os/kqueue#"
    EV_ADD
    EV_ENABLE
    EV_DISABLE
    EV_DELETE
    EV_RECEIPT
    EV_ONESHOT
    EV_CLEAR
    EV_EOF
    EV_ERROR
    EVFILT_READ
    EVFILT_WRITE
    EVFILT_VNODE
    EVFILT_PROC
    EVFILT_SIGNAL
    EVFILT_TIMER
    NOTE_WRITE
    NOTE_DELETE
    NOTE_EXTEND
    NOTE_ATTRIB
    NOTE_LINK
    NOTE_RENAME
    NOTE_REVOKE
    NOTE_EXIT
    NOTE_FORK
    NOTE_EXEC
    EV_DISPATCH
    EVFILT_DEVICE
    NOTE_TRUNCATE
    NOTE_TRACK
    NOTE_TRACKERR
    NOTE_CHANGE
    EVFILT_AIO
    EVFILT_FS
    EVFILT_PROCDESC
    EVFILT_USER
    NOTE_CLOSE
    NOTE_CLOSE_WRITE
    NOTE_OPEN
    NOTE_READ
    NOTE_SECONDS
    NOTE_MSECONDS
    NOTE_USECONDS
    NOTE_NSECONDS
    NOTE_FFNOP
    NOTE_FFAND
    NOTE_FFOR
    NOTE_FFCOPY
    NOTE_FFCTRLMASK
    NOTE_FFLAGSMASK
    EV_OOBAND
    EVFILT_MACHPORT
    NOTE_LOWAT
    NOTE_EXITSTATUS
    NOTE_SIGNAL
    NOTE_REAP
    NOTE_ABSOLUTE
    NOTE_CRITICAL
    NOTE_BACKGROUND
    NOTE_LEEWAY
    kevent
    kevent*
    timespec
    timespec*
    make_timespec
    timespec_seconds_set
    timespec_nanoseconds_set
    __errno
    __kqueue
    __kevent
    _kqueue
    _kevent
    make_kevents
    kevent_ident
    kevent_ident_set
    kevent_filter
    kevent_filter_set
    kevent_flags
    kevent_flags_set
    kevent_fflags
    kevent_fflags_set
    kevent_data
    kevent_data_set
    kevent_udata
    kevent_udata_set
    ev_set))
  (define-const EV_ADD)
  (define-const EV_ENABLE)
  (define-const EV_DISABLE)
  (define-const EV_DELETE)
  (define-const EV_ONESHOT)
  (define-const EV_CLEAR)
  (define-const EV_EOF)
  (define-const EV_ERROR)
  (cond-expand
   ((or openbsd freebsd) (define-const EV_RECEIPT) (define-const EV_DISPATCH))
   (netbsd)
   (darwin (define-const EV_RECEIPT) (define-const EV_OOBAND)))
  (define-const EVFILT_READ)
  (define-const EVFILT_WRITE)
  (define-const EVFILT_VNODE)
  (define-const EVFILT_PROC)
  (define-const EVFILT_SIGNAL)
  (define-const EVFILT_TIMER)
  (cond-expand
   (openbsd (define-const EVFILT_DEVICE))
   (netbsd (define-const EVFILT_AIO))
   (freebsd (define-const EVFILT_AIO)
            (define-const EVFILT_PROCDESC)
            (define-const EVFILT_USER))
   (darwin (define-const EVFILT_AIO) (define-const EVFILT_MACHPORT)))
  (define-const NOTE_WRITE)
  (define-const NOTE_DELETE)
  (define-const NOTE_EXTEND)
  (define-const NOTE_ATTRIB)
  (define-const NOTE_LINK)
  (define-const NOTE_RENAME)
  (define-const NOTE_REVOKE)
  (define-const NOTE_EXIT)
  (define-const NOTE_FORK)
  (define-const NOTE_EXEC)
  (define-const NOTE_LOWAT)
  (cond-expand
   (openbsd (define-const NOTE_TRUNCATE)
            (define-const NOTE_TRACK)
            (define-const NOTE_TRACKERR)
            (define-const NOTE_CHANGE))
   (netbsd (define-const NOTE_TRACK) (define-const NOTE_TRACKERR))
   (freebsd (define-const NOTE_CLOSE)
            (define-const NOTE_CLOSE_WRITE)
            (define-const NOTE_OPEN)
            (define-const NOTE_READ)
            (define-const NOTE_TRACK)
            (define-const NOTE_SECONDS)
            (define-const NOTE_MSECONDS)
            (define-const NOTE_USECONDS)
            (define-const NOTE_NSECONDS)
            (define-const NOTE_FFNOP)
            (define-const NOTE_FFAND)
            (define-const NOTE_FFOR)
            (define-const NOTE_FFCOPY)
            (define-const NOTE_FFCTRLMASK)
            (define-const NOTE_FFLAGSMASK))
   (darwin (define-const NOTE_EXITSTATUS)
           (define-const NOTE_SIGNAL)
           (define-const NOTE_REAP)
           (define-const NOTE_SECONDS)
           (define-const NOTE_USECONDS)
           (define-const NOTE_NSECONDS)
           (define-const NOTE_ABSOLUTE)
           (define-const NOTE_CRITICAL)
           (define-const NOTE_BACKGROUND)
           (define-const NOTE_LEEWAY)))
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-define-type kevent (struct "kevent"))
  (c-define-type kevent* (pointer kevent (kevent*) "ffi_free"))
  (define-guard ffi-have-timespec (c-define-type timespec (struct "timespec")))
  (define-guard
   ffi-have-timespec*
   (c-define-type timespec* (pointer timespec (timespec*) "ffi_free")))
  (define-c-lambda
   make_timespec
   ()
   timespec*
   "___return ((struct timespec*)malloc(sizeof(struct timespec)));")
  (define-c-lambda
   timespec_seconds_set
   (timespec* int)
   void
   "___arg1->tv_sec = ___arg2; ___return ;")
  (define-c-lambda
   timespec_nanoseconds_set
   (timespec* int)
   void
   "___arg1->tv_nsec = ___arg2; ___return ;")
  (define-c-lambda __errno () int "___return (errno);")
  (define-c-lambda __kqueue () int "kqueue")
  (define-c-lambda
   __kevent
   (int kevent* int kevent* int timespec*)
   int
   "kevent")
  (define-with-errno _kqueue __kqueue ())
  (define-with-errno _kevent __kevent (kqfd chgs nchgs evts nevts timeo))
  (define-c-lambda
   make_kevents
   (int)
   kevent*
   "___return ((struct kevent*)malloc (___arg1 * sizeof (struct kevent)));")
  (define-c-lambda
   kevent_ident
   (kevent* int)
   unsigned-int
   "___return (___arg1[___arg2].ident);")
  (define-c-lambda
   kevent_ident_set
   (kevent* int unsigned-int)
   void
   "___arg1[___arg2].ident = ___arg3; ___return;")
  (define-c-lambda
   kevent_filter
   (kevent* int)
   short
   "___return (___arg1[___arg2].filter);")
  (define-c-lambda
   kevent_filter_set
   (kevent* int short)
   void
   "___arg1[___arg2].filter = ___arg3; ___return;")
  (define-c-lambda
   kevent_flags
   (kevent* int)
   unsigned-short
   "___return (___arg1[___arg2].flags);")
  (define-c-lambda
   kevent_flags_set
   (kevent* int unsigned-short)
   void
   "___arg1[___arg2].flags = ___arg3; ___return;")
  (define-c-lambda
   kevent_fflags
   (kevent* int)
   unsigned-int
   "___return (___arg1[___arg2].fflags);")
  (define-c-lambda
   kevent_fflags_set
   (kevent* int unsigned-int)
   void
   "___arg1[___arg2].fflags = ___arg3; ___return;")
  (define-c-lambda
   kevent_data
   (kevent* int)
   int64
   "___return (___arg1[___arg2].data);")
  (define-c-lambda
   kevent_data_set
   (kevent* int int64)
   void
   "___arg1[___arg2].data = ___arg3; ___return;")
  (define-c-lambda
   kevent_udata
   (kevent* int)
   (pointer void)
   "___return (___arg1[___arg2].udata);")
  (define-c-lambda
   kevent_udata_set
   (kevent* int (pointer void))
   void
   "___arg1[___arg2].udata = ___arg3; ___return;")
  (define-c-lambda
   ev_set
   (kevent* int
            unsigned-int
            short
            unsigned-short
            unsigned-int
            int64
            (pointer void))
   void
   "EV_SET(&___arg1[___arg2], ___arg3, ___arg4, ___arg5, ___arg6, ___arg7, ___arg8); ___return;")
  (c-declare
   "#ifndef __HAVE_FFI_FREE\n#define __HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free(ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
