/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public final class PackageError
extends LispError {
    public PackageError(LispObject initArgs) {
        super(StandardClass.PACKAGE_ERROR);
        this.initialize(initArgs);
    }

    @Override
    protected void initialize(LispObject initArgs) {
        super.initialize(initArgs);
        if (initArgs.listp() && initArgs.car().stringp()) {
            this.setFormatControl(initArgs.car().getStringValue());
            for (LispObject arg = initArgs.cdr(); arg != Lisp.NIL; arg = arg.cdr()) {
                if (!(arg.car() instanceof Symbol)) continue;
                arg.setCar(new SimpleString(((Symbol)arg.car()).getQualifiedName()));
            }
            this.setFormatArguments(initArgs.cdr());
            this.setPackage(Lisp.NIL);
            return;
        }
        LispObject pkg = Lisp.NIL;
        while (initArgs != Lisp.NIL) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            LispObject second = initArgs.car();
            initArgs = initArgs.cdr();
            if (first != Keyword.PACKAGE) continue;
            pkg = second;
        }
        this.setPackage(pkg);
    }

    public PackageError(String message) {
        super(StandardClass.PACKAGE_ERROR);
        this.setFormatControl(message);
        this.setPackage(Lisp.NIL);
    }

    public PackageError(String message, LispObject pkg) {
        super(StandardClass.PACKAGE_ERROR);
        this.setFormatControl(message);
        this.setPackage(pkg);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.PACKAGE_ERROR;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.PACKAGE_ERROR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.PACKAGE_ERROR) {
            return Lisp.T;
        }
        if (type == StandardClass.PACKAGE_ERROR) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public LispObject getPackage() {
        return this.getInstanceSlotValue(Symbol.PACKAGE);
    }

    public void setPackage(LispObject pkg) {
        this.setInstanceSlotValue(Symbol.PACKAGE, pkg);
    }
}

