/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store.proto;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.MessageBuffer;
import org.fusesource.hawtbuf.proto.MessageBufferSupport;
import org.fusesource.hawtbuf.proto.PBMessage;
import org.fusesource.hawtbuf.proto.PBMessageFactory;
import org.fusesource.hawtbuf.proto.PBMessageFramedCodec;
import org.fusesource.hawtbuf.proto.PBMessageUnframedCodec;

public class MapEntryPB
implements PBMessageFactory<Bean, Buffer> {
    public static final MapEntryPB FACTORY = new MapEntryPB();
    public static final PBMessageFramedCodec<Buffer> FRAMED_CODEC = new PBMessageFramedCodec((PBMessageFactory)FACTORY);
    public static final PBMessageUnframedCodec<Buffer> UNFRAMED_CODEC = new PBMessageUnframedCodec((PBMessageFactory)FACTORY);

    public Bean create() {
        return new Bean();
    }

    public Bean parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return new Bean().mergeUnframed(data);
    }

    public Bean parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(new CodedInputStream(data));
    }

    public Buffer parseUnframed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        return new Buffer(data);
    }

    public Buffer parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseUnframed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        int length = data.readRawVarint32();
        int oldLimit = data.pushLimit(length);
        Buffer rc = this.parseUnframed(data.readRawBytes(length));
        data.popLimit(oldLimit);
        return rc;
    }

    public Buffer parseFramed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            Buffer rc = this.parseFramed(input);
            input.checkLastTagWas(0);
            return rc;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    public Buffer parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseFramed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(MessageBufferSupport.readFrame((InputStream)data));
    }

    public static final class Buffer
    implements MessageBuffer<Bean, Buffer>,
    Getter {
        private Bean bean;
        private org.fusesource.hawtbuf.Buffer buffer;
        private int size = -1;
        private int hashCode;

        private Buffer(org.fusesource.hawtbuf.Buffer buffer) {
            this.buffer = buffer;
        }

        private Buffer(Bean bean) {
            this.bean = bean;
        }

        @Override
        public Bean copy() {
            return this.bean().copy();
        }

        @Override
        public Buffer freeze() {
            return this;
        }

        private Bean bean() {
            if (this.bean == null) {
                try {
                    this.bean = new Bean().mergeUnframed(new CodedInputStream(this.buffer));
                    this.bean.frozen = this;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
                }
            }
            return this.bean;
        }

        public String toString() {
            return this.bean().toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            return this.bean().toString(sb, prefix);
        }

        @Override
        public boolean hasKey() {
            return this.bean().hasKey();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getKey() {
            return this.bean().getKey();
        }

        @Override
        public boolean hasValue() {
            return this.bean().hasValue();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getValue() {
            return this.bean().getValue();
        }

        public org.fusesource.hawtbuf.Buffer toUnframedBuffer() {
            if (this.buffer != null) {
                return this.buffer;
            }
            return MessageBufferSupport.toUnframedBuffer((MessageBuffer)this);
        }

        public org.fusesource.hawtbuf.Buffer toFramedBuffer() {
            return MessageBufferSupport.toFramedBuffer((MessageBuffer)this);
        }

        public byte[] toUnframedByteArray() {
            return this.toUnframedBuffer().toByteArray();
        }

        public byte[] toFramedByteArray() {
            return this.toFramedBuffer().toByteArray();
        }

        public void writeFramed(CodedOutputStream output) throws IOException {
            output.writeRawVarint32(this.serializedSizeUnframed());
            this.writeUnframed(output);
        }

        public void writeFramed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeFramed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeUnframed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(CodedOutputStream output) throws IOException {
            if (this.buffer == null) {
                int size = this.serializedSizeUnframed();
                this.buffer = output.getNextBuffer(size);
                CodedOutputStream original = null;
                if (this.buffer == null) {
                    this.buffer = new org.fusesource.hawtbuf.Buffer(new byte[size]);
                    original = output;
                    output = new CodedOutputStream(this.buffer);
                }
                output.writeBytes(1, this.bean.getKey());
                if (this.bean.hasValue()) {
                    output.writeBytes(2, this.bean.getValue());
                }
                if (original != null) {
                    output.checkNoSpaceLeft();
                    output = original;
                    output.writeRawBytes(this.buffer);
                }
            } else {
                output.writeRawBytes(this.buffer);
            }
        }

        public int serializedSizeFramed() {
            int t = this.serializedSizeUnframed();
            return CodedOutputStream.computeRawVarint32Size((int)t) + t;
        }

        public int serializedSizeUnframed() {
            if (this.buffer != null) {
                return this.buffer.length;
            }
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            this.size += CodedOutputStream.computeBytesSize((int)1, (org.fusesource.hawtbuf.Buffer)this.getKey());
            if (this.hasValue()) {
                this.size += CodedOutputStream.computeBytesSize((int)2, (org.fusesource.hawtbuf.Buffer)this.getValue());
            }
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Buffer.class) {
                return false;
            }
            return this.equals((Buffer)obj);
        }

        public boolean equals(Buffer obj) {
            return this.toUnframedBuffer().equals(obj.toUnframedBuffer());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 0x77408060 ^ this.toUnframedBuffer().hashCode();
            }
            return this.hashCode;
        }

        public boolean frozen() {
            return true;
        }
    }

    public static final class Bean
    implements Getter {
        Buffer frozen;
        Bean bean;
        private org.fusesource.hawtbuf.Buffer f_key = null;
        private org.fusesource.hawtbuf.Buffer f_value = null;

        public Bean() {
            this.bean = this;
        }

        public Bean(Bean copy) {
            this.bean = copy;
        }

        @Override
        public Bean copy() {
            return new Bean(this.bean);
        }

        public boolean frozen() {
            return this.frozen != null;
        }

        @Override
        public Buffer freeze() {
            if (this.frozen == null) {
                this.frozen = new Buffer(this.bean);
                assert (this.deepFreeze());
            }
            return this.frozen;
        }

        private boolean deepFreeze() {
            this.frozen.serializedSizeUnframed();
            return true;
        }

        private void copyCheck() {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            if (this.bean != this) {
                this.copy(this.bean);
            }
        }

        private void copy(Bean other) {
            this.bean = this;
            this.f_key = other.f_key;
            this.f_value = other.f_value;
        }

        @Override
        public boolean hasKey() {
            return this.bean.f_key != null;
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getKey() {
            return this.bean.f_key;
        }

        public Bean setKey(org.fusesource.hawtbuf.Buffer key) {
            this.copyCheck();
            this.f_key = key;
            return this;
        }

        public void clearKey() {
            this.copyCheck();
            this.f_key = null;
        }

        @Override
        public boolean hasValue() {
            return this.bean.f_value != null;
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getValue() {
            return this.bean.f_value;
        }

        public Bean setValue(org.fusesource.hawtbuf.Buffer value) {
            this.copyCheck();
            this.f_value = value;
            return this;
        }

        public void clearValue() {
            this.copyCheck();
            this.f_value = null;
        }

        public String toString() {
            return this.toString(new StringBuilder(), "").toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            if (this.hasKey()) {
                sb.append(prefix + "key: ");
                sb.append(this.getKey());
                sb.append("\n");
            }
            if (this.hasValue()) {
                sb.append(prefix + "value: ");
                sb.append(this.getValue());
                sb.append("\n");
            }
            return sb;
        }

        public Bean mergeUnframed(InputStream input) throws IOException {
            return this.mergeUnframed(new CodedInputStream(input));
        }

        public Bean mergeUnframed(CodedInputStream input) throws IOException {
            this.copyCheck();
            int tag;
            block5: while (((tag = input.readTag()) & 7) != 4) {
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        input.skipField(tag);
                        continue block5;
                    }
                    case 10: {
                        this.setKey(input.readBytes());
                        continue block5;
                    }
                    case 18: 
                }
                this.setValue(input.readBytes());
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Bean.class) {
                return false;
            }
            return this.equals((Bean)obj);
        }

        public boolean equals(Bean obj) {
            if (this.hasKey() ^ obj.hasKey()) {
                return false;
            }
            if (this.hasKey() && !this.getKey().equals(obj.getKey())) {
                return false;
            }
            if (this.hasValue() ^ obj.hasValue()) {
                return false;
            }
            return !this.hasValue() || this.getValue().equals(obj.getValue());
        }

        public int hashCode() {
            int rc = 2066384;
            if (this.hasKey()) {
                rc ^= 0x1263F ^ this.getKey().hashCode();
            }
            if (this.hasValue()) {
                rc ^= 0x4E9A151 ^ this.getValue().hashCode();
            }
            return rc;
        }

        public Bean mergeFrom(Getter other) {
            this.copyCheck();
            if (other.hasKey()) {
                this.setKey(other.getKey());
            }
            if (other.hasValue()) {
                this.setValue(other.getValue());
            }
            return this;
        }

        public void clear() {
            this.clearKey();
            this.clearValue();
        }

        public void readExternal(DataInput in) throws IOException {
            byte[] b;
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            this.bean = this;
            this.frozen = null;
            int size = in.readInt();
            if (size >= 0) {
                b = new byte[size];
                in.readFully(b);
                this.f_key = new org.fusesource.hawtbuf.Buffer(b);
            } else {
                this.f_key = null;
            }
            size = in.readInt();
            if (size >= 0) {
                b = new byte[size];
                in.readFully(b);
                this.f_value = new org.fusesource.hawtbuf.Buffer(b);
            } else {
                this.f_value = null;
            }
        }

        public void writeExternal(DataOutput out) throws IOException {
            if (this.bean.f_key != null) {
                out.writeInt(this.bean.f_key.getLength());
                out.write(this.bean.f_key.getData(), this.bean.f_key.getOffset(), this.bean.f_key.getLength());
            } else {
                out.writeInt(-1);
            }
            if (this.bean.f_value != null) {
                out.writeInt(this.bean.f_value.getLength());
                out.write(this.bean.f_value.getData(), this.bean.f_value.getOffset(), this.bean.f_value.getLength());
            } else {
                out.writeInt(-1);
            }
        }
    }

    public static interface Getter
    extends PBMessage<Bean, Buffer> {
        public boolean hasKey();

        public org.fusesource.hawtbuf.Buffer getKey();

        public boolean hasValue();

        public org.fusesource.hawtbuf.Buffer getValue();

        public Bean copy();

        public Buffer freeze();

        public StringBuilder toString(StringBuilder var1, String var2);
    }
}

