import*as Common from'../common/common.js';import*as SDK from'../sdk/sdk.js';import*as Workspace from'../workspace/workspace.js';import{ContentProviderBasedProject}from'./ContentProviderBasedProject.js';import{SourceMapping}from'./CSSWorkspaceBinding.js';import{NetworkProject}from'./NetworkProject.js';export class SASSSourceMapping{constructor(target,sourceMapManager,workspace){this._sourceMapManager=sourceMapManager;this._project=new ContentProviderBasedProject(workspace,'cssSourceMaps:'+target.id(),Workspace.Workspace.projectTypes.Network,'',false);NetworkProject.setTargetForProject(this._project,target);this._eventListeners=[this._sourceMapManager.addEventListener(SDK.SourceMapManager.Events.SourceMapAttached,this._sourceMapAttached,this),this._sourceMapManager.addEventListener(SDK.SourceMapManager.Events.SourceMapDetached,this._sourceMapDetached,this),this._sourceMapManager.addEventListener(SDK.SourceMapManager.Events.SourceMapChanged,this._sourceMapChanged,this)];}
_sourceMapAttachedForTest(sourceMap){}
_sourceMapAttached(event){const header=(event.data.client);const sourceMap=(event.data.sourceMap);for(const sassURL of sourceMap.sourceURLs()){let uiSourceCode=this._project.uiSourceCodeForURL(sassURL);if(uiSourceCode){NetworkProject.addFrameAttribution(uiSourceCode,header.frameId);continue;}
const contentProvider=sourceMap.sourceContentProvider(sassURL,Common.ResourceType.resourceTypes.SourceMapStyleSheet);const mimeType=Common.ResourceType.ResourceType.mimeFromURL(sassURL)||contentProvider.contentType().canonicalMimeType();const embeddedContent=sourceMap.embeddedContentByURL(sassURL);const metadata=typeof embeddedContent==='string'?new Workspace.UISourceCode.UISourceCodeMetadata(null,embeddedContent.length):null;uiSourceCode=this._project.createUISourceCode(sassURL,contentProvider.contentType());NetworkProject.setInitialFrameAttribution(uiSourceCode,header.frameId);uiSourceCode[_sourceMapSymbol]=sourceMap;this._project.addUISourceCodeWithProvider(uiSourceCode,contentProvider,metadata,mimeType);}
self.Bindings.cssWorkspaceBinding.updateLocations(header);this._sourceMapAttachedForTest(sourceMap);}
_sourceMapDetached(event){const header=(event.data.client);const sourceMap=(event.data.sourceMap);const headers=this._sourceMapManager.clientsForSourceMap(sourceMap);for(const sassURL of sourceMap.sourceURLs()){if(headers.length){const uiSourceCode=(this._project.uiSourceCodeForURL(sassURL));NetworkProject.removeFrameAttribution(uiSourceCode,header.frameId);}else{this._project.removeFile(sassURL);}}
self.Bindings.cssWorkspaceBinding.updateLocations(header);}
_sourceMapChanged(event){const sourceMap=(event.data.sourceMap);const newSources=(event.data.newSources);const headers=this._sourceMapManager.clientsForSourceMap(sourceMap);for(const sourceURL of newSources.keys()){const uiSourceCode=this._project.uiSourceCodeForURL(sourceURL);if(!uiSourceCode){console.error('Failed to update source for '+sourceURL);continue;}
const sassText=(newSources.get(sourceURL));uiSourceCode.setWorkingCopy(sassText);}
for(const header of headers){self.Bindings.cssWorkspaceBinding.updateLocations(header);}}
rawLocationToUILocation(rawLocation){const header=rawLocation.header();if(!header){return null;}
const sourceMap=this._sourceMapManager.sourceMapForClient(header);if(!sourceMap){return null;}
const entry=sourceMap.findEntry(rawLocation.lineNumber,rawLocation.columnNumber);if(!entry||!entry.sourceURL){return null;}
const uiSourceCode=this._project.uiSourceCodeForURL(entry.sourceURL);if(!uiSourceCode){return null;}
return uiSourceCode.uiLocation(entry.sourceLineNumber||0,entry.sourceColumnNumber);}
uiLocationToRawLocations(uiLocation){const sourceMap=uiLocation.uiSourceCode[_sourceMapSymbol];if(!sourceMap){return[];}
const entries=sourceMap.findReverseEntries(uiLocation.uiSourceCode.url(),uiLocation.lineNumber,uiLocation.columnNumber);const locations=[];for(const header of this._sourceMapManager.clientsForSourceMap(sourceMap)){locations.push(...entries.map(entry=>new SDK.CSSModel.CSSLocation(header,entry.lineNumber,entry.columnNumber)));}
return locations;}
dispose(){this._project.dispose();Common.EventTarget.EventTarget.removeEventListeners(this._eventListeners);}}
const _sourceMapSymbol=Symbol('sourceMap');