import*as Common from'../common/common.js';import*as UI from'../ui/ui.js';import{Events}from'./IsolatedFileSystemManager.js';export class EditFileSystemView extends UI.Widget.VBox{constructor(fileSystemPath){super(true);this.registerRequiredCSS('persistence/editFileSystemView.css');this._fileSystemPath=fileSystemPath;this._eventListeners=[self.Persistence.isolatedFileSystemManager.addEventListener(Events.ExcludedFolderAdded,this._update,this),self.Persistence.isolatedFileSystemManager.addEventListener(Events.ExcludedFolderRemoved,this._update,this)];const excludedFoldersHeader=this.contentElement.createChild('div','file-system-header');excludedFoldersHeader.createChild('div','file-system-header-text').textContent=Common.UIString.UIString('Excluded folders');excludedFoldersHeader.appendChild(UI.UIUtils.createTextButton(Common.UIString.UIString('Add'),this._addExcludedFolderButtonClicked.bind(this),'add-button'));this._excludedFoldersList=new UI.ListWidget.ListWidget(this);this._excludedFoldersList.element.classList.add('file-system-list');this._excludedFoldersList.registerRequiredCSS('persistence/editFileSystemView.css');const excludedFoldersPlaceholder=createElementWithClass('div','file-system-list-empty');excludedFoldersPlaceholder.textContent=Common.UIString.UIString('None');this._excludedFoldersList.setEmptyPlaceholder(excludedFoldersPlaceholder);this._excludedFoldersList.show(this.contentElement);this._update();}
dispose(){Common.EventTarget.EventTarget.removeEventListeners(this._eventListeners);}
_update(){if(this._muteUpdate){return;}
this._excludedFoldersList.clear();this._excludedFolders=[];for(const folder of self.Persistence.isolatedFileSystemManager.fileSystem(this._fileSystemPath).excludedFolders().values()){this._excludedFolders.push(folder);this._excludedFoldersList.appendItem(folder,true);}}
_addExcludedFolderButtonClicked(){this._excludedFoldersList.addNewItem(0,'');}
renderItem(item,editable){const element=createElementWithClass('div','file-system-list-item');const pathPrefix=(editable?item:Common.UIString.UIString('%s (via .devtools)',item));const pathPrefixElement=element.createChild('div','file-system-value');pathPrefixElement.textContent=pathPrefix;pathPrefixElement.title=pathPrefix;return element;}
removeItemRequested(item,index){self.Persistence.isolatedFileSystemManager.fileSystem(this._fileSystemPath).removeExcludedFolder(this._excludedFolders[index]);}
commitEdit(item,editor,isNew){this._muteUpdate=true;if(!isNew){self.Persistence.isolatedFileSystemManager.fileSystem(this._fileSystemPath).removeExcludedFolder((item));}
self.Persistence.isolatedFileSystemManager.fileSystem(this._fileSystemPath).addExcludedFolder(this._normalizePrefix(editor.control('pathPrefix').value));this._muteUpdate=false;this._update();}
beginEdit(item){const editor=this._createExcludedFolderEditor();editor.control('pathPrefix').value=item;return editor;}
_createExcludedFolderEditor(){if(this._excludedFolderEditor){return this._excludedFolderEditor;}
const editor=new UI.ListWidget.Editor();this._excludedFolderEditor=editor;const content=editor.contentElement();const titles=content.createChild('div','file-system-edit-row');titles.createChild('div','file-system-value').textContent=Common.UIString.UIString('Folder path');const fields=content.createChild('div','file-system-edit-row');fields.createChild('div','file-system-value').appendChild(editor.createInput('pathPrefix','text','/path/to/folder/',pathPrefixValidator.bind(this)));return editor;function pathPrefixValidator(item,index,input){const prefix=this._normalizePrefix(input.value.trim());if(!prefix){return{valid:false,errorMessage:ls`Enter a path`};}
const configurableCount=self.Persistence.isolatedFileSystemManager.fileSystem(this._fileSystemPath).excludedFolders().size;for(let i=0;i<configurableCount;++i){if(i!==index&&this._excludedFolders[i]===prefix){return{valid:false,errorMessage:ls`Enter a unique path`};}}
return{valid:true};}}
_normalizePrefix(prefix){if(!prefix){return'';}
return prefix+(prefix[prefix.length-1]==='/'?'':'/');}}