/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NamedFunAsExpressionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class NamedFunAsExpressionChecker
implements CallChecker {
    public static final NamedFunAsExpressionChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return;
        }
        for (ExpressionValueArgument argument : CollectionsKt.filterIsInstance((Iterable)resolvedCall2.getValueArguments().values(), ExpressionValueArgument.class)) {
            KtNamedFunction expression2;
            ValueArgument valueArgument = argument.getValueArgument();
            KtExpression ktExpression = KtPsiUtil.deparenthesize(valueArgument != null ? valueArgument.getArgumentExpression() : null);
            if (!(ktExpression instanceof KtNamedFunction)) {
                ktExpression = null;
            }
            if ((KtNamedFunction)ktExpression == null) {
                continue;
            }
            if (KtPsiUtilKt.isFunctionalExpression(expression2)) continue;
            BindingTrace bindingTrace = context.getTrace();
            PsiElement psiElement = expression2.getNameIdentifier();
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement);
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"ANONYMOUS_FUNCTION_WITH_\u2026ression.nameIdentifier!!)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private NamedFunAsExpressionChecker() {
    }

    static {
        NamedFunAsExpressionChecker namedFunAsExpressionChecker;
        INSTANCE = namedFunAsExpressionChecker = new NamedFunAsExpressionChecker();
    }
}

