/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.internal.execution.impl.OutputsCleaner;
import org.gradle.internal.file.FileType;
import org.gradle.language.base.internal.tasks.StaleClassCleaner;

public class SimpleStaleClassCleaner
extends StaleClassCleaner {
    private final Set<File> filesToDelete;
    private final Set<File> toClean = Sets.newHashSet();
    private final Set<String> prefixes = Sets.newHashSet();
    private final Queue<File> directoriesToDelete = new PriorityQueue<File>(10, (Comparator<File>)Ordering.natural().reverse());
    private boolean didWork;

    public SimpleStaleClassCleaner(TaskOutputsInternal taskOutputs) {
        this(taskOutputs.getPreviousOutputFiles());
    }

    public SimpleStaleClassCleaner(Set<File> filesToDelete) {
        this.filesToDelete = filesToDelete;
    }

    @Override
    public void addDirToClean(File toClean) {
        this.toClean.add(toClean);
        this.prefixes.add(toClean.getAbsolutePath() + File.separator);
    }

    @Override
    public void execute() {
        try {
            OutputsCleaner outputsCleaner = new OutputsCleaner((Predicate)new Predicate<File>(){

                @Override
                public boolean test(File file) {
                    for (String prefix : SimpleStaleClassCleaner.this.prefixes) {
                        if (!file.getAbsolutePath().startsWith(prefix)) continue;
                        return true;
                    }
                    return false;
                }
            }, (Predicate)new Predicate<File>(){

                @Override
                public boolean test(File dir) {
                    return !SimpleStaleClassCleaner.this.toClean.contains(dir);
                }
            });
            for (File f : this.filesToDelete) {
                if (!f.isFile()) continue;
                outputsCleaner.cleanupOutput(f, FileType.RegularFile);
            }
            outputsCleaner.cleanupDirectories();
            this.didWork |= outputsCleaner.getDidWork();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to clean up stale outputs", (Throwable)e);
        }
    }

    public boolean getDidWork() {
        return this.didWork;
    }
}

