/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.internal.tasks.properties.LifecycleAwareValue;
import org.gradle.internal.file.PathToFileResolver;

public class CachingTaskInputFileCollection
extends DefaultConfigurableFileCollection
implements LifecycleAwareValue {
    private final FileResolver fileResolver;
    private boolean canCache;
    private MinimalFileSet cachedValue;

    public CachingTaskInputFileCollection(FileResolver fileResolver, TaskResolver taskResolver) {
        super((PathToFileResolver)fileResolver, taskResolver);
        this.fileResolver = fileResolver;
    }

    public void visitContents(FileCollectionResolveContext context) {
        if (this.canCache) {
            if (this.cachedValue == null) {
                DefaultFileCollectionResolveContext nested = new DefaultFileCollectionResolveContext(this.fileResolver.getPatternSetFactory());
                super.visitContents((FileCollectionResolveContext)nested);
                ImmutableSet.Builder files = ImmutableSet.builder();
                for (FileCollectionInternal fileCollection : nested.resolveAsFileCollections()) {
                    files.addAll((Iterable)fileCollection);
                }
                this.cachedValue = new ListBackedFileSet((Collection)files.build());
            }
            context.add((Object)this.cachedValue);
        } else {
            super.visitContents(context);
        }
    }

    @Override
    public void prepareValue() {
        this.canCache = true;
    }

    @Override
    public void cleanupValue() {
        this.canCache = false;
        this.cachedValue = null;
    }
}

