/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.execution;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JavaFxRunConfigurationExtension
extends RunConfigurationExtension {
    private static final String JAVAFX_GRAPHICS = "javafx.graphics";
    private static final String JAVAFX_BASE = "javafx.base";

    public <T extends RunConfigurationBase> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters params, RunnerSettings runnerSettings) {
        if (configuration == null) {
            JavaFxRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (params == null) {
            JavaFxRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        if (!(configuration instanceof ModuleRunProfile) || !(configuration instanceof CommonJavaRunConfigurationParameters)) {
            return;
        }
        Project project = configuration.getProject();
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        String runClass = ((CommonJavaRunConfigurationParameters)configuration).getRunClass();
        if (runClass != null) {
            JavaSdkVersion sdkVersion;
            PsiClass aClass;
            GlobalSearchScope searchScope = ((ModuleRunProfile)configuration).getSearchScope();
            PsiClass psiClass = aClass = searchScope != null ? JavaPsiFacade.getInstance((Project)project).findClass(runClass, searchScope) : null;
            if (aClass != null && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javafx.application.Application") && (sdkVersion = JavaVersionService.getInstance().getJavaSdkVersion((PsiElement)aClass)) != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_11) && params.getModulePath().isEmpty() && JavaPsiFacade.getInstance((Project)project).findModules(JAVAFX_GRAPHICS, searchScope).stream().noneMatch(mod -> JavaFxRunConfigurationExtension.belongsToJdk(mod))) {
                VirtualFile javaFxBase = JavaFxRunConfigurationExtension.getModuleJar(JAVAFX_BASE, project, searchScope);
                VirtualFile javafxGraphics = JavaFxRunConfigurationExtension.getModuleJar(JAVAFX_GRAPHICS, project, searchScope);
                if (javaFxBase != null && javafxGraphics != null) {
                    params.getModulePath().add(javaFxBase);
                    params.getModulePath().add(javafxGraphics);
                    params.getVMParametersList().addParametersString("--add-modules javafx.base,javafx.graphics");
                    params.getVMParametersList().addParametersString("--add-reads javafx.base=ALL-UNNAMED");
                    params.getVMParametersList().addParametersString("--add-reads javafx.graphics=ALL-UNNAMED");
                }
            }
        }
    }

    private static boolean belongsToJdk(PsiJavaModule mod) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)mod);
        return file != null && ProjectRootManager.getInstance((Project)mod.getProject()).getFileIndex().getOrderEntriesForFile(file).stream().anyMatch(e -> e instanceof JdkOrderEntry);
    }

    private static VirtualFile getModuleJar(String moduleName, Project project, GlobalSearchScope searchScope) {
        Collection javaModules = JavaPsiFacade.getInstance((Project)project).findModules(moduleName, searchScope);
        return VfsUtilCore.getVirtualFileForJar((VirtualFile)PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)ContainerUtil.getFirstItem((Collection)javaModules))));
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        if (configuration == null) {
            JavaFxRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/execution/JavaFxRunConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateJavaParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

