/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.validators.PositiveInteger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.baksmali.AnalysisArguments;
import org.jf.baksmali.Baksmali;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.baksmali.DexInputCommand;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.util.SyntheticAccessorResolver;
import org.jf.util.StringWrapper;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;
import org.xml.sax.SAXException;

@Parameters(commandDescription="Disassembles a dex file.")
@ExtendedParameters(commandName="disassemble", commandAliases={"dis", "d"})
public class DisassembleCommand
extends DexInputCommand {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information for this command.")
    private boolean help;
    @ParametersDelegate
    protected AnalysisArguments analysisArguments = new AnalysisArguments();
    @Parameter(names={"--debug-info", "--di"}, arity=1, description="Whether to include debug information in the output (.local, .param, .line, etc.). True by default, use --debug-info=false to disable.")
    @ExtendedParameter(argumentNames={"boolean"})
    private boolean debugInfo = true;
    @Parameter(names={"--code-offsets", "--offsets", "--off"}, description="Add a comment before each instruction with it's code offset within the method.")
    private boolean codeOffsets = false;
    @Parameter(names={"--resolve-resources", "--rr"}, arity=2, description="This will attempt to find any resource id references within the bytecode and add a comment with the name of the resource being referenced. The parameter accepts 2 values:an arbitrary resource prefix and the path to a public.xml file. For example: --resolve-resources android.R framework/res/values/public.xml. This option can be specified multiple times to provide resources from multiple packages.")
    @ExtendedParameter(argumentNames={"resource prefix", "public.xml file"})
    private List<String> resourceIdFiles = Lists.newArrayList();
    @Parameter(names={"-j", "--jobs"}, description="The number of threads to use. Defaults to the number of cores available.", validateWith=PositiveInteger.class)
    @ExtendedParameter(argumentNames={"n"})
    private int jobs = Runtime.getRuntime().availableProcessors();
    @Parameter(names={"-l", "--use-locals"}, description="When disassembling, output the .locals directive with the number of non-parameter registers instead of the .registers directive with the total number of registers.")
    private boolean localsDirective = false;
    @Parameter(names={"--accessor-comments", "--ac"}, arity=1, description="Generate helper comments for synthetic accessors. True by default, use --accessor-comments=false to disable.")
    @ExtendedParameter(argumentNames={"boolean"})
    private boolean accessorComments = true;
    @Parameter(names={"--normalize-virtual-methods", "--norm", "--nvm"}, description="Normalize virtual method references to use the base class where the method is originally declared.")
    private boolean normalizeVirtualMethods = false;
    @Parameter(names={"-o", "--output"}, description="The directory to write the disassembled files to.")
    @ExtendedParameter(argumentNames={"dir"})
    private String outputDir = "out";
    @Parameter(names={"--parameter-registers", "--preg", "--pr"}, arity=1, description="Use the pNN syntax for registers that refer to a method parameter on method entry. True by default, use --parameter-registers=false to disable.")
    @ExtendedParameter(argumentNames={"boolean"})
    private boolean parameterRegisters = true;
    @Parameter(names={"-r", "--register-info"}, description="Add comments before/after each instruction with information about register types. The value is a comma-separated list of any of ALL, ALLPRE, ALLPOST, ARGS, DEST, MERGE and FULLMERGE. See \"baksmali help register-info\" for more information.")
    @ExtendedParameter(argumentNames={"register info specifier"})
    private List<String> registerInfoTypes = Lists.newArrayList();
    @Parameter(names={"--sequential-labels", "--seq", "--sl"}, description="Create label names using a sequential numbering scheme per label type, rather than using the bytecode address.")
    private boolean sequentialLabels = false;
    @Parameter(names={"--implicit-references", "--implicit", "--ir"}, description="Use implicit method and field references (without the class name) for methods and fields from the current class.")
    private boolean implicitReferences = false;
    @Parameter(names={"--allow-odex-opcodes"}, description="Allows odex opcodes to be disassembled, even if the result won't be able to be reassembled.")
    private boolean allowOdex = false;
    @Parameter(names={"--classes"}, description="A comma separated list of classes. Only disassemble these classes")
    @ExtendedParameter(argumentNames={"classes"})
    private List<String> classes = null;

    public DisassembleCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    public void run() {
        File outputDirectoryFile;
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = (String)this.inputList.get(0);
        this.loadDexFile(input);
        if (this.showDeodexWarning() && this.dexFile.hasOdexOpcodes()) {
            StringWrapper.printWrappedString((PrintStream)System.err, (String)"Warning: You are disassembling an odex/oat file without deodexing it. You won't be able to re-assemble the results unless you deodex it. See \"baksmali help deodex\"");
        }
        if (!(outputDirectoryFile = new File(this.outputDir)).exists() && !outputDirectoryFile.mkdirs()) {
            System.err.println("Can't create the output directory " + this.outputDir);
            System.exit(-1);
        }
        if (this.analysisArguments.classPathDirectories == null || this.analysisArguments.classPathDirectories.isEmpty()) {
            this.analysisArguments.classPathDirectories = Lists.newArrayList((Object[])new String[]{this.inputFile.getAbsoluteFile().getParent()});
        }
        if (!Baksmali.disassembleDexFile((DexFile)this.dexFile, outputDirectoryFile, this.jobs, this.getOptions(), this.classes)) {
            System.exit(-1);
        }
    }

    protected boolean needsClassPath() {
        return !this.registerInfoTypes.isEmpty() || this.normalizeVirtualMethods;
    }

    protected boolean shouldCheckPackagePrivateAccess() {
        return false;
    }

    protected boolean showDeodexWarning() {
        return true;
    }

    protected BaksmaliOptions getOptions() {
        if (this.dexFile == null) {
            throw new IllegalStateException("You must call loadDexFile first");
        }
        BaksmaliOptions options = new BaksmaliOptions();
        if (this.needsClassPath()) {
            try {
                options.classPath = this.analysisArguments.loadClassPathForDexFile(this.inputFile.getAbsoluteFile().getParentFile(), (DexFile)this.dexFile, this.shouldCheckPackagePrivateAccess());
            }
            catch (Exception ex) {
                System.err.println("\n\nError occurred while loading class path files. Aborting.");
                ex.printStackTrace(System.err);
                System.exit(-1);
            }
        }
        if (!this.resourceIdFiles.isEmpty()) {
            HashMap resourceFiles = Maps.newHashMap();
            assert (this.resourceIdFiles.size() % 2 == 0);
            for (int i = 0; i < this.resourceIdFiles.size(); i += 2) {
                String resourcePrefix = this.resourceIdFiles.get(i);
                String publicXml = this.resourceIdFiles.get(i + 1);
                File publicXmlFile = new File(publicXml);
                if (!publicXmlFile.exists()) {
                    System.err.println(String.format("Can't find file: %s", publicXmlFile));
                    System.exit(-1);
                }
                resourceFiles.put(resourcePrefix, publicXmlFile);
            }
            try {
                options.loadResourceIds(resourceFiles);
            }
            catch (IOException ex) {
                System.err.println("Error while loading resource files:");
                ex.printStackTrace(System.err);
                System.exit(-1);
            }
            catch (SAXException ex) {
                System.err.println("Error while loading resource files:");
                ex.printStackTrace(System.err);
                System.exit(-1);
            }
        }
        options.parameterRegisters = this.parameterRegisters;
        options.localsDirective = this.localsDirective;
        options.sequentialLabels = this.sequentialLabels;
        options.debugInfo = this.debugInfo;
        options.codeOffsets = this.codeOffsets;
        options.accessorComments = this.accessorComments;
        options.implicitReferences = this.implicitReferences;
        options.normalizeVirtualMethods = this.normalizeVirtualMethods;
        options.registerInfo = 0;
        for (String registerInfoType : this.registerInfoTypes) {
            if (registerInfoType.equalsIgnoreCase("ALL")) {
                options.registerInfo |= 1;
            } else if (registerInfoType.equalsIgnoreCase("ALLPRE")) {
                options.registerInfo |= 2;
            } else if (registerInfoType.equalsIgnoreCase("ALLPOST")) {
                options.registerInfo |= 4;
            } else if (registerInfoType.equalsIgnoreCase("ARGS")) {
                options.registerInfo |= 8;
            } else if (registerInfoType.equalsIgnoreCase("DEST")) {
                options.registerInfo |= 0x10;
            } else if (registerInfoType.equalsIgnoreCase("MERGE")) {
                options.registerInfo |= 0x20;
            } else if (registerInfoType.equalsIgnoreCase("FULLMERGE")) {
                options.registerInfo |= 0x40;
            } else {
                System.err.println(String.format("Invalid register info type: %s", registerInfoType));
                this.usage();
                System.exit(-1);
            }
            if ((options.registerInfo & 0x40) == 0) continue;
            options.registerInfo &= 0xFFFFFFDF;
        }
        if (this.accessorComments) {
            options.syntheticAccessorResolver = new SyntheticAccessorResolver(this.dexFile.getOpcodes(), (Iterable)this.dexFile.getClasses());
        }
        if (this.allowOdex) {
            options.allowOdex = true;
        }
        return options;
    }
}

