/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Parameters;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.Sets;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHelper {
    private static final String JUNIT_TESTRUNNER = "org.testng.junit.JUnitTestRunner";
    private static final String JUNIT_4_TESTRUNNER = "org.testng.junit.JUnit4TestRunner";
    private static final List<ClassLoader> m_classLoaders = new Vector<ClassLoader>();
    private static int m_lastGoodRootIndex = -1;

    public static void addClassLoader(ClassLoader loader) {
        m_classLoaders.add(loader);
    }

    private ClassHelper() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            return instance;
        }
        catch (IllegalAccessException iae) {
            throw new TestNGException("Class " + clazz.getName() + " does not have a no-args constructor", iae);
        }
        catch (InstantiationException ie) {
            throw new TestNGException("Cannot instantiate class " + clazz.getName(), ie);
        }
        catch (ExceptionInInitializerError eiierr) {
            throw new TestNGException("An exception occurred in static initialization of class " + clazz.getName(), eiierr);
        }
        catch (SecurityException se) {
            throw new TestNGException(se);
        }
    }

    public static Class<?> forName(String className) {
        Vector<ClassLoader> allClassLoaders = new Vector<ClassLoader>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            allClassLoaders.add(contextClassLoader);
        }
        if (m_classLoaders != null) {
            allClassLoaders.addAll(m_classLoaders);
        }
        for (ClassLoader classLoader : allClassLoaders) {
            if (null == classLoader) continue;
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                if (null != m_classLoaders && m_classLoaders.size() != 0) continue;
                ClassHelper.logClassNotFoundError(className, ex);
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            ClassHelper.logClassNotFoundError(className, cnfe);
            return null;
        }
    }

    private static void logClassNotFoundError(String className, Exception ex) {
        Utils.log("ClassHelper", 2, "Could not instantiate " + className + " : Class doesn't exist (" + ex.getMessage() + ")");
    }

    public static ConstructorOrMethod findDeclaredFactoryMethod(Class<?> cls, IAnnotationFinder finder) {
        IFactoryAnnotation f;
        ConstructorOrMethod result = null;
        for (Method method : cls.getMethods()) {
            f = finder.findAnnotation(method, IFactoryAnnotation.class);
            if (null == f) continue;
            result = new ConstructorOrMethod(method);
            result.setEnabled(f.getEnabled());
            break;
        }
        if (result == null) {
            for (Executable executable : cls.getDeclaredConstructors()) {
                f = finder.findAnnotation((Constructor)executable, IFactoryAnnotation.class);
                if (f == null) continue;
                result = new ConstructorOrMethod((Constructor)executable);
            }
        }
        return result;
    }

    public static Set<Method> getAvailableMethods(Class<?> clazz) {
        Set<Method> methods = Sets.newHashSet();
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        for (Class<?> parent = clazz.getSuperclass(); Object.class != parent; parent = parent.getSuperclass()) {
            methods.addAll(ClassHelper.extractMethods(clazz, parent, methods));
        }
        return methods;
    }

    public static IJUnitTestRunner createTestRunner(TestRunner runner) {
        try {
            Class.forName("org.junit.Test");
            IJUnitTestRunner tr = (IJUnitTestRunner)ClassHelper.forName(JUNIT_4_TESTRUNNER).newInstance();
            tr.setTestResultNotifier(runner);
            return tr;
        }
        catch (Throwable t) {
            Utils.log("ClassHelper", 2, "JUnit 4 was not found on the classpath");
            try {
                Class.forName("junit.framework.Test");
                IJUnitTestRunner tr = (IJUnitTestRunner)ClassHelper.forName(JUNIT_TESTRUNNER).newInstance();
                tr.setTestResultNotifier(runner);
                return tr;
            }
            catch (Exception ex) {
                Utils.log("ClassHelper", 2, "JUnit 3 was not found on the classpath");
                throw new TestNGException("Cannot create JUnit runner", ex);
            }
        }
    }

    private static Set<Method> extractMethods(Class<?> childClass, Class<?> clazz, Set<Method> collected) {
        Set<Method> methods = Sets.newHashSet();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Package childPackage = childClass.getPackage();
        Package classPackage = clazz.getPackage();
        boolean isSamePackage = false;
        if (null == childPackage && null == classPackage) {
            isSamePackage = true;
        }
        if (null != childPackage && null != classPackage) {
            isSamePackage = childPackage.getName().equals(classPackage.getName());
        }
        for (Method method : declaredMethods) {
            int methodModifiers = method.getModifiers();
            if (!Modifier.isPublic(methodModifiers) && !Modifier.isProtected(methodModifiers) && (!isSamePackage || Modifier.isPrivate(methodModifiers)) || ClassHelper.isOverridden(method, collected) || Modifier.isAbstract(methodModifiers)) continue;
            methods.add(method);
        }
        return methods;
    }

    private static boolean isOverridden(Method method, Set<Method> collectedMethods) {
        Class<?> methodClass = method.getDeclaringClass();
        Class<?>[] methodParams = method.getParameterTypes();
        for (Method m : collectedMethods) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (!method.getName().equals(m.getName()) || !methodClass.isAssignableFrom(m.getDeclaringClass()) || methodParams.length != paramTypes.length) continue;
            boolean sameParameters = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i].equals(paramTypes[i])) continue;
                sameParameters = false;
                break;
            }
            if (!sameParameters) continue;
            return true;
        }
        return false;
    }

    public static IMethodSelector createSelector(XmlMethodSelector selector) {
        try {
            Class<?> cls = Class.forName(selector.getClassName());
            return (IMethodSelector)cls.newInstance();
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't find method selector : " + selector.getClassName(), ex);
        }
    }

    public static Object createInstance(Class<?> declaringClass, Map<Class, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, ITestObjectFactory objectFactory) {
        if (objectFactory instanceof IObjectFactory) {
            return ClassHelper.createInstance1(declaringClass, classes, xmlTest, finder, (IObjectFactory)objectFactory);
        }
        if (objectFactory instanceof IObjectFactory2) {
            return ClassHelper.createInstance2(declaringClass, (IObjectFactory2)objectFactory);
        }
        throw new AssertionError((Object)("Unknown object factory type:" + objectFactory));
    }

    private static Object createInstance2(Class<?> declaringClass, IObjectFactory2 objectFactory) {
        return objectFactory.newInstance(declaringClass);
    }

    public static Object createInstance1(Class<?> declaringClass, Map<Class, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, IObjectFactory objectFactory) {
        Object result;
        block12: {
            result = null;
            try {
                Constructor<?> ct;
                boolean isStatic;
                Constructor<?> constructor = ClassHelper.findAnnotatedConstructor(finder, declaringClass);
                if (null != constructor) {
                    IParametersAnnotation annotation = finder.findAnnotation(constructor, IParametersAnnotation.class);
                    String[] parameterNames = annotation.getValue();
                    Object[] parameters = Parameters.createInstantiationParameters(constructor, "@Parameters", finder, parameterNames, xmlTest.getAllParameters(), xmlTest.getSuite());
                    result = objectFactory.newInstance(constructor, parameters);
                    break block12;
                }
                Class[] parameterTypes = new Class[]{};
                Object[] parameters = new Object[]{};
                Class<?> ec = ClassHelper.getEnclosingClass(declaringClass);
                boolean bl = isStatic = 0 != (declaringClass.getModifiers() & 8);
                if (null != ec && !isStatic) {
                    Object[] enclosingInstances;
                    parameterTypes = new Class[]{ec};
                    IClass enclosingIClass = classes.get(ec);
                    if (null != enclosingIClass) {
                        enclosingInstances = enclosingIClass.getInstances(false);
                        if (null == enclosingInstances || enclosingInstances.length == 0) {
                            Object o = objectFactory.newInstance(ec.getConstructor(parameterTypes), new Object[0]);
                            enclosingIClass.addInstance(o);
                            enclosingInstances = new Object[]{o};
                        }
                    } else {
                        enclosingInstances = new Object[]{ec.newInstance()};
                    }
                    Object enclosingClassInstance = enclosingInstances[0];
                    parameters = new Object[]{enclosingClassInstance};
                }
                try {
                    ct = declaringClass.getDeclaredConstructor(parameterTypes);
                }
                catch (NoSuchMethodException ex) {
                    ct = declaringClass.getDeclaredConstructor(String.class);
                    parameters = new Object[]{"Default test name"};
                }
                result = objectFactory.newInstance(ct, parameters);
            }
            catch (TestNGException ex) {
                throw ex;
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Throwable cause) {
                throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ": " + cause.getMessage(), cause);
            }
        }
        if (result == null && !Modifier.isPublic(declaringClass.getModifiers())) {
            throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ". Check to make sure it can be accessed/instantiated.");
        }
        return result;
    }

    private static Class<?> getEnclosingClass(Class<?> declaringClass) {
        Class<?> result = null;
        String className = declaringClass.getName();
        int index = className.indexOf("$");
        if (index != -1) {
            String ecn = className.substring(0, index);
            try {
                result = Class.forName(ecn);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Constructor<?> findAnnotatedConstructor(IAnnotationFinder finder, Class<?> declaringClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> result : constructors = declaringClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes;
            IParametersAnnotation annotation = finder.findAnnotation(result, IParametersAnnotation.class);
            if (null == annotation) continue;
            String[] parameters = annotation.getValue();
            if (parameters.length != (parameterTypes = result.getParameterTypes()).length) {
                throw new TestNGException("Parameter count mismatch:  " + result + "\naccepts " + parameterTypes.length + " parameters but the @Test annotation declares " + parameters.length);
            }
            return result;
        }
        return null;
    }

    public static <T> T tryOtherConstructor(Class<T> declaringClass) {
        T result;
        try {
            if (declaringClass.getModifiers() == 0) {
                return null;
            }
            Constructor<T> ctor = declaringClass.getConstructor(String.class);
            result = ctor.newInstance("Default test name");
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            String error = "Could not create an instance of class " + declaringClass + (message != null ? ": " + message : "") + ".\nPlease make sure it has a constructor that accepts either a String or no parameter.";
            throw new TestNGException(error);
        }
        return result;
    }

    public static Class<?> fileToClass(String file) {
        int i;
        String className;
        Class<?> result = null;
        if (!file.endsWith(".class") && !file.endsWith(".java")) {
            if (file.startsWith("class ")) {
                file = file.substring("class ".length());
            }
            if (null == (result = ClassHelper.forName(file))) {
                throw new TestNGException("Cannot load class from file: " + file);
            }
            return result;
        }
        int classIndex = file.lastIndexOf(".class");
        if (-1 == classIndex) {
            classIndex = file.lastIndexOf(".java");
        }
        String shortFileName = file.substring(0, classIndex);
        String[] segments = shortFileName.split("[/\\\\]", -1);
        if (-1 != m_lastGoodRootIndex) {
            className = segments[m_lastGoodRootIndex];
            for (i = m_lastGoodRootIndex + 1; i < segments.length; ++i) {
                className = className + "." + segments[i];
            }
            result = ClassHelper.forName(className);
            if (null != result) {
                return result;
            }
        }
        className = null;
        for (i = segments.length - 1; i >= 0; --i) {
            result = ClassHelper.forName(className = null == className ? segments[i] : segments[i] + "." + className);
            if (null == result) continue;
            m_lastGoodRootIndex = i;
            break;
        }
        if (null == result) {
            throw new TestNGException("Cannot load class from file: " + file);
        }
        return result;
    }
}

