/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.impl.bin.Block;
import com.amazon.ion.impl.bin.BlockAllocator;
import com.amazon.ion.impl.bin.BlockAllocatorProvider;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R/\u0010\u0003\u001a\u001d\u0012\u0014\u0012\u0012 \u0006*\b\u0018\u00010\u0005R\u00020\u00000\u0005R\u00020\u00000\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/serialization/PooledBlockAllocatorProvider;", "Lcom/amazon/ion/impl/bin/BlockAllocatorProvider;", "()V", "allocators", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lcom/intellij/serialization/PooledBlockAllocatorProvider$PooledBlockAllocator;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "allocators$annotations", "byteSize", "", "getByteSize", "()I", "removeExcess", "", "vendAllocator", "Lcom/amazon/ion/impl/bin/BlockAllocator;", "blockSize", "Companion", "PooledBlockAllocator", "intellij.platform.objectSerializer"})
public final class PooledBlockAllocatorProvider
extends BlockAllocatorProvider {
    private final ConcurrentIntObjectMap<PooledBlockAllocator> allocators;
    public static final int POOL_THRESHOLD = 524288;
    public static final Companion Companion = new Companion(null);

    private static /* synthetic */ void allocators$annotations() {
    }

    public final int getByteSize() {
        int totalByteSize = 0;
        Enumeration enumeration = this.allocators.elements();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumeration, (String)"allocators.elements()");
        Iterator iterator = CollectionsKt.iterator((Enumeration)enumeration);
        while (iterator.hasNext()) {
            PooledBlockAllocator allocator = (PooledBlockAllocator)((Object)iterator.next());
            totalByteSize += allocator.getByteSize();
        }
        return totalByteSize;
    }

    @NotNull
    public BlockAllocator vendAllocator(int blockSize) {
        if (blockSize <= 0) {
            throw (Throwable)new IllegalArgumentException("Invalid block size: " + blockSize);
        }
        PooledBlockAllocator pooledBlockAllocator = (PooledBlockAllocator)((Object)this.allocators.remove(blockSize));
        if (pooledBlockAllocator == null) {
            pooledBlockAllocator = new PooledBlockAllocator(blockSize);
        }
        PooledBlockAllocator result = pooledBlockAllocator;
        this.removeExcess();
        return result;
    }

    private final void removeExcess() {
        int totalByteSize = 0;
        Iterator iterator = this.allocators.values().iterator();
        boolean isExcess = false;
        while (iterator.hasNext()) {
            PooledBlockAllocator allocator = (PooledBlockAllocator)((Object)iterator.next());
            if (isExcess) {
                iterator.remove();
                continue;
            }
            if ((totalByteSize += allocator.getByteSize()) <= 524288) continue;
            iterator.remove();
            isExcess = true;
        }
    }

    public PooledBlockAllocatorProvider() {
        ConcurrentIntObjectMap concurrentIntObjectMap = ContainerUtil.createConcurrentIntObjectMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentIntObjectMap, (String)"ContainerUtil.createConc\u2026p<PooledBlockAllocator>()");
        this.allocators = concurrentIntObjectMap;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/serialization/PooledBlockAllocatorProvider$PooledBlockAllocator;", "Lcom/amazon/ion/impl/bin/BlockAllocator;", "blockSize", "", "(Lcom/intellij/serialization/PooledBlockAllocatorProvider;I)V", "blockCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "byteSize", "getByteSize", "()I", "freeBlocks", "Ljava/util/ArrayList;", "Lcom/amazon/ion/impl/bin/Block;", "allocateBlock", "close", "", "getBlockSize", "intellij.platform.objectSerializer"})
    private final class PooledBlockAllocator
    extends BlockAllocator {
        private final ArrayList<Block> freeBlocks;
        private final AtomicInteger blockCounter;
        private final int blockSize;

        public final int getByteSize() {
            return this.blockCounter.get() * this.blockSize;
        }

        @NotNull
        public Block allocateBlock() {
            int lastIndex = CollectionsKt.getLastIndex((List)this.freeBlocks);
            if (lastIndex != -1) {
                Block block = this.freeBlocks.remove(lastIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"freeBlocks.removeAt(lastIndex)");
                return block;
            }
            this.blockCounter.incrementAndGet();
            return new Block(this, new byte[this.blockSize]){
                final /* synthetic */ PooledBlockAllocator this$0;

                public void close() {
                    this.reset();
                    PooledBlockAllocator.access$getFreeBlocks$p(this.this$0).add(this);
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            };
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public void close() {
            if (this.blockSize * this.freeBlocks.size() > 524288) {
                return;
            }
            if (PooledBlockAllocatorProvider.this.allocators.putIfAbsent(this.blockSize, (Object)this) == null) {
                PooledBlockAllocatorProvider.this.removeExcess();
            } else {
                this.freeBlocks.clear();
                this.blockCounter.set(0);
            }
        }

        public PooledBlockAllocator(int blockSize) {
            this.blockSize = blockSize;
            this.freeBlocks = new ArrayList();
            this.blockCounter = new AtomicInteger();
        }

        public static final /* synthetic */ ArrayList access$getFreeBlocks$p(PooledBlockAllocator $this) {
            return $this.freeBlocks;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/serialization/PooledBlockAllocatorProvider$Companion;", "", "()V", "POOL_THRESHOLD", "", "intellij.platform.objectSerializer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

