/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TargetedCommandLineBuilder
extends UserDataHolderBase {
    @NotNull
    private TargetValue<String> myExePath = TargetValue.empty();
    @NotNull
    private TargetValue<String> myWorkingDirectory = TargetValue.empty();
    @NotNull
    private TargetValue<String> myInputFilePath = TargetValue.empty();
    @NotNull
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();
    @NotNull
    private final List<TargetValue<String>> myParameters = new ArrayList<TargetValue<String>>();
    @NotNull
    private final Map<String, TargetValue<String>> myEnvironment = new HashMap<String, TargetValue<String>>();
    @NotNull
    private final Set<File> myFilesToDeleteOnTermination = new HashSet<File>();

    @NotNull
    public TargetedCommandLine build() {
        return new TargetedCommandLine(this.myExePath, this.myWorkingDirectory, this.myInputFilePath, this.myCharset, new ArrayList<TargetValue<String>>(this.myParameters), new HashMap<String, TargetValue<String>>(this.myEnvironment));
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(0);
        }
        this.myCharset = charset;
    }

    public void setExePath(@NotNull TargetValue<String> exePath) {
        if (exePath == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(1);
        }
        this.myExePath = exePath;
    }

    public void setExePath(@NotNull String exePath) {
        if (exePath == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(2);
        }
        this.myExePath = TargetValue.fixed(exePath);
    }

    public void setWorkingDirectory(@NotNull TargetValue<String> workingDirectory) {
        if (workingDirectory == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(3);
        }
        this.myWorkingDirectory = workingDirectory;
    }

    public void addParameter(@NotNull TargetValue<String> parameter) {
        if (parameter == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(4);
        }
        this.myParameters.add(parameter);
    }

    public void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(5);
        }
        this.myParameters.add(TargetValue.fixed(parameter));
    }

    public void addParameters(@NotNull List<String> parametersList) {
        if (parametersList == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(6);
        }
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public void addEnvironmentVariable(String name, TargetValue<String> value) {
        this.myEnvironment.put(name, value);
    }

    public void addEnvironmentVariable(String name, String value) {
        this.myEnvironment.put(name, TargetValue.fixed(value));
    }

    public void addFileToDeleteOnTermination(@NotNull File file) {
        if (file == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(7);
        }
        this.myFilesToDeleteOnTermination.add(file);
    }

    public void setInputFile(@NotNull TargetValue<String> inputFilePath) {
        if (inputFilePath == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(8);
        }
        this.myInputFilePath = inputFilePath;
    }

    @NotNull
    public Set<File> getFilesToDeleteOnTermination() {
        Set<File> set = this.myFilesToDeleteOnTermination;
        if (set == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFilePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/target/TargetedCommandLineBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/target/TargetedCommandLineBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToDeleteOnTermination";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setExePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFileToDeleteOnTermination";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setInputFile";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

