/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.pom.Navigatable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffElement<T> {
    public static final DiffElement[] EMPTY_ARRAY = new DiffElement[0];

    public abstract String getPath();

    @NotNull
    public abstract String getName();

    public String getPresentableName() {
        return this.getName();
    }

    public String getPresentablePath() {
        return this.getPresentableName();
    }

    public abstract long getSize();

    public abstract long getTimeStamp();

    public FileType getFileType() {
        return FileTypeManager.getInstance().getFileTypeByFileName(this.getName());
    }

    public abstract boolean isContainer();

    public abstract DiffElement[] getChildren() throws IOException;

    @Nullable
    public Navigatable getNavigatable(@Nullable Project project) {
        return null;
    }

    public abstract byte @Nullable [] getContent() throws IOException;

    @Nullable
    public InputStream getContentStream() throws IOException {
        byte[] bytes = this.getContent();
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = EncodingManager.getInstance().getDefaultCharset();
        if (charset == null) {
            DiffElement.$$$reportNull$$$0(0);
        }
        return charset;
    }

    public abstract T getValue();

    public static String getSeparator() {
        return "/";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        block7: {
            DiffContent diffContent;
            if (indicator == null) {
                DiffElement.$$$reportNull$$$0(1);
            }
            try {
                T src = this.getValue();
                if (!(src instanceof VirtualFile)) break block7;
                diffContent = DiffContentFactory.getInstance().create(project, (VirtualFile)src);
            }
            catch (IOException e) {
                throw new DiffRequestProducerException(e);
            }
            if (diffContent == null) {
                DiffElement.$$$reportNull$$$0(2);
            }
            return diffContent;
        }
        byte[] content = this.getContent();
        if (content == null) {
            throw new DiffRequestProducerException("Can't get content");
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, new String(content, this.getCharset()), this.getFileType());
        if (documentContent == null) {
            DiffElement.$$$reportNull$$$0(3);
        }
        return documentContent;
    }

    @Nullable
    public Callable<DiffElement<T>> getElementChooser(@Nullable Project project) {
        return null;
    }

    public boolean isOperationsEnabled() {
        return false;
    }

    @Nullable
    public DiffElement<?> copyTo(DiffElement<T> container, String relativePath) {
        return null;
    }

    public boolean delete() {
        return false;
    }

    public void refresh(boolean userInitiated) throws IOException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/diff/DiffElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/diff/DiffElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

