/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class PublicMethodBasedOptionDescription
extends BooleanOptionDescription {
    private static final Logger LOG = Logger.getInstance(PublicMethodBasedOptionDescription.class);
    private final String myGetterName;
    private final String mySetterName;

    public PublicMethodBasedOptionDescription(String option, String configurableId, String getterName, String setterName) {
        super(option, configurableId);
        this.myGetterName = getterName;
        this.mySetterName = setterName;
    }

    @NotNull
    public abstract Object getInstance();

    protected void fireUpdated() {
    }

    @Override
    public boolean isOptionEnabled() {
        Object instance = this.getInstance();
        try {
            return (Boolean)instance.getClass().getMethod(this.myGetterName, new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Exception exception) {
            LOG.error(String.format("Boolean getter '%s' not found in %s", this.myGetterName, instance), (Throwable)exception);
            return false;
        }
    }

    @Override
    public void setOptionState(boolean enabled) {
        Object instance = this.getInstance();
        try {
            instance.getClass().getMethod(this.mySetterName, Boolean.TYPE).invoke(instance, enabled);
        }
        catch (Exception exception) {
            LOG.error(String.format("Boolean setter '%s' not found in %s", this.mySetterName, instance), (Throwable)exception);
        }
        this.fireUpdated();
    }
}

