/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.cacheBuilder;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class WordOccurrence {
    private Kind myKind;
    private CharSequence myText;
    private int myStart;
    private int myEnd;

    public WordOccurrence(CharSequence text, int start, int end, @Nullable Kind kind) {
        this.myKind = kind;
        this.myText = text;
        this.myStart = start;
        this.myEnd = end;
    }

    public final void init(CharSequence text, int start, int end, @Nullable Kind kind) {
        this.myKind = kind;
        this.myText = text;
        this.myStart = start;
        this.myEnd = end;
    }

    @Nullable
    public Kind getKind() {
        return this.myKind;
    }

    public CharSequence getBaseText() {
        return this.myText;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public static class Kind {
        public static final Kind CODE = new Kind("CODE");
        public static final Kind COMMENTS = new Kind("COMMENTS");
        public static final Kind LITERALS = new Kind("LITERALS");
        public static final Kind FOREIGN_LANGUAGE = new Kind("FOREIGN_LANGUAGE");
        private final String myName;

        private Kind(@NonNls String name) {
            this.myName = name;
        }

        @NonNls
        public String toString() {
            return "WordOccurrence.Kind(" + this.myName + ")";
        }
    }
}

