/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.util.ui.accessibility.SimpleAccessible;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GutterIconRenderer
implements GutterMark,
PossiblyDumbAware,
SimpleAccessible {
    @Nullable
    public ActionGroup getPopupMenuActions() {
        return null;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return null;
    }

    @Nullable
    public AnAction getClickAction() {
        return null;
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return null;
    }

    @Nullable
    public AnAction getRightButtonClickAction() {
        return null;
    }

    public boolean isNavigateAction() {
        return false;
    }

    @NotNull
    public Alignment getAlignment() {
        Alignment alignment = Alignment.CENTER;
        if (alignment == null) {
            GutterIconRenderer.$$$reportNull$$$0(0);
        }
        return alignment;
    }

    @Nullable
    public GutterDraggableObject getDraggableObject() {
        return null;
    }

    @NotNull
    public String getAccessibleName() {
        String string = GutterIconRenderer.getAccessibleName(this.getIcon(), "icon: ");
        if (string == null) {
            GutterIconRenderer.$$$reportNull$$$0(1);
        }
        return string;
    }

    public final String getFeatureId() {
        return GutterIconRenderer.getAccessibleName(this.getIcon(), "");
    }

    private static String getAccessibleName(@Nullable Icon icon, @NotNull String prefix) {
        String path2;
        if (prefix == null) {
            GutterIconRenderer.$$$reportNull$$$0(2);
        }
        if (icon instanceof RetrievableIcon) {
            return GutterIconRenderer.getAccessibleName(((RetrievableIcon)icon).retrieveIcon(), prefix);
        }
        if (icon instanceof CompositeIcon) {
            StringBuilder b = new StringBuilder("composite icon: ");
            int count = ((CompositeIcon)icon).getIconCount();
            for (int i = 0; i < count; ++i) {
                b.append(GutterIconRenderer.getAccessibleName(((CompositeIcon)icon).getIcon(i), ""));
                if (i >= count - 1) continue;
                b.append(" & ");
            }
            return b.toString();
        }
        if (icon instanceof IconLoader.CachedImageIcon && (path2 = ((IconLoader.CachedImageIcon)icon).getOriginalPath()) != null) {
            String[] split2 = path2.split(Pattern.quote("/") + "|" + Pattern.quote("\\"));
            String name = split2[split2.length - 1];
            return prefix + name.split(Pattern.quote("."))[0];
        }
        return prefix + "unknown";
    }

    @Nullable
    public String getAccessibleTooltipText() {
        return this.getTooltipText();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/GutterIconRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/GutterIconRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Alignment {
        LEFT(1),
        RIGHT(3),
        CENTER(2);

        private final int myWeight;

        private Alignment(int weight) {
            this.myWeight = weight;
        }

        public int getWeight() {
            return this.myWeight;
        }
    }
}

