/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemApiUtil {
    @NotNull
    public static final String PATH_SEPARATOR = "/";
    @NotNull
    public static final Comparator<Object> ORDER_AWARE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(@NotNull Object o1, @NotNull Object o2) {
            if (o1 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                1.$$$reportNull$$$0(1);
            }
            int order1 = this.getOrder(o1);
            int order2 = this.getOrder(o2);
            return Integer.compare(order1, order2);
        }

        private int getOrder(@NotNull Object o) {
            if (o == null) {
                1.$$$reportNull$$$0(2);
            }
            ArrayDeque toCheck = new ArrayDeque();
            toCheck.add(o.getClass());
            while (!toCheck.isEmpty()) {
                Class clazz = (Class)toCheck.poll();
                Order annotation = clazz.getAnnotation(Order.class);
                if (annotation != null) {
                    return annotation.value();
                }
                Class c = clazz.getSuperclass();
                if (c != null) {
                    toCheck.add(c);
                }
                Class<?>[] interfaces = clazz.getInterfaces();
                Collections.addAll(toCheck, interfaces);
            }
            return 1000;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    private static final NullableFunction<DataNode<?>, Key<?>> GROUPER = node -> node.getKey();

    private ExternalSystemApiUtil() {
    }

    @NotNull
    public static String extractNameFromPath(@NotNull String path2) {
        String strippedPath;
        int i;
        if (path2 == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(0);
        }
        String result = (i = (strippedPath = ExternalSystemApiUtil.stripPath(path2)).lastIndexOf(PATH_SEPARATOR)) < 0 || i >= strippedPath.length() - 1 ? strippedPath : strippedPath.substring(i + 1);
        String string = result;
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String stripPath(@NotNull String path2) {
        if (path2 == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(2);
        }
        String[] endingsToStrip = new String[]{PATH_SEPARATOR, "!", ".jar"};
        StringBuilder buffer = new StringBuilder(path2);
        for (String ending : endingsToStrip) {
            if (buffer.lastIndexOf(ending) != buffer.length() - ending.length()) continue;
            buffer.setLength(buffer.length() - ending.length());
        }
        String string = buffer.toString();
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getLibraryName(@NotNull Library library) {
        String result;
        if (library == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(4);
        }
        if ((result = library.getName()) != null) {
            String string = result;
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : library.getUrls(type)) {
                String candidate = ExternalSystemApiUtil.extractNameFromPath(url);
                if (StringUtil.isEmpty((String)candidate)) continue;
                String string = candidate;
                if (string == null) {
                    ExternalSystemApiUtil.$$$reportNull$$$0(6);
                }
                return string;
            }
        }
        assert (false);
        return "unknown-lib";
    }

    public static boolean isRelated(@NotNull Library library, @NotNull LibraryData libraryData) {
        if (library == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(7);
        }
        if (libraryData == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(8);
        }
        return ExternalSystemApiUtil.getLibraryName(library).equals(libraryData.getInternalName());
    }

    public static boolean isExternalSystemLibrary(@NotNull Library library, @NotNull ProjectSystemId externalSystemId) {
        if (library == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(9);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(10);
        }
        return library.getName() != null && StringUtil.startsWithIgnoreCase((String)library.getName(), (String)(externalSystemId.getId() + ": "));
    }

    public static void orderAwareSort(@NotNull List<?> data) {
        if (data == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(11);
        }
        Collections.sort(data, ORDER_AWARE_COMPARATOR);
    }

    @NotNull
    public static String toCanonicalPath(@NotNull String path2) {
        if (path2 == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(12);
        }
        String p = ExternalSystemApiUtil.normalizePath(new File(path2).getAbsolutePath());
        assert (p != null);
        String string = PathUtil.getCanonicalPath(p);
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String getLocalFileSystemPath(@NotNull VirtualFile file) {
        VirtualFile jar;
        if (file == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(14);
        }
        if (FileTypeRegistry.getInstance().isFileOfType(file, ArchiveFileType.INSTANCE) && (jar = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
            String string = jar.getPath();
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(15);
            }
            return string;
        }
        return ExternalSystemApiUtil.toCanonicalPath(file.getPath());
    }

    @Nullable
    public static ExternalSystemManager<?, ?, ?, ?, ?> getManager(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(16);
        }
        return (ExternalSystemManager)ExternalSystemManager.EP_NAME.findFirstSafe(manager -> externalSystemId.equals(manager.getSystemId()));
    }

    @NotNull
    public static List<ExternalSystemManager<?, ?, ?, ?, ?>> getAllManagers() {
        List list = ExternalSystemManager.EP_NAME.getExtensionList();
        if (list == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    public static MultiMap<Key<?>, DataNode<?>> recursiveGroup(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(18);
        }
        ContainerUtil.KeyOrderedMultiMap result = new ContainerUtil.KeyOrderedMultiMap();
        LinkedList queue = new LinkedList();
        queue.add(nodes);
        while (!queue.isEmpty()) {
            Collection _nodes = (Collection)queue.remove();
            result.putAllValues(ExternalSystemApiUtil.group(_nodes));
            for (DataNode _node : _nodes) {
                queue.add(_node.getChildren());
            }
        }
        return result;
    }

    @NotNull
    public static MultiMap<Key<?>, DataNode<?>> group(@NotNull Collection<? extends DataNode<?>> nodes) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(19);
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, GROUPER);
        if (multiMap == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(20);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<? extends DataNode<V>> nodes, Class<K> moduleDataClass) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(21);
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, node -> node.getParent(moduleDataClass));
        if (multiMap == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(22);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<? extends DataNode<V>> nodes, @NotNull Key<K> key) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(23);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(24);
        }
        MultiMap multiMap = ContainerUtil.groupBy(nodes, node -> node.getDataNode(key));
        if (multiMap == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(25);
        }
        return multiMap;
    }

    @NotNull
    public static <T> Collection<DataNode<T>> getChildren(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(26);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(27);
        }
        ArrayList result = null;
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.add(child);
        }
        List<DataNode<Object>> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(29);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(30);
        }
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key, BooleanFunction<? super DataNode<T>> predicate) {
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(31);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(32);
        }
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey()) || !predicate.fun(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(33);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(34);
        }
        return ExternalSystemApiUtil.findParent(node, key, null);
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key, @Nullable BooleanFunction<? super DataNode<T>> predicate) {
        DataNode<?> parent;
        if (node == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(35);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(36);
        }
        if ((parent = node.getParent()) == null) {
            return null;
        }
        return key.equals(parent.getKey()) && (predicate == null || predicate.fun(parent)) ? parent : ExternalSystemApiUtil.findParent(parent, key, predicate);
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAll(@NotNull DataNode<?> parent, @NotNull Key<T> key) {
        if (parent == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(37);
        }
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(38);
        }
        return ExternalSystemApiUtil.getChildren(parent, key);
    }

    public static void visit(@Nullable DataNode<?> originalNode, @NotNull Consumer<? super DataNode<?>> consumer) {
        if (consumer == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(39);
        }
        if (originalNode != null) {
            originalNode.visit(consumer);
        }
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAllRecursively(@Nullable DataNode<?> node, @NotNull Key<T> key) {
        if (key == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(40);
        }
        if (node == null) {
            List<DataNode<T>> list = Collections.emptyList();
            if (list == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(41);
            }
            return list;
        }
        Collection<DataNode<?>> nodes = ExternalSystemApiUtil.findAllRecursively(node.getChildren(), node1 -> node1.getKey().equals(key));
        return new SmartList(nodes);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<? extends DataNode<?>> nodes) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(42);
        }
        return ExternalSystemApiUtil.findAllRecursively(nodes, null);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@Nullable DataNode<?> node, @Nullable BooleanFunction<? super DataNode<?>> predicate) {
        if (node == null) {
            List<DataNode<?>> list = Collections.emptyList();
            if (list == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(43);
            }
            return list;
        }
        return ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<? extends DataNode<?>> nodes, @Nullable BooleanFunction<? super DataNode<?>> predicate) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(44);
        }
        SmartList result = new SmartList();
        for (DataNode<?> node : nodes) {
            if (predicate != null && !predicate.fun(node)) continue;
            result.add(node);
        }
        for (DataNode<?> node : nodes) {
            result.addAll(ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate));
        }
        SmartList smartList = result;
        if (smartList == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(45);
        }
        return smartList;
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull DataNode<?> parentNode, @NotNull BooleanFunction<? super DataNode<?>> predicate) {
        if (parentNode == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(46);
        }
        if (predicate == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(47);
        }
        LinkedList queue = new LinkedList();
        queue.add(parentNode);
        return ExternalSystemApiUtil.findInQueue(queue, predicate);
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull Collection<? extends DataNode<?>> nodes, @NotNull BooleanFunction<? super DataNode<?>> predicate) {
        if (nodes == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(48);
        }
        if (predicate == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(49);
        }
        return ExternalSystemApiUtil.findInQueue(new LinkedList(nodes), predicate);
    }

    @Nullable
    private static DataNode<?> findInQueue(@NotNull Queue<DataNode<?>> queue, @NotNull BooleanFunction<? super DataNode<?>> predicate) {
        if (queue == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(50);
        }
        if (predicate == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(51);
        }
        while (!queue.isEmpty()) {
            DataNode<?> node = queue.remove();
            if (predicate.fun(node)) {
                return node;
            }
            queue.addAll(node.getChildren());
        }
        return null;
    }

    public static void executeProjectChangeAction(@NotNull DisposeAwareProjectChange task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(52);
        }
        ExternalSystemApiUtil.executeProjectChangeAction(true, task);
    }

    public static void executeProjectChangeAction(boolean synchronous, @NotNull DisposeAwareProjectChange task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(53);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        }
        ExternalSystemApiUtil.executeOnEdt(synchronous, () -> ApplicationManager.getApplication().runWriteAction(task));
    }

    public static void executeOnEdt(boolean synchronous, @NotNull Runnable task) {
        Application app;
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(54);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            task.run();
            return;
        }
        if (synchronous) {
            app.invokeAndWait(task);
        } else {
            app.invokeLater(task);
        }
    }

    public static <T> T executeOnEdt(@NotNull Computable<T> task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(55);
        }
        Application app = ApplicationManager.getApplication();
        Ref result = Ref.create();
        app.invokeAndWait(() -> result.set(task.compute()));
        return (T)result.get();
    }

    public static <T> T doWriteAction(@NotNull Computable<T> task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(56);
        }
        return ExternalSystemApiUtil.executeOnEdt(() -> ApplicationManager.getApplication().runWriteAction(task));
    }

    public static void doWriteAction(@NotNull Runnable task) {
        if (task == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(57);
        }
        ExternalSystemApiUtil.executeOnEdt(true, () -> ApplicationManager.getApplication().runWriteAction(task));
    }

    public static void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || application.isDispatchThread()) {
            runnable.run();
        } else {
            EdtExecutorService.getInstance().execute(runnable);
        }
    }

    public static void addBundle(@NotNull PathsList classPath, @NotNull String bundlePath, @NotNull Class<?> contextClass) {
        String root;
        String pathToUse;
        if (classPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(58);
        }
        if (bundlePath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(59);
        }
        if (contextClass == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(60);
        }
        if (!(pathToUse = bundlePath.replace('.', '/')).endsWith(".properties")) {
            pathToUse = pathToUse + ".properties";
        }
        if (!pathToUse.startsWith(PATH_SEPARATOR)) {
            pathToUse = '/' + pathToUse;
        }
        if ((root = PathManager.getResourceRoot(contextClass, (String)pathToUse)) != null) {
            classPath.add(root);
        }
    }

    @Nullable
    public static String normalizePath(@Nullable String s) {
        return StringUtil.isEmpty((String)s) ? null : s.replace('\\', '/');
    }

    public static boolean isOneToOneMapping(@NotNull Project ideProject, @NotNull ProjectData projectData, Module[] modules) {
        if (ideProject == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(61);
        }
        if (projectData == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(62);
        }
        String linkedExternalProjectPath = null;
        for (ExternalSystemManager manager : ExternalSystemManager.EP_NAME.getIterable()) {
            ProjectSystemId externalSystemId = manager.getSystemId();
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings(ideProject, externalSystemId);
            Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
            int linkedProjectsNumber = projectsSettings.size();
            if (linkedProjectsNumber > 1) {
                return false;
            }
            if (linkedProjectsNumber != 1) continue;
            if (linkedExternalProjectPath == null) {
                linkedExternalProjectPath = ((ExternalProjectSettings)projectsSettings.iterator().next()).getExternalProjectPath();
                continue;
            }
            return false;
        }
        if (linkedExternalProjectPath != null && !linkedExternalProjectPath.equals(projectData.getLinkedExternalProjectPath())) {
            return false;
        }
        for (Module module : modules) {
            if (ExternalSystemApiUtil.isExternalSystemAwareModule(projectData.getOwner(), module)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        File targetProjectDir;
        if (targetProjectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(63);
        }
        if (rootProjectPath == null) {
            File rootProjectDir = new File(targetProjectPath);
            if (rootProjectDir.isFile()) {
                rootProjectDir = rootProjectDir.getParentFile();
            }
            String string = rootProjectDir.getName();
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(64);
            }
            return string;
        }
        File rootProjectDir = new File(rootProjectPath);
        if (rootProjectDir.isFile()) {
            rootProjectDir = rootProjectDir.getParentFile();
        }
        if ((targetProjectDir = new File(targetProjectPath)).isFile()) {
            targetProjectDir = targetProjectDir.getParentFile();
        }
        StringBuilder buffer = new StringBuilder();
        for (File f = targetProjectDir; f != null && !FileUtil.filesEqual((File)f, (File)rootProjectDir); f = f.getParentFile()) {
            buffer.insert(0, f.getName()).insert(0, ":");
        }
        buffer.insert(0, rootProjectDir.getName());
        String string = buffer.toString();
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(65);
        }
        return string;
    }

    @Nullable
    public static String getRootProjectPath(@NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        ExternalSystemManager<?, ?, ?, ?, ?> manager;
        if (externalProjectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(66);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(67);
        }
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(68);
        }
        if ((manager = ExternalSystemApiUtil.getManager(externalSystemId)) == null) {
            return null;
        }
        if (manager instanceof ExternalSystemAutoImportAware) {
            return ((ExternalSystemAutoImportAware)((Object)manager)).getAffectedExternalProjectPath(externalProjectPath, project);
        }
        return null;
    }

    @NotNull
    public static String buildErrorMessage(@NotNull Throwable e) {
        Throwable unwrapped;
        String reason;
        if (e == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(69);
        }
        if (!StringUtil.isEmpty((String)(reason = (unwrapped = RemoteUtil.unwrap((Throwable)e)).getLocalizedMessage()))) {
            String string = reason;
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(70);
            }
            return string;
        }
        if (unwrapped.getClass() == ExternalSystemException.class) {
            String string = String.format("exception during working with external system: %s", ((ExternalSystemException)unwrapped).getOriginalReason());
            if (string == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(71);
            }
            return string;
        }
        return ExternalSystemApiUtil.stacktraceAsString(unwrapped);
    }

    @NotNull
    public static String stacktraceAsString(@NotNull Throwable throwable) {
        if (throwable == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(72);
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)throwable);
        StringWriter writer = new StringWriter();
        unwrapped.printStackTrace(new PrintWriter(writer));
        String string = writer.toString();
        if (string == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    public static AbstractExternalSystemSettings getSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(74);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(75);
        }
        if ((manager = ExternalSystemApiUtil.getManager(externalSystemId)) == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        if (abstractExternalSystemSettings == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(76);
        }
        return abstractExternalSystemSettings;
    }

    public static <S extends AbstractExternalSystemLocalSettings> S getLocalSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(77);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(78);
        }
        if ((manager = ExternalSystemApiUtil.getManager(externalSystemId)) == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve local external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project));
    }

    public static <S extends ExternalSystemExecutionSettings> S getExecutionSettings(@NotNull Project project, @NotNull String linkedProjectPath, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(79);
        }
        if (linkedProjectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(80);
        }
        if (externalSystemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(81);
        }
        if ((manager = ExternalSystemApiUtil.getManager(externalSystemId)) == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system execution settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((ExternalSystemExecutionSettings)manager.getExecutionSettingsProvider().fun((Object)Pair.create((Object)project, (Object)linkedProjectPath)));
    }

    public static boolean isInProcessMode(ProjectSystemId externalSystemId) {
        return Registry.is((String)(externalSystemId.getId() + ".system.in.process"), (boolean)false);
    }

    public static ProjectModelExternalSource toExternalSource(@NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(82);
        }
        return ExternalProjectSystemRegistry.getInstance().getSourceById(systemId.getId());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull ProjectSystemId systemId, @Nullable Module module) {
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(83);
        }
        return module != null && !module.isDisposed() && systemId.getId().equals(ExternalSystemModulePropertyManager.getInstance(module).getExternalSystemId());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull String systemId, @Nullable Module module) {
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(84);
        }
        return module != null && !module.isDisposed() && systemId.equals(ExternalSystemModulePropertyManager.getInstance(module).getExternalSystemId());
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getLinkedProjectPath() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalRootProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getRootProjectPath() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectId(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getLinkedProjectId() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectGroup(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleGroup() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectVersion(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleVersion() : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalModuleType(@Nullable Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.getInstance(module).getExternalModuleType() : null;
    }

    public static void subscribe(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalSystemSettingsListener listener2) {
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(85);
        }
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(86);
        }
        if (listener2 == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(87);
        }
        ExternalSystemApiUtil.getSettings(project, systemId).subscribe(listener2, (Disposable)project);
    }

    public static void subscribe(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalSystemSettingsListener listener2, @NotNull Disposable parentDisposable) {
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(88);
        }
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(89);
        }
        if (listener2 == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(90);
        }
        if (parentDisposable == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(91);
        }
        ExternalSystemApiUtil.getSettings(project, systemId).subscribe(listener2, parentDisposable);
    }

    @NotNull
    public static Collection<TaskData> findProjectTasks(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        AbstractExternalSystemSettings settings;
        Object linkedProjectSettings;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(92);
        }
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(93);
        }
        if (projectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(94);
        }
        if ((linkedProjectSettings = (settings = ExternalSystemApiUtil.getSettings(project, systemId)).getLinkedProjectSettings(projectPath)) == null) {
            List<TaskData> list = Collections.emptyList();
            if (list == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(95);
            }
            return list;
        }
        ExternalProjectInfo projectInfo = ProjectDataManager.getInstance().getExternalProjectsData(project, systemId).stream().filter(info -> FileUtil.pathsEqual((String)linkedProjectSettings.getExternalProjectPath(), (String)info.getExternalProjectPath())).findFirst().orElse(null);
        if (projectInfo == null) {
            List<TaskData> list = Collections.emptyList();
            if (list == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(96);
            }
            return list;
        }
        DataNode<ProjectData> projectStructure = projectInfo.getExternalProjectStructure();
        if (projectStructure == null) {
            List<TaskData> list = Collections.emptyList();
            if (list == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(97);
            }
            return list;
        }
        SmartList tasks = new SmartList();
        DataNode moduleDataNode = ExternalSystemApiUtil.findAll(projectStructure, ProjectKeys.MODULE).stream().filter(moduleNode -> FileUtil.pathsEqual((String)projectPath, (String)((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath())).findFirst().orElse(null);
        if (moduleDataNode == null) {
            List<TaskData> list = Collections.emptyList();
            if (list == null) {
                ExternalSystemApiUtil.$$$reportNull$$$0(98);
            }
            return list;
        }
        ExternalSystemApiUtil.findAll(moduleDataNode, ProjectKeys.TASK).stream().map(DataNode::getData).forEach(((List)tasks)::add);
        SmartList smartList = tasks;
        if (smartList == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(99);
        }
        return smartList;
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ProjectData> findProjectData(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        ExternalProjectInfo projectInfo;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(100);
        }
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(101);
        }
        if (projectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(102);
        }
        if ((projectInfo = ExternalSystemApiUtil.findProjectInfo(project, systemId, projectPath)) == null) {
            return null;
        }
        return projectInfo.getExternalProjectStructure();
    }

    @ApiStatus.Experimental
    @Nullable
    public static ExternalProjectInfo findProjectInfo(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        AbstractExternalSystemSettings settings;
        Object linkedProjectSettings;
        if (project == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(103);
        }
        if (systemId == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(104);
        }
        if (projectPath == null) {
            ExternalSystemApiUtil.$$$reportNull$$$0(105);
        }
        if ((linkedProjectSettings = (settings = ExternalSystemApiUtil.getSettings(project, systemId)).getLinkedProjectSettings(projectPath)) == null) {
            return null;
        }
        String rootProjectPath = ((ExternalProjectSettings)linkedProjectSettings).getExternalProjectPath();
        return ProjectDataManager.getInstance().getExternalProjectData(project, systemId, rootProjectPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 41: 
            case 43: 
            case 45: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 41: 
            case 43: 
            case 45: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 41: 
            case 43: 
            case 45: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 10: 
            case 16: 
            case 67: 
            case 75: 
            case 78: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 42: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundlePath";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProjectPath";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 68: 
            case 74: 
            case 77: 
            case 79: 
            case 85: 
            case 88: 
            case 92: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 93: 
            case 101: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 94: 
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemApiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNameFromPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stripPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileSystemPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllManagers";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 41: 
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllRecursively";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRepresentationName";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorMessage";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "stacktraceAsString";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractNameFromPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 41: 
            case 43: 
            case 45: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stripPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRelated";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExternalSystemLibrary";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "orderAwareSort";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFileSystemPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getManager";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "recursiveGroup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 40: 
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findAllRecursively";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findFirstRecursively";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findInQueue";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "executeProjectChangeAction";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "executeOnEdt";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "doWriteAction";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addBundle";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isOneToOneMapping";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRepresentationName";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getRootProjectPath";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "buildErrorMessage";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "stacktraceAsString";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSettings";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getExecutionSettings";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "toExternalSource";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isExternalSystemAwareModule";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "findProjectTasks";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "findProjectData";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "findProjectInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 41: 
            case 43: 
            case 45: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

