/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.cellvalidators;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class CellComponentProvider<C extends JComponent> {
    @NotNull
    protected final C owner;

    public CellComponentProvider(@NotNull C owner) {
        if (owner == null) {
            CellComponentProvider.$$$reportNull$$$0(0);
        }
        this.owner = owner;
    }

    @NotNull
    public final C getOwner() {
        C c = this.owner;
        if (c == null) {
            CellComponentProvider.$$$reportNull$$$0(1);
        }
        return c;
    }

    @Nullable
    public abstract JComponent getCellRendererComponent(@NotNull MouseEvent var1);

    @NotNull
    public abstract Rectangle getCellRect(@NotNull MouseEvent var1);

    abstract boolean isEditing(@NotNull MouseEvent var1);

    abstract boolean isEditingStarted(@NotNull PropertyChangeEvent var1);

    public static CellComponentProvider<JTable> forTable(JTable table) {
        return new TableProvider(table);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/cellvalidators/CellComponentProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/cellvalidators/CellComponentProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TableProvider
    extends CellComponentProvider<JTable> {
        protected TableProvider(@NotNull JTable owner) {
            if (owner == null) {
                TableProvider.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        @Nullable
        public JComponent getCellRendererComponent(@NotNull MouseEvent e) {
            if (e == null) {
                TableProvider.$$$reportNull$$$0(1);
            }
            Point p = e.getPoint();
            int column = ((JTable)this.owner).columnAtPoint(p);
            int row = ((JTable)this.owner).rowAtPoint(p);
            if (column != -1 && row != -1) {
                TableCellRenderer renderer = ((JTable)this.owner).getCellRenderer(row, column);
                return (JComponent)((JTable)this.owner).prepareRenderer(renderer, row, column);
            }
            return null;
        }

        @Override
        @NotNull
        public Rectangle getCellRect(@NotNull MouseEvent e) {
            if (e == null) {
                TableProvider.$$$reportNull$$$0(2);
            }
            Point p = e.getPoint();
            Rectangle rectangle = ((JTable)this.owner).getCellRect(((JTable)this.owner).rowAtPoint(p), ((JTable)this.owner).columnAtPoint(p), false);
            if (rectangle == null) {
                TableProvider.$$$reportNull$$$0(3);
            }
            return rectangle;
        }

        @Override
        public boolean isEditing(@NotNull MouseEvent e) {
            Point p;
            if (e == null) {
                TableProvider.$$$reportNull$$$0(4);
            }
            return ((JTable)this.owner).rowAtPoint(p = e.getPoint()) == ((JTable)this.owner).getEditingRow() && ((JTable)this.owner).columnAtPoint(p) == ((JTable)this.owner).getEditingColumn();
        }

        @Override
        public boolean isEditingStarted(@NotNull PropertyChangeEvent e) {
            if (e == null) {
                TableProvider.$$$reportNull$$$0(5);
            }
            return "tableCellEditor".equals(e.getPropertyName()) && e.getNewValue() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/cellvalidators/CellComponentProvider$TableProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/cellvalidators/CellComponentProvider$TableProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCellRect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCellRendererComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCellRect";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isEditing";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isEditingStarted";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

