/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import org.jetbrains.annotations.NotNull;

public class FilePathsHelper {
    private FilePathsHelper() {
    }

    public static String convertPath(FilePath fp) {
        return FilePathsHelper.convertPath(fp.getPath());
    }

    public static String convertWithLastSeparator(FilePath fp) {
        return FilePathsHelper.convertWithLastSeparatorImpl(fp.getPath(), fp.isDirectory());
    }

    private static String convertWithLastSeparatorImpl(String initPath, boolean isDir) {
        String path2 = isDir ? (initPath.endsWith("/") || initPath.endsWith("\\") ? initPath : initPath + "/") : initPath;
        return FilePathsHelper.convertPath(path2);
    }

    public static String convertPath(String parent, String subpath) {
        String convParent = FileUtil.toSystemIndependentName((String)parent);
        String convPath = FileUtil.toSystemIndependentName((String)subpath);
        String withSlash = StringUtil.trimEnd((String)convParent, (String)"/") + "/" + StringUtil.trimStart((String)convPath, (String)"/");
        return SystemInfo.isFileSystemCaseSensitive ? withSlash : StringUtil.toUpperCase((String)withSlash);
    }

    @NotNull
    public static String convertPath(@NotNull String s) {
        if (s == null) {
            FilePathsHelper.$$$reportNull$$$0(0);
        }
        String result = FileUtil.toSystemIndependentName((String)s);
        String string = SystemInfo.isFileSystemCaseSensitive ? result : StringUtil.toUpperCase((String)result);
        if (string == null) {
            FilePathsHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/FilePathsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/FilePathsHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertPath";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

