/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentStatusBarUIContributor
implements CodeStyleStatusBarUIContributor {
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

    public IndentStatusBarUIContributor(CommonCodeStyleSettings.IndentOptions options) {
        this.myIndentOptions = options;
    }

    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.myIndentOptions;
    }

    @Nullable
    public abstract String getHint();

    @Override
    @Nullable
    public String getTooltip() {
        return IndentStatusBarUIContributor.createTooltip(IndentStatusBarUIContributor.getIndentInfo(this.myIndentOptions), this.getHint());
    }

    @NotNull
    public static String getIndentInfo(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        if (indentOptions.USE_TAB_CHARACTER) {
            sb.append("Tab");
        } else {
            int indent = indentOptions.INDENT_SIZE;
            sb.append(indentOptions.INDENT_SIZE).append(indent > 1 ? " spaces" : " space");
        }
        String string = sb.toString();
        if (string == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return true;
    }

    @NotNull
    public static String createTooltip(String indentInfo, String hint) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append("Indent: ").append(indentInfo);
        if (hint != null) {
            sb.append("&nbsp;&nbsp;").append("<span style=\"color:#").append(ColorUtil.toHex((Color)JBColor.GRAY)).append("\">");
            sb.append(StringUtil.capitalize((String)hint));
            sb.append("</span>");
        }
        String string = sb.append("</html>").toString();
        if (string == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getStatusText(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(3);
        }
        String indentInfo = IndentStatusBarUIContributor.getIndentInfo(this.myIndentOptions);
        StringBuilder widgetText = new StringBuilder();
        widgetText.append(indentInfo);
        CommonCodeStyleSettings.IndentOptions projectIndentOptions = CodeStyle.getSettings(psiFile.getProject()).getLanguageIndentOptions(psiFile.getLanguage());
        if (!projectIndentOptions.equals(this.myIndentOptions)) {
            widgetText.append("*");
        }
        String string = widgetText.toString();
        if (string == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/IndentStatusBarUIContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/IndentStatusBarUIContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInfo";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

