/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class ProjectTaskRunner {
    public static final ExtensionPointName<ProjectTaskRunner> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectTaskRunner");
    private static final Key<Boolean> RECURSION_GUARD_KEY = KeyWithDefaultValue.create((String)"recursion guard key", (Object)false);

    public Promise<Result> run(@NotNull Project project, @NotNull ProjectTaskContext context, ProjectTask ... tasks) {
        if (project == null) {
            ProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            ProjectTaskRunner.$$$reportNull$$$0(2);
        }
        AsyncPromise promise2 = new AsyncPromise();
        this.run(project, context, (ProjectTaskNotification)new ProjectTaskNotificationAdapter(promise2), tasks);
        return promise2;
    }

    public abstract boolean canRun(@NotNull ProjectTask var1);

    public boolean canRun(@NotNull Project project, @NotNull ProjectTask projectTask) {
        if (project == null) {
            ProjectTaskRunner.$$$reportNull$$$0(3);
        }
        if (projectTask == null) {
            ProjectTaskRunner.$$$reportNull$$$0(4);
        }
        return this.canRun(projectTask);
    }

    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        if (project == null) {
            ProjectTaskRunner.$$$reportNull$$$0(5);
        }
        if (task == null) {
            ProjectTaskRunner.$$$reportNull$$$0(6);
        }
        return null;
    }

    @ApiStatus.Experimental
    public boolean isFileGeneratedEventsSupported() {
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project == null) {
            ProjectTaskRunner.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ProjectTaskRunner.$$$reportNull$$$0(8);
        }
        if (tasks == null) {
            ProjectTaskRunner.$$$reportNull$$$0(9);
        }
        if (!((Boolean)RECURSION_GUARD_KEY.get((UserDataHolder)context)).booleanValue()) {
            RECURSION_GUARD_KEY.set((UserDataHolder)context, (Object)true);
            this.run(project, context, callback, tasks.toArray(ProjectTaskManager.EMPTY_TASKS_ARRAY));
            RECURSION_GUARD_KEY.set((UserDataHolder)context, (Object)false);
        } else {
            ProjectTaskRunner.assertUnsupportedOperation(callback);
            ProjectTaskRunner.notifyIfNeeded(this.run(project, context, tasks.toArray(new ProjectTask[0])), callback);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, ProjectTask ... tasks) {
        if (project == null) {
            ProjectTaskRunner.$$$reportNull$$$0(10);
        }
        if (context == null) {
            ProjectTaskRunner.$$$reportNull$$$0(11);
        }
        if (tasks == null) {
            ProjectTaskRunner.$$$reportNull$$$0(12);
        }
        if (!((Boolean)RECURSION_GUARD_KEY.get((UserDataHolder)context)).booleanValue()) {
            RECURSION_GUARD_KEY.set((UserDataHolder)context, (Object)true);
            this.run(project, context, callback, Arrays.asList(tasks));
            RECURSION_GUARD_KEY.set((UserDataHolder)context, (Object)false);
        } else {
            ProjectTaskRunner.assertUnsupportedOperation(callback);
            ProjectTaskRunner.notifyIfNeeded(this.run(project, context, tasks), callback);
        }
    }

    private static void notifyIfNeeded(@NotNull Promise<Result> promise2, @Nullable ProjectTaskNotification callback) {
        if (promise2 == null) {
            ProjectTaskRunner.$$$reportNull$$$0(13);
        }
        if (callback != null) {
            promise2.onSuccess(result -> callback.finished(new ProjectTaskResult(result.isAborted(), result.hasErrors() ? 1 : 0, 0))).onError(throwable -> callback.finished(new ProjectTaskResult(true, 0, 0)));
        }
    }

    private static void assertUnsupportedOperation(@Nullable ProjectTaskNotification callback) {
        if (callback instanceof ProjectTaskNotificationAdapter) {
            throw new UnsupportedOperationException("Please, provide implementation non-deprecated ProjectTaskRunner.run(Project, ProjectTaskContext, ProjectTask...) method");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        objectArray2[1] = "com/intellij/task/ProjectTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createExecutionEnvironment";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProjectTaskNotificationAdapter
    implements ProjectTaskNotification {
        private final AsyncPromise<Result> myPromise;

        private ProjectTaskNotificationAdapter(@NotNull AsyncPromise<Result> promise2) {
            if (promise2 == null) {
                ProjectTaskNotificationAdapter.$$$reportNull$$$0(0);
            }
            this.myPromise = promise2;
        }

        @Override
        public void finished(final @NotNull ProjectTaskResult taskResult) {
            if (taskResult == null) {
                ProjectTaskNotificationAdapter.$$$reportNull$$$0(1);
            }
            this.myPromise.setResult((Object)new Result(){

                @Override
                public boolean isAborted() {
                    return taskResult.isAborted();
                }

                @Override
                public boolean hasErrors() {
                    return taskResult.getErrors() > 0;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "promise";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskResult";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/ProjectTaskRunner$ProjectTaskNotificationAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Result {
        public boolean isAborted();

        public boolean hasErrors();
    }
}

