/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergingUpdateQueue
implements Runnable,
Disposable,
Activatable {
    public static final JComponent ANY_COMPONENT = new JComponent(){};
    private volatile boolean myActive;
    private volatile boolean mySuspended;
    private final Map<Integer, Map<Update, Update>> myScheduledUpdates;
    private final Alarm myWaiterForMerge;
    private volatile boolean myFlushing;
    private final String myName;
    private int myMergingTimeSpan;
    private JComponent myModalityStateComponent;
    private final boolean myExecuteInDispatchThread;
    private boolean myPassThrough;
    private boolean myDisposed;
    private UiNotifyConnector myUiNotifyConnector;
    private boolean myRestartOnAdd;
    private boolean myTrackUiActivity;
    private UiActivity myUiActivity;

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent) {
        if (name == null) {
            MergingUpdateQueue.$$$reportNull$$$0(0);
        }
        this(name, mergingTimeSpan, isActive, modalityStateComponent, null);
    }

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent, @Nullable Disposable parent) {
        if (name == null) {
            MergingUpdateQueue.$$$reportNull$$$0(1);
        }
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, null);
    }

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent, @Nullable Disposable parent, @Nullable JComponent activationComponent) {
        if (name == null) {
            MergingUpdateQueue.$$$reportNull$$$0(2);
        }
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, activationComponent, true);
    }

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent, @Nullable Disposable parent, @Nullable JComponent activationComponent, boolean executeInDispatchThread) {
        if (name == null) {
            MergingUpdateQueue.$$$reportNull$$$0(3);
        }
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, activationComponent, executeInDispatchThread ? Alarm.ThreadToUse.SWING_THREAD : Alarm.ThreadToUse.POOLED_THREAD);
    }

    public MergingUpdateQueue(@NonNls @NotNull String name, int mergingTimeSpan, boolean isActive, @Nullable JComponent modalityStateComponent, @Nullable Disposable parent, @Nullable JComponent activationComponent, @NotNull Alarm.ThreadToUse thread) {
        if (name == null) {
            MergingUpdateQueue.$$$reportNull$$$0(4);
        }
        if (thread == null) {
            MergingUpdateQueue.$$$reportNull$$$0(5);
        }
        this.myScheduledUpdates = new TreeMap<Integer, Map<Update, Update>>();
        this.myMergingTimeSpan = mergingTimeSpan;
        this.myModalityStateComponent = modalityStateComponent;
        this.myName = name;
        boolean bl = this.myExecuteInDispatchThread = thread == Alarm.ThreadToUse.SWING_THREAD;
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        AlarmFactory alarmFactory = AlarmFactory.getInstance();
        Alarm alarm = this.myWaiterForMerge = this.myExecuteInDispatchThread ? alarmFactory.create(thread) : alarmFactory.create(thread, this);
        if (isActive) {
            this.showNotify();
        }
        if (activationComponent != null) {
            this.setActivationComponent(activationComponent);
        }
    }

    public void setMergingTimeSpan(int timeSpan) {
        this.myMergingTimeSpan = timeSpan;
        if (this.myActive) {
            this.restartTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllUpdates() {
        Map<Integer, Map<Update, Update>> map = this.myScheduledUpdates;
        synchronized (map) {
            for (Update each : this.getAllScheduledUpdates()) {
                try {
                    each.setRejected();
                }
                catch (ProcessCanceledException processCanceledException) {}
            }
            this.myScheduledUpdates.clear();
            this.finishActivity();
        }
    }

    @NotNull
    private List<Update> getAllScheduledUpdates() {
        List list = ContainerUtil.concat(this.myScheduledUpdates.values(), map -> map.keySet());
        if (list == null) {
            MergingUpdateQueue.$$$reportNull$$$0(6);
        }
        return list;
    }

    public final boolean isPassThrough() {
        return this.myPassThrough;
    }

    public final void setPassThrough(boolean passThrough) {
        this.myPassThrough = passThrough;
    }

    @ApiStatus.Internal
    public final MergingUpdateQueue usePassThroughInUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            this.myPassThrough = true;
        }
        return this;
    }

    public void activate() {
        this.showNotify();
    }

    public void deactivate() {
        this.hideNotify();
    }

    public void suspend() {
        this.mySuspended = true;
    }

    public void resume() {
        this.mySuspended = false;
        this.restartTimer();
    }

    @Override
    public void hideNotify() {
        if (!this.myActive) {
            return;
        }
        this.myActive = false;
        this.finishActivity();
        this.clearWaiter();
    }

    @Override
    public void showNotify() {
        if (this.myActive) {
            return;
        }
        this.myActive = true;
        this.restartTimer();
        this.flush();
    }

    public void restartTimer() {
        this.restart(this.myMergingTimeSpan);
    }

    private void restart(int mergingTimeSpanMillis) {
        if (!this.myActive) {
            return;
        }
        this.clearWaiter();
        if (this.myExecuteInDispatchThread) {
            this.myWaiterForMerge.addRequest((Runnable)this, mergingTimeSpanMillis, this.getMergerModalityState());
        } else {
            this.myWaiterForMerge.addRequest((Runnable)this, mergingTimeSpanMillis);
        }
    }

    @Override
    public void run() {
        if (this.mySuspended) {
            return;
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<Integer, Map<Update, Update>> map = this.myScheduledUpdates;
        synchronized (map) {
            if (this.myScheduledUpdates.isEmpty()) {
                this.finishActivity();
                return;
            }
        }
        if (this.myFlushing) {
            return;
        }
        if (!this.isModalityStateCorrect()) {
            return;
        }
        this.myFlushing = true;
        Runnable toRun = () -> {
            try {
                List<Update> all;
                Map<Integer, Map<Update, Update>> map = this.myScheduledUpdates;
                synchronized (map) {
                    all = this.getAllScheduledUpdates();
                    this.myScheduledUpdates.clear();
                }
                for (Update each : all) {
                    each.setProcessed();
                }
                this.execute(all.toArray(new Update[0]));
            }
            finally {
                this.myFlushing = false;
                if (this.isEmpty()) {
                    this.finishActivity();
                }
            }
        };
        if (this.myExecuteInDispatchThread) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)toRun);
        } else {
            toRun.run();
        }
    }

    public void setModalityStateComponent(JComponent modalityStateComponent) {
        this.myModalityStateComponent = modalityStateComponent;
    }

    protected boolean isModalityStateCorrect() {
        ModalityState modalityState;
        if (!this.myExecuteInDispatchThread) {
            return true;
        }
        if (this.myModalityStateComponent == ANY_COMPONENT) {
            return true;
        }
        ModalityState current = ApplicationManager.getApplication().getCurrentModalityState();
        return !current.dominates(modalityState = this.getModalityState());
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    private static boolean isExpired(@NotNull Update each) {
        if (each == null) {
            MergingUpdateQueue.$$$reportNull$$$0(7);
        }
        return each.isDisposed() || each.isExpired();
    }

    protected void execute(Update @NotNull [] update) {
        if (update == null) {
            MergingUpdateQueue.$$$reportNull$$$0(8);
        }
        for (Update each : update) {
            if (MergingUpdateQueue.isExpired(each)) {
                each.setRejected();
                continue;
            }
            if (each.executeInWriteAction()) {
                ApplicationManager.getApplication().runWriteAction(() -> this.execute(each));
                continue;
            }
            this.execute(each);
        }
    }

    private void execute(@NotNull Update each) {
        if (each == null) {
            MergingUpdateQueue.$$$reportNull$$$0(9);
        }
        if (this.myDisposed) {
            each.setRejected();
        } else {
            each.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(@NotNull Update update) {
        if (update == null) {
            MergingUpdateQueue.$$$reportNull$$$0(10);
        }
        if (this.myDisposed) {
            return;
        }
        if (this.myTrackUiActivity) {
            this.startActivity();
        }
        if (this.myPassThrough) {
            update.run();
            this.finishActivity();
            return;
        }
        boolean active = this.myActive;
        Map<Integer, Map<Update, Update>> map = this.myScheduledUpdates;
        synchronized (map) {
            try {
                if (this.eatThisOrOthers(update)) {
                    return;
                }
                if (active && this.myScheduledUpdates.isEmpty()) {
                    this.restartTimer();
                }
                this.put(update);
                if (this.myRestartOnAdd) {
                    this.restartTimer();
                }
            }
            finally {
                if (this.isEmpty()) {
                    this.finishActivity();
                }
            }
        }
    }

    private boolean eatThisOrOthers(@NotNull Update update) {
        Map<Update, Update> updates;
        if (update == null) {
            MergingUpdateQueue.$$$reportNull$$$0(11);
        }
        if ((updates = this.myScheduledUpdates.get(update.getPriority())) != null && updates.containsKey(update)) {
            return false;
        }
        for (Update eachInQueue : this.getAllScheduledUpdates()) {
            if (eachInQueue.canEat(update)) {
                return true;
            }
            if (!update.canEat(eachInQueue)) continue;
            this.myScheduledUpdates.get(eachInQueue.getPriority()).remove(eachInQueue);
            eachInQueue.setRejected();
        }
        return false;
    }

    public final void run(@NotNull Update update) {
        if (update == null) {
            MergingUpdateQueue.$$$reportNull$$$0(12);
        }
        this.execute(new Update[]{update});
    }

    private void put(@NotNull Update update) {
        Map updates;
        Update existing;
        if (update == null) {
            MergingUpdateQueue.$$$reportNull$$$0(13);
        }
        if ((existing = (Update)(updates = this.myScheduledUpdates.computeIfAbsent(update.getPriority(), __ -> new LinkedHashMap())).remove(update)) != null && existing != update) {
            existing.setProcessed();
            existing.setRejected();
        }
        updates.put(update, update);
    }

    public boolean isActive() {
        return this.myActive;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myActive = false;
        this.finishActivity();
        this.clearWaiter();
    }

    private void clearWaiter() {
        this.myWaiterForMerge.cancelAllRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Integer, Map<Update, Update>> map = this.myScheduledUpdates;
        synchronized (map) {
            return this.myName + " active=" + this.myActive + " scheduled=" + this.getAllScheduledUpdates().size();
        }
    }

    @Nullable
    private ModalityState getMergerModalityState() {
        return this.myModalityStateComponent == ANY_COMPONENT ? null : this.getModalityState();
    }

    @NotNull
    public ModalityState getModalityState() {
        if (this.myModalityStateComponent == null) {
            ModalityState modalityState = ModalityState.NON_MODAL;
            if (modalityState == null) {
                MergingUpdateQueue.$$$reportNull$$$0(14);
            }
            return modalityState;
        }
        ModalityState modalityState = ModalityState.stateForComponent(this.myModalityStateComponent);
        if (modalityState == null) {
            MergingUpdateQueue.$$$reportNull$$$0(15);
        }
        return modalityState;
    }

    public void setActivationComponent(@NotNull JComponent c) {
        if (c == null) {
            MergingUpdateQueue.$$$reportNull$$$0(16);
        }
        if (this.myUiNotifyConnector != null) {
            Disposer.dispose((Disposable)this.myUiNotifyConnector);
        }
        UiNotifyConnector connector = new UiNotifyConnector(c, this);
        Disposer.register((Disposable)this, (Disposable)connector);
        this.myUiNotifyConnector = connector;
    }

    public MergingUpdateQueue setRestartTimerOnAdd(boolean restart) {
        this.myRestartOnAdd = restart;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Integer, Map<Update, Update>> map = this.myScheduledUpdates;
        synchronized (map) {
            return this.myScheduledUpdates.isEmpty();
        }
    }

    public void sendFlush() {
        this.restart(0);
    }

    public boolean isFlushing() {
        return this.myFlushing;
    }

    public void setTrackUiActivity(boolean trackUiActivity) {
        if (this.myTrackUiActivity && !trackUiActivity) {
            this.finishActivity();
        }
        this.myTrackUiActivity = trackUiActivity;
    }

    private void startActivity() {
        if (!this.myTrackUiActivity) {
            return;
        }
        UiActivityMonitor.getInstance().addActivity(this.getActivityId(), this.getModalityState());
    }

    private void finishActivity() {
        if (!this.myTrackUiActivity) {
            return;
        }
        UiActivityMonitor.getInstance().removeActivity(this.getActivityId());
    }

    @NotNull
    private UiActivity getActivityId() {
        if (this.myUiActivity == null) {
            this.myUiActivity = new UiActivity.AsyncBgOperation("UpdateQueue:" + this.myName + this.hashCode());
        }
        UiActivity uiActivity = this.myUiActivity;
        if (uiActivity == null) {
            MergingUpdateQueue.$$$reportNull$$$0(17);
        }
        return uiActivity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/update/MergingUpdateQueue";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/update/MergingUpdateQueue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScheduledUpdates";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isExpired";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "eatThisOrOthers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setActivationComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

