/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.DynamicBundle;
import com.intellij.application.options.codeStyle.CommenterForm;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CodeStyleGenerationConfigurable
implements CodeStyleConfigurable {
    private final JavaVisibilityPanel myJavaVisibilityPanel;
    JPanel myPanel;
    private JTextField myFieldPrefixField;
    private JTextField myStaticFieldPrefixField;
    private JTextField myParameterPrefixField;
    private JTextField myLocalVariablePrefixField;
    private JTextField myFieldSuffixField;
    private JTextField myStaticFieldSuffixField;
    private JTextField myParameterSuffixField;
    private JTextField myLocalVariableSuffixField;
    private JCheckBox myCbPreferLongerNames;
    private final CodeStyleSettings mySettings;
    private JCheckBox myCbGenerateFinalParameters;
    private JCheckBox myCbGenerateFinalLocals;
    private JCheckBox myCbUseExternalAnnotations;
    private JCheckBox myInsertOverrideAnnotationCheckBox;
    private JCheckBox myRepeatSynchronizedCheckBox;
    private JPanel myVisibilityPanel;
    private JPanel myCommenterPanel;
    private JPanel myOverridePanel;
    private JBCheckBox myReplaceInstanceOfCb;
    private JBCheckBox myReplaceNullCheckCb;
    private JTextField myTestClassPrefix;
    private JTextField myTestClassSuffix;
    private JTextField mySubclassPrefix;
    private JTextField mySubclassSuffix;
    private JBCheckBox myReplaceSumCb;
    private CommenterForm myCommenterForm;
    private SortedListModel<String> myRepeatAnnotationsModel;

    public CodeStyleGenerationConfigurable(CodeStyleSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.myPanel.setBorder(JBUI.Borders.empty((int)2));
        this.myJavaVisibilityPanel = new JavaVisibilityPanel(false, true, JavaRefactoringBundle.message((String)"default.visibility.border.title", (Object[])new Object[0]));
    }

    public JComponent createComponent() {
        this.myVisibilityPanel.add((Component)((Object)this.myJavaVisibilityPanel), "Center");
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 12, 1, (Insets)new JBInsets(0, 0, 0, 0), 0, 0);
        Condition isApplicable = aClass -> aClass.isAnnotationType();
        this.myRepeatAnnotationsModel = new SortedListModel(Comparator.naturalOrder());
        this.myOverridePanel.add((Component)SpecialAnnotationsUtil.createSpecialAnnotationsListControl("Annotations to Copy", false, (Condition<? super PsiClass>)isApplicable, this.myRepeatAnnotationsModel), gc);
        return this.myPanel;
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle.codegen";
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleGenerationConfigurable.$$$reportNull$$$0(0);
        }
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        this.myCbPreferLongerNames.setSelected(javaSettings.PREFER_LONGER_NAMES);
        this.myFieldPrefixField.setText(javaSettings.FIELD_NAME_PREFIX);
        this.myStaticFieldPrefixField.setText(javaSettings.STATIC_FIELD_NAME_PREFIX);
        this.myParameterPrefixField.setText(javaSettings.PARAMETER_NAME_PREFIX);
        this.myLocalVariablePrefixField.setText(javaSettings.LOCAL_VARIABLE_NAME_PREFIX);
        this.mySubclassPrefix.setText(javaSettings.SUBCLASS_NAME_PREFIX);
        this.myTestClassPrefix.setText(javaSettings.TEST_NAME_PREFIX);
        this.myFieldSuffixField.setText(javaSettings.FIELD_NAME_SUFFIX);
        this.myStaticFieldSuffixField.setText(javaSettings.STATIC_FIELD_NAME_SUFFIX);
        this.myParameterSuffixField.setText(javaSettings.PARAMETER_NAME_SUFFIX);
        this.myLocalVariableSuffixField.setText(javaSettings.LOCAL_VARIABLE_NAME_SUFFIX);
        this.mySubclassSuffix.setText(javaSettings.SUBCLASS_NAME_SUFFIX);
        this.myTestClassSuffix.setText(javaSettings.TEST_NAME_SUFFIX);
        this.myCbGenerateFinalLocals.setSelected(javaSettings.GENERATE_FINAL_LOCALS);
        this.myCbGenerateFinalParameters.setSelected(javaSettings.GENERATE_FINAL_PARAMETERS);
        this.myCbUseExternalAnnotations.setSelected(javaSettings.USE_EXTERNAL_ANNOTATIONS);
        this.myInsertOverrideAnnotationCheckBox.setSelected(javaSettings.INSERT_OVERRIDE_ANNOTATION);
        this.myRepeatSynchronizedCheckBox.setSelected(javaSettings.REPEAT_SYNCHRONIZED);
        this.myJavaVisibilityPanel.setVisibility(javaSettings.VISIBILITY);
        this.myReplaceInstanceOfCb.setSelected(javaSettings.REPLACE_INSTANCEOF_AND_CAST);
        this.myReplaceNullCheckCb.setSelected(javaSettings.REPLACE_NULL_CHECK);
        this.myReplaceSumCb.setSelected(javaSettings.REPLACE_SUM);
        this.myRepeatAnnotationsModel.clear();
        this.myRepeatAnnotationsModel.addAll(javaSettings.getRepeatAnnotations());
        this.myCommenterForm.reset(settings);
    }

    public void reset() {
        this.reset(this.mySettings);
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        if (settings == null) {
            CodeStyleGenerationConfigurable.$$$reportNull$$$0(1);
        }
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        javaSettings.PREFER_LONGER_NAMES = this.myCbPreferLongerNames.isSelected();
        javaSettings.FIELD_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myFieldPrefixField.getText(), true);
        javaSettings.STATIC_FIELD_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myStaticFieldPrefixField.getText(), true);
        javaSettings.PARAMETER_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myParameterPrefixField.getText(), true);
        javaSettings.LOCAL_VARIABLE_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myLocalVariablePrefixField.getText(), true);
        javaSettings.SUBCLASS_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.mySubclassPrefix.getText(), true);
        javaSettings.TEST_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myTestClassPrefix.getText(), true);
        javaSettings.FIELD_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myFieldSuffixField.getText(), false);
        javaSettings.STATIC_FIELD_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myStaticFieldSuffixField.getText(), false);
        javaSettings.PARAMETER_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myParameterSuffixField.getText(), false);
        javaSettings.LOCAL_VARIABLE_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myLocalVariableSuffixField.getText(), false);
        javaSettings.SUBCLASS_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.mySubclassSuffix.getText(), false);
        javaSettings.TEST_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myTestClassSuffix.getText(), false);
        javaSettings.GENERATE_FINAL_LOCALS = this.myCbGenerateFinalLocals.isSelected();
        javaSettings.GENERATE_FINAL_PARAMETERS = this.myCbGenerateFinalParameters.isSelected();
        javaSettings.USE_EXTERNAL_ANNOTATIONS = this.myCbUseExternalAnnotations.isSelected();
        javaSettings.INSERT_OVERRIDE_ANNOTATION = this.myInsertOverrideAnnotationCheckBox.isSelected();
        javaSettings.REPEAT_SYNCHRONIZED = this.myRepeatSynchronizedCheckBox.isSelected();
        javaSettings.VISIBILITY = this.myJavaVisibilityPanel.getVisibility();
        javaSettings.REPLACE_INSTANCEOF_AND_CAST = this.myReplaceInstanceOfCb.isSelected();
        javaSettings.REPLACE_NULL_CHECK = this.myReplaceNullCheckCb.isSelected();
        javaSettings.REPLACE_SUM = this.myReplaceSumCb.isSelected();
        this.myCommenterForm.apply(settings);
        javaSettings.setRepeatAnnotations(this.myRepeatAnnotationsModel.getItems());
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
        }
    }

    private static String setPrefixSuffix(String text2, boolean prefix) throws ConfigurationException {
        if ((text2 = text2.trim()).isEmpty()) {
            return text2;
        }
        if (!StringUtil.isJavaIdentifier((String)text2)) {
            throw new ConfigurationException("Not a valid java identifier part in " + (prefix ? "prefix" : "suffix") + " '" + text2 + "'");
        }
        return text2;
    }

    public void apply() throws ConfigurationException {
        this.apply(this.mySettings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        boolean isModified = this.isModified(this.myCbPreferLongerNames, javaSettings.PREFER_LONGER_NAMES);
        isModified |= this.isModified(this.myFieldPrefixField, javaSettings.FIELD_NAME_PREFIX);
        isModified |= this.isModified(this.myStaticFieldPrefixField, javaSettings.STATIC_FIELD_NAME_PREFIX);
        isModified |= this.isModified(this.myParameterPrefixField, javaSettings.PARAMETER_NAME_PREFIX);
        isModified |= this.isModified(this.myLocalVariablePrefixField, javaSettings.LOCAL_VARIABLE_NAME_PREFIX);
        isModified |= this.isModified(this.mySubclassPrefix, javaSettings.SUBCLASS_NAME_PREFIX);
        isModified |= this.isModified(this.myTestClassPrefix, javaSettings.TEST_NAME_PREFIX);
        isModified |= this.isModified(this.myFieldSuffixField, javaSettings.FIELD_NAME_SUFFIX);
        isModified |= this.isModified(this.myStaticFieldSuffixField, javaSettings.STATIC_FIELD_NAME_SUFFIX);
        isModified |= this.isModified(this.myParameterSuffixField, javaSettings.PARAMETER_NAME_SUFFIX);
        isModified |= this.isModified(this.myLocalVariableSuffixField, javaSettings.LOCAL_VARIABLE_NAME_SUFFIX);
        isModified |= this.isModified(this.mySubclassSuffix, javaSettings.SUBCLASS_NAME_SUFFIX);
        isModified |= this.isModified(this.myTestClassSuffix, javaSettings.TEST_NAME_SUFFIX);
        isModified |= this.isModified(this.myCbGenerateFinalLocals, javaSettings.GENERATE_FINAL_LOCALS);
        isModified |= this.isModified(this.myCbGenerateFinalParameters, javaSettings.GENERATE_FINAL_PARAMETERS);
        isModified |= this.isModified(this.myCbUseExternalAnnotations, javaSettings.USE_EXTERNAL_ANNOTATIONS);
        isModified |= this.isModified(this.myInsertOverrideAnnotationCheckBox, javaSettings.INSERT_OVERRIDE_ANNOTATION);
        isModified |= this.isModified(this.myRepeatSynchronizedCheckBox, javaSettings.REPEAT_SYNCHRONIZED);
        isModified |= this.isModified((JToggleButton)this.myReplaceInstanceOfCb, javaSettings.REPLACE_INSTANCEOF_AND_CAST);
        isModified |= this.isModified((JToggleButton)this.myReplaceNullCheckCb, javaSettings.REPLACE_NULL_CHECK);
        isModified |= this.isModified((JToggleButton)this.myReplaceSumCb, javaSettings.REPLACE_SUM);
        isModified |= !javaSettings.VISIBILITY.equals(this.myJavaVisibilityPanel.getVisibility());
        isModified |= this.myCommenterForm.isModified(settings);
        return isModified |= !this.myRepeatAnnotationsModel.getItems().equals(javaSettings.getRepeatAnnotations());
    }

    public boolean isModified() {
        return this.isModified(this.mySettings);
    }

    private void createUIComponents() {
        this.myCommenterForm = new CommenterForm((Language)JavaLanguage.INSTANCE);
        this.myCommenterPanel = this.myCommenterForm.getCommenterPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JTextField jTextField8;
        JTextField jTextField9;
        JTextField jTextField10;
        JTextField jTextField11;
        JTextField jTextField12;
        JCheckBox jCheckBox6;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 10, 15, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("title.naming"), (int)0, (int)0, null, null));
        this.myCbPreferLongerNames = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("checkbox.prefer.longer.names"));
        jPanel5.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 1, 3, 0, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("label.naming.parameter"));
        jPanel6.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("label.naming.static.field"));
        jPanel6.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("label.naming.field"));
        jPanel6.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("label.naming.local.variable"));
        jPanel6.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFieldPrefixField = jTextField12 = new JTextField();
        jTextField12.setText("");
        jPanel6.add((Component)jTextField12, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myStaticFieldPrefixField = jTextField11 = new JTextField();
        jPanel6.add((Component)jTextField11, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myParameterPrefixField = jTextField10 = new JTextField();
        jPanel6.add((Component)jTextField10, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myLocalVariablePrefixField = jTextField9 = new JTextField();
        jTextField9.setText("");
        jPanel6.add((Component)jTextField9, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myFieldSuffixField = jTextField8 = new JTextField();
        jPanel6.add((Component)jTextField8, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myStaticFieldSuffixField = jTextField7 = new JTextField();
        jPanel6.add((Component)jTextField7, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myParameterSuffixField = jTextField6 = new JTextField();
        jPanel6.add((Component)jTextField6, new GridConstraints(3, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myLocalVariableSuffixField = jTextField5 = new JTextField();
        jPanel6.add((Component)jTextField5, new GridConstraints(4, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("label.name.suffix"));
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("label.name.prefix"));
        jPanel6.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("label.naming.test.class"));
        jPanel6.add((Component)jLabel7, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTestClassPrefix = jTextField4 = new JTextField();
        jPanel6.add((Component)jTextField4, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTestClassSuffix = jTextField3 = new JTextField();
        jPanel6.add((Component)jTextField3, new GridConstraints(6, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("label.naming.subclass"));
        jPanel6.add((Component)jLabel8, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySubclassPrefix = jTextField2 = new JTextField();
        jPanel6.add((Component)jTextField2, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySubclassSuffix = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(5, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("title.naming.final.modifier"), (int)0, (int)0, null, null));
        this.myCbGenerateFinalLocals = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(5, 10, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("checkbox.make.generated.local.variables.final"));
        jPanel7.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateFinalParameters = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(5, 10, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("checkbox.make.generated.parameters.final"));
        jPanel7.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbUseExternalAnnotations = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("use.external.annotations"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOverridePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("code.style.generation.override.method.signature"), (int)0, (int)0, null, null));
        this.myInsertOverrideAnnotationCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("insert.override.annotation"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jCheckBox2, gridBagConstraints);
        this.myRepeatSynchronizedCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("code.style.generation.repeat.synchronized.modifier"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        jPanel2.add((Component)jCheckBox, gridBagConstraints2);
        this.myVisibilityPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, "West");
        JPanel jPanel8 = this.myCommenterPanel;
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel8, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel9, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel9.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("title.naming.functional.expressions"), (int)0, (int)0, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myReplaceInstanceOfCb = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("code.style.generation.use.class.isInstance"));
        jPanel9.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReplaceNullCheckCb = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("code.style.generation.replace.null.check"));
        jPanel9.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReplaceSumCb = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/JavaBundle", CodeStyleGenerationConfigurable.class).getString("code.style.generation.use.integer.sum"));
        jPanel9.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "settings";
        objectArray2[1] = "com/intellij/application/options/CodeStyleGenerationConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

