/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.annoPackages;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.annoPackages.AnnotationPackageSupport;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiAnnotation;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeAnalysisAnnotationSupport
implements AnnotationPackageSupport {
    private static final String PACKAGE_NAME = "codeanalysis.experimental.annotations";
    private static final String NULLABLE = "codeanalysis.experimental.annotations.Nullable";
    private static final String NOT_NULL = "codeanalysis.experimental.annotations.NotNull";
    private static final String NULLNESS_UNKNOWN = "codeanalysis.experimental.annotations.NullnessUnknown";
    private static final String DEFAULT_NULLABLE = "codeanalysis.experimental.annotations.DefaultNullable";
    private static final String DEFAULT_NOT_NULL = "codeanalysis.experimental.annotations.DefaultNotNull";
    private static final String DEFAULT_NULLNESS_UNKNOWN = "codeanalysis.experimental.annotations.DefaultNullnessUnknown";

    private static boolean isAvailable() {
        return Registry.is((String)"java.codeanalysis.annotations.available");
    }

    @Override
    @Nullable
    public NullabilityAnnotationInfo getNullabilityByContainerAnnotation(@NotNull PsiAnnotation anno, // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] types, boolean superPackage) {
        Nullability nullability;
        if (anno == null) {
            CodeAnalysisAnnotationSupport.$$$reportNull$$$0(0);
        }
        if (types == null) {
            CodeAnalysisAnnotationSupport.$$$reportNull$$$0(1);
        }
        if (!CodeAnalysisAnnotationSupport.isAvailable()) {
            return null;
        }
        if (superPackage) {
            return null;
        }
        String name2 = anno.getQualifiedName();
        if (name2 == null) {
            return null;
        }
        if (ArrayUtil.contains((Object)PsiAnnotation.TargetType.LOCAL_VARIABLE, (Object[])types)) {
            return null;
        }
        switch (name2) {
            case "codeanalysis.experimental.annotations.DefaultNullable": {
                nullability = Nullability.NULLABLE;
                break;
            }
            case "codeanalysis.experimental.annotations.DefaultNotNull": {
                nullability = Nullability.NOT_NULL;
                break;
            }
            case "codeanalysis.experimental.annotations.DefaultNullnessUnknown": {
                nullability = Nullability.UNKNOWN;
                break;
            }
            default: {
                return null;
            }
        }
        return new NullabilityAnnotationInfo(anno, nullability, true);
    }

    @Override
    @NotNull
    public List<String> getNullabilityAnnotations(@NotNull Nullability nullability) {
        if (nullability == null) {
            CodeAnalysisAnnotationSupport.$$$reportNull$$$0(2);
        }
        if (!CodeAnalysisAnnotationSupport.isAvailable()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                CodeAnalysisAnnotationSupport.$$$reportNull$$$0(3);
            }
            return list;
        }
        switch (nullability) {
            case NOT_NULL: {
                List<String> list = Collections.singletonList(NOT_NULL);
                if (list == null) {
                    CodeAnalysisAnnotationSupport.$$$reportNull$$$0(4);
                }
                return list;
            }
            case NULLABLE: {
                List<String> list = Collections.singletonList(NULLABLE);
                if (list == null) {
                    CodeAnalysisAnnotationSupport.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<String> list = Collections.singletonList(NULLNESS_UNKNOWN);
        if (list == null) {
            CodeAnalysisAnnotationSupport.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/annoPackages/CodeAnalysisAnnotationSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/annoPackages/CodeAnalysisAnnotationSupport";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityByContainerAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityAnnotations";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

