/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChainLookupElement
extends LookupElementDecorator<LookupElement>
implements TypedLookupItem {
    public static final Key<Boolean> CHAIN_QUALIFIER = Key.create((String)"CHAIN_QUALIFIER");
    public static final ClassConditionKey<JavaChainLookupElement> CLASS_CONDITION_KEY = ClassConditionKey.create(JavaChainLookupElement.class);
    private final LookupElement myQualifier;
    private final String mySeparator;

    public JavaChainLookupElement(LookupElement qualifier, LookupElement main) {
        this(qualifier, main, ".");
    }

    public JavaChainLookupElement(LookupElement qualifier, LookupElement main, String separator) {
        super(main);
        this.myQualifier = qualifier;
        this.mySeparator = separator;
    }

    @NotNull
    public String getLookupString() {
        String string = this.maybeAddParentheses(this.myQualifier.getLookupString()) + this.mySeparator + this.getDelegate().getLookupString();
        if (string == null) {
            JavaChainLookupElement.$$$reportNull$$$0(0);
        }
        return string;
    }

    public LookupElement getQualifier() {
        return this.myQualifier;
    }

    public Set<String> getAllLookupStrings() {
        Set strings = this.getDelegate().getAllLookupStrings();
        THashSet result = new THashSet();
        result.addAll((Collection)strings);
        result.add((Object)this.getLookupString());
        return result;
    }

    @NotNull
    public String toString() {
        String string = this.maybeAddParentheses(this.myQualifier.toString()) + this.mySeparator + this.getDelegate();
        if (string == null) {
            JavaChainLookupElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    private String maybeAddParentheses(String s) {
        return this.getQualifierObject() instanceof PsiMethod ? s + "()" : s;
    }

    @Nullable
    private Object getQualifierObject() {
        Object qObject = this.myQualifier.getObject();
        if (qObject instanceof ResolveResult) {
            qObject = ((ResolveResult)qObject).getElement();
        }
        return qObject;
    }

    public boolean isValid() {
        return super.isValid() && this.myQualifier.isValid();
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        LookupElementPresentation qualifierPresentation = new LookupElementPresentation();
        this.myQualifier.renderElement(qualifierPresentation);
        String name2 = this.maybeAddParentheses(qualifierPresentation.getItemText());
        String qualifierText = this.myQualifier.as(CastingLookupElementDecorator.CLASS_CONDITION_KEY) != null ? "(" + name2 + ")" : name2;
        presentation.setItemText(qualifierText + this.mySeparator + presentation.getItemText());
        if (this.myQualifier instanceof JavaPsiClassReferenceElement) {
            presentation.appendTailText(((JavaPsiClassReferenceElement)this.myQualifier).getLocationString(), false);
        }
        if (qualifierPresentation.isStrikeout()) {
            presentation.setStrikeout(true);
        }
    }

    public void handleInsert(@NotNull InsertionContext context) {
        char atTail;
        if (context == null) {
            JavaChainLookupElement.$$$reportNull$$$0(2);
        }
        Document document = context.getEditor().getDocument();
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)";");
        this.myQualifier.putUserData(CHAIN_QUALIFIER, (Object)true);
        InsertionContext qualifierContext = CompletionUtil.emulateInsertion((InsertionContext)context, (int)context.getStartOffset(), (LookupElement)this.myQualifier);
        OffsetKey oldStart = context.trackOffset(context.getStartOffset(), false);
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
        int start = CharArrayUtil.shiftForward((CharSequence)context.getDocument().getCharsSequence(), (int)context.getStartOffset(), (String)" \t\n");
        if (this.shouldParenthesizeQualifier(context.getFile(), start, qualifierContext.getTailOffset())) {
            String space = CodeStyle.getLanguageSettings((PsiFile)context.getFile()).SPACE_WITHIN_PARENTHESES ? " " : "";
            document.insertString(start, (CharSequence)("(" + space));
            document.insertString(qualifierContext.getTailOffset(), (CharSequence)(space + ")"));
        }
        if ((atTail = document.getCharsSequence().charAt(qualifierContext.getTailOffset())) != ';') {
            return;
        }
        document.replaceString(qualifierContext.getTailOffset(), qualifierContext.getTailOffset() + 1, (CharSequence)this.mySeparator);
        CompletionUtil.emulateInsertion((LookupElement)this.getDelegate(), (int)(qualifierContext.getTailOffset() + this.mySeparator.length()), (InsertionContext)context);
        context.commitDocument();
        int formatStart = context.getOffset(oldStart);
        int formatEnd = context.getTailOffset();
        if (formatStart >= 0 && formatEnd >= 0) {
            CodeStyleManager.getInstance((Project)context.getProject()).reformatText(context.getFile(), formatStart, formatEnd);
        }
    }

    protected boolean shouldParenthesizeQualifier(PsiFile file, int startOffset, int endOffset) {
        PsiElement element = file.findElementAt(startOffset);
        if (element == null) {
            return false;
        }
        PsiElement last = element;
        while (element != null && element.getTextRange().getStartOffset() >= startOffset && element.getTextRange().getEndOffset() <= endOffset && !(element instanceof PsiExpressionStatement)) {
            last = element;
            element = element.getParent();
        }
        PsiExpression expr2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)last, PsiExpression.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
        if (expr2 == null) {
            return false;
        }
        if (expr2.getTextRange().getEndOffset() > endOffset) {
            return true;
        }
        return !(expr2 instanceof PsiJavaCodeReferenceElement) && !(expr2 instanceof PsiMethodCallExpression) && !(expr2 instanceof PsiNewExpression) && !(expr2 instanceof PsiArrayAccessExpression);
    }

    @NotNull
    private LookupElement getComparableQualifier() {
        CastingLookupElementDecorator casting = (CastingLookupElementDecorator)this.myQualifier.as(CastingLookupElementDecorator.CLASS_CONDITION_KEY);
        LookupElement lookupElement = casting == null ? this.myQualifier : casting.getDelegate();
        if (lookupElement == null) {
            JavaChainLookupElement.$$$reportNull$$$0(3);
        }
        return lookupElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getComparableQualifier().equals(((JavaChainLookupElement)o).getComparableQualifier());
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.getComparableQualifier().hashCode();
    }

    @Override
    public PsiType getType() {
        Object object = this.getObject();
        if (object instanceof PsiMember) {
            return JavaCompletionUtil.getQualifiedMemberReferenceType(JavaCompletionUtil.getLookupElementType(this.myQualifier), (PsiMember)object);
        }
        return ((PsiVariable)object).getType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaChainLookupElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaChainLookupElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparableQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

