/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class SuperCalls {
    SuperCalls() {
    }

    static Set<LookupElement> suggestQualifyingSuperCalls(PsiElement element, PsiJavaReference javaReference, ElementFilter elementFilter, JavaCompletionProcessor.Options options, Condition<? super String> nameCondition) {
        LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
        for (String className2 : SuperCalls.getContainingClassNames(element)) {
            PsiReferenceExpression fakeSuper = JavaCompletionUtil.createReference(className2 + ".super.rulez", element);
            PsiElement leaf = Objects.requireNonNull(fakeSuper.getReferenceNameElement());
            JavaCompletionProcessor superProcessor = new JavaCompletionProcessor(leaf, elementFilter, options, nameCondition);
            fakeSuper.processVariants((PsiScopeProcessor)superProcessor);
            for (CompletionElement completionElement : superProcessor.getResults()) {
                for (LookupElement lookupElement : JavaCompletionUtil.createLookupElements(completionElement, javaReference)) {
                    set.add(SuperCalls.withQualifiedSuper(className2, lookupElement));
                }
            }
        }
        return set;
    }

    @NotNull
    private static LookupElement withQualifiedSuper(final String className2, LookupElement item) {
        LookupElement lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)new LookupElementDecorator<LookupElement>(item){

            public void renderElement(LookupElementPresentation presentation) {
                super.renderElement(presentation);
                presentation.setItemText(className2 + ".super." + presentation.getItemText());
            }

            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                context.commitDocument();
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiJavaCodeReferenceElement.class, (boolean)false);
                if (ref != null) {
                    context.getDocument().insertString(ref.getTextRange().getStartOffset(), (CharSequence)(className2 + "."));
                }
                super.handleInsert(context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/SuperCalls$1", "handleInsert"));
            }
        }, (int)-1);
        if (lookupElement == null) {
            SuperCalls.$$$reportNull$$$0(0);
        }
        return lookupElement;
    }

    private static Set<String> getContainingClassNames(PsiElement position) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        boolean add = false;
        while (position != null) {
            if (position instanceof PsiAnonymousClass) {
                add = true;
            } else if (add && position instanceof PsiClass) {
                ContainerUtil.addIfNotNull(result, (Object)((PsiClass)position).getName());
            }
            position = position.getParent();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/SuperCalls", "withQualifiedSuper"));
    }
}

