/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionProcessor
implements PsiScopeProcessor,
ElementClassHint {
    private final boolean myInJavaDoc;
    private boolean myStatic;
    private PsiElement myDeclarationHolder;
    private final Map<CompletionElement, CompletionElement> myResults;
    private final Set<CompletionElement> mySecondRateResults;
    private final Set<String> myShadowedNames;
    private final Set<String> myCurrentScopeMethodNames;
    private final Set<String> myFinishedScopesMethodNames;
    private final PsiElement myElement;
    private final PsiElement myScope;
    private final ElementFilter myFilter;
    private boolean myMembersFlag;
    private final boolean myQualified;
    private PsiType myQualifierType;
    private final Condition<? super String> myMatcher;
    private final Options myOptions;
    private final boolean myAllowStaticWithInstanceQualifier;

    public JavaCompletionProcessor(@NotNull PsiElement element, ElementFilter filter, Options options, @NotNull Condition<? super String> nameCondition) {
        if (element == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(0);
        }
        if (nameCondition == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(1);
        }
        this.myResults = new LinkedHashMap();
        this.mySecondRateResults = ContainerUtil.newIdentityTroveSet();
        this.myShadowedNames = new HashSet<String>();
        this.myCurrentScopeMethodNames = new HashSet<String>();
        this.myFinishedScopesMethodNames = new HashSet<String>();
        this.myOptions = options;
        this.myElement = element;
        this.myMatcher = nameCondition;
        this.myFilter = filter;
        PsiElement scope = element;
        this.myInJavaDoc = JavaResolveUtil.isInJavaDoc(this.myElement);
        if (this.myInJavaDoc) {
            this.myMembersFlag = true;
        }
        while (scope != null && !(scope instanceof PsiFile) && !(scope instanceof PsiClass)) {
            scope = scope.getContext();
        }
        this.myScope = scope;
        PsiClass qualifierClass = null;
        PsiElement elementParent = element.getContext();
        boolean bl = this.myQualified = elementParent instanceof PsiReferenceExpression && ((PsiReferenceExpression)elementParent).isQualified();
        if (elementParent instanceof PsiReferenceExpression) {
            PsiExpression qualifier = ((PsiReferenceExpression)elementParent).getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression) {
                PsiElement target;
                PsiJavaCodeReferenceElement qSuper = ((PsiSuperExpression)qualifier).getQualifier();
                qualifierClass = qSuper == null ? JavaResolveUtil.getContextClass(this.myElement) : ((target = qSuper.resolve()) instanceof PsiClass ? (PsiClass)target : null);
            } else if (qualifier != null) {
                PsiElement target;
                this.myQualifierType = qualifier.getType();
                if (this.myQualifierType == null && qualifier instanceof PsiJavaCodeReferenceElement && (target = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass) {
                    qualifierClass = (PsiClass)target;
                }
            } else {
                qualifierClass = JavaResolveUtil.getContextClass(this.myElement);
            }
        }
        if (qualifierClass != null) {
            this.myQualifierType = JavaPsiFacade.getElementFactory((Project)element.getProject()).createType(qualifierClass);
        }
        this.myAllowStaticWithInstanceQualifier = !options.filterStaticAfterInstance || SuppressManager.getInstance().isSuppressedFor(element, "AccessStaticViaInstance") || Registry.is((String)"ide.java.completion.suggest.static.after.instance");
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(2);
        }
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStatic = true;
        }
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL) {
            this.myMembersFlag = true;
            this.myFinishedScopesMethodNames.addAll(this.myCurrentScopeMethodNames);
            this.myCurrentScopeMethodNames.clear();
        }
        if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myDeclarationHolder = (PsiElement)associated;
        }
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        StaticProblem sp;
        PsiType patchedType;
        PsiMethod method;
        if (element == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(3);
        }
        if (state == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiPackage && !this.isQualifiedContext()) {
            if (this.myScope instanceof PsiClass) {
                return true;
            }
            if (((PsiPackage)element).getQualifiedName().contains(".") && PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiImportStatementBase.class) != null) {
                return true;
            }
        }
        if (element instanceof PsiMethod && PsiTypesUtil.isGetClass((PsiMethod)(method = (PsiMethod)element)) && PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.myElement) && (patchedType = PsiTypesUtil.createJavaLangClassType((PsiElement)this.myElement, (PsiType)this.myQualifierType, (boolean)false)) != null) {
            element = new LightMethodBuilder(element.getManager(), method.getName()).addModifier("public").setMethodReturnType(patchedType).setContainingClass(method.getContainingClass());
        }
        if (element instanceof PsiVariable) {
            String name2 = ((PsiVariable)element).getName();
            if (this.myShadowedNames.contains(name2)) {
                return true;
            }
            if (PsiUtil.isJvmLocalVariable((PsiElement)element)) {
                this.myShadowedNames.add(name2);
            }
        }
        if (element instanceof PsiMethod) {
            this.myCurrentScopeMethodNames.add(((PsiMethod)element).getName());
        }
        if (!this.satisfies((PsiElement)element, state) || !this.isAccessible((PsiElement)element)) {
            return true;
        }
        StaticProblem staticProblem = sp = this.myElement.getParent() instanceof PsiMethodReferenceExpression ? StaticProblem.none : this.getStaticProblem((PsiElement)element);
        if (sp == StaticProblem.instanceAfterStatic) {
            return true;
        }
        CompletionElement completion = new CompletionElement(element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), this.getCallQualifierText((PsiElement)element));
        CompletionElement prev = this.myResults.get(completion);
        if (prev == null || completion.isMoreSpecificThan(prev)) {
            this.myResults.put(completion, completion);
            if (sp == StaticProblem.staticAfterInstance) {
                this.mySecondRateResults.add(completion);
            }
        }
        return true;
    }

    @NotNull
    private String getCallQualifierText(@NotNull PsiElement element) {
        PsiMethod method;
        if (element == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiMethod && this.myFinishedScopesMethodNames.contains((method = (PsiMethod)element).getName())) {
            String className2;
            String string = className2 = this.myDeclarationHolder instanceof PsiClass ? ((PsiClass)this.myDeclarationHolder).getName() : null;
            if (className2 != null) {
                String string2 = className2 + (method.hasModifierProperty("static") ? "." : ".this.");
                if (string2 == null) {
                    JavaCompletionProcessor.$$$reportNull$$$0(6);
                }
                return string2;
            }
        }
        return "";
    }

    private boolean isQualifiedContext() {
        PsiElement elementParent = this.myElement.getParent();
        return elementParent instanceof PsiQualifiedReference && ((PsiQualifiedReference)elementParent).getQualifier() != null;
    }

    private StaticProblem getStaticProblem(PsiElement element) {
        if (this.myOptions.showInstanceInStaticContext && !this.isQualifiedContext()) {
            return StaticProblem.none;
        }
        if (element instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
            if (this.myStatic) {
                if (!(element instanceof PsiClass) && !modifierListOwner.hasModifierProperty("static")) {
                    return StaticProblem.instanceAfterStatic;
                }
            } else if (!this.myAllowStaticWithInstanceQualifier && modifierListOwner.hasModifierProperty("static") && !this.myMembersFlag) {
                return StaticProblem.staticAfterInstance;
            }
        }
        return StaticProblem.none;
    }

    public boolean satisfies(@NotNull PsiElement element, @NotNull ResolveState state) {
        String name2;
        if (element == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(7);
        }
        if (state == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(8);
        }
        return (name2 = PsiUtilCore.getName((PsiElement)element)) != null && StringUtil.isNotEmpty((String)name2) && this.myMatcher.value((Object)name2) && this.myFilter.isClassAcceptable(element.getClass()) && this.myFilter.isAcceptable((Object)new CandidateInfo(element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY)), this.myElement);
    }

    public void setQualifierType(@Nullable PsiType qualifierType) {
        this.myQualifierType = qualifierType;
    }

    @Nullable
    public PsiType getQualifierType() {
        return this.myQualifierType;
    }

    public boolean isAccessible(@Nullable PsiElement element) {
        if (!this.myOptions.checkAccess && this.myInJavaDoc) {
            return true;
        }
        if (this.isAccessibleForResolve(element)) {
            return true;
        }
        return !this.myOptions.checkAccess && !(element instanceof PsiCompiledElement);
    }

    private boolean isAccessibleForResolve(@Nullable PsiElement element) {
        if (element instanceof PsiMember) {
            Set<Object> accessObjectClasses = !this.myQualified ? Collections.singleton(null) : (this.myQualifierType instanceof PsiIntersectionType ? ContainerUtil.map2Set((Object[])((PsiIntersectionType)this.myQualifierType).getConjuncts(), PsiUtil::resolveClassInClassTypeOnly) : Collections.singleton(PsiUtil.resolveClassInClassTypeOnly((PsiType)this.myQualifierType)));
            PsiMember member = (PsiMember)element;
            PsiResolveHelper helper = this.getResolveHelper();
            PsiModifierList modifierList = member.getModifierList();
            return ContainerUtil.exists((Iterable)accessObjectClasses, aoc -> helper.isAccessible(member, modifierList, this.myElement, aoc, this.myDeclarationHolder));
        }
        if (element instanceof PsiPackage) {
            return this.getResolveHelper().isAccessible((PsiPackage)element, this.myElement);
        }
        return true;
    }

    @NotNull
    private PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = JavaPsiFacade.getInstance((Project)this.myElement.getProject()).getResolveHelper();
        if (psiResolveHelper == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(9);
        }
        return psiResolveHelper;
    }

    public void setCompletionElements(Object @NotNull [] elements) {
        if (elements == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(10);
        }
        for (Object element : elements) {
            CompletionElement completion = new CompletionElement(element, PsiSubstitutor.EMPTY);
            this.myResults.put(completion, completion);
        }
    }

    public Iterable<CompletionElement> getResults() {
        if (this.mySecondRateResults.size() == this.myResults.size()) {
            return this.mySecondRateResults;
        }
        return ContainerUtil.filter(this.myResults.values(), element -> !this.mySecondRateResults.contains(element));
    }

    public void clear() {
        this.myResults.clear();
        this.mySecondRateResults.clear();
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind2) {
        if (kind2 == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(11);
        }
        switch (kind2) {
            case CLASS: {
                return this.myFilter.isClassAcceptable(PsiClass.class);
            }
            case FIELD: {
                return this.myFilter.isClassAcceptable(PsiField.class);
            }
            case METHOD: {
                return this.myFilter.isClassAcceptable(PsiMethod.class);
            }
            case PACKAGE: {
                return this.myFilter.isClassAcceptable(PsiPackage.class);
            }
            case VARIABLE: {
                return this.myFilter.isClassAcceptable(PsiVariable.class);
            }
            case ENUM_CONST: {
                return this.myFilter.isClassAcceptable(PsiEnumConstant.class);
            }
        }
        return false;
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            JavaCompletionProcessor.$$$reportNull$$$0(12);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        if (hintKey == JavaCompletionHints.NAME_FILTER) {
            return (T)this.myMatcher;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCondition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/scope/JavaCompletionProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/scope/JavaCompletionProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallQualifierText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCallQualifierText";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "satisfies";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum StaticProblem {
        none,
        staticAfterInstance,
        instanceAfterStatic;

    }

    public static class Options {
        public static final Options DEFAULT_OPTIONS = new Options(true, true, false);
        public static final Options CHECK_NOTHING = new Options(false, false, false);
        final boolean checkAccess;
        final boolean filterStaticAfterInstance;
        final boolean showInstanceInStaticContext;

        private Options(boolean checkAccess, boolean filterStaticAfterInstance, boolean showInstanceInStaticContext) {
            this.checkAccess = checkAccess;
            this.filterStaticAfterInstance = filterStaticAfterInstance;
            this.showInstanceInStaticContext = showInstanceInStaticContext;
        }

        public Options withCheckAccess(boolean checkAccess) {
            return new Options(checkAccess, this.filterStaticAfterInstance, this.showInstanceInStaticContext);
        }

        public Options withFilterStaticAfterInstance(boolean filterStaticAfterInstance) {
            return new Options(this.checkAccess, filterStaticAfterInstance, this.showInstanceInStaticContext);
        }

        public Options withShowInstanceInStaticContext(boolean showInstanceInStaticContext) {
            return new Options(this.checkAccess, this.filterStaticAfterInstance, showInstanceInStaticContext);
        }
    }
}

