/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeStringLiteralToCharInMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConstructorParametersFixer;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertDoubleToFloatFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnFixFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMethodUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final Logger LOG = Logger.getInstance(HighlightMethodUtil.class);

    private HighlightMethodUtil() {
    }

    @NotNull
    static String createClashMethodMessage(@NotNull PsiMethod method1, @NotNull PsiMethod method2, boolean showContainingClasses) {
        if (method1 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(0);
        }
        if (method2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(1);
        }
        if (showContainingClasses) {
            PsiClass class1 = method1.getContainingClass();
            PsiClass class2 = method2.getContainingClass();
            if (class1 != null && class2 != null) {
                String string = JavaErrorBundle.message("clash.methods.message.show.classes", JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2), HighlightUtil.formatClass(class1), HighlightUtil.formatClass(class2));
                if (string == null) {
                    HighlightMethodUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = JavaErrorBundle.message("clash.methods.message", JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2));
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    static HighlightInfo checkMethodWeakerPrivileges(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiFile containingFile) {
        PsiMethod method;
        PsiModifierList modifierList;
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(4);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(5);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(6);
        }
        if ((modifierList = (method = methodSignature.getMethod()).getModifierList()).hasModifierProperty("public")) {
            return null;
        }
        int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            if (method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || !PsiUtil.isAccessible((Project)containingFile.getProject(), (PsiMember)superMethod, (PsiElement)method, null) || !includeRealPositionInfo && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || (info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, includeRealPositionInfo)) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo isWeaker(@NotNull PsiMethod method, @NotNull PsiModifierList modifierList, @NotNull String accessModifier, int accessLevel, @NotNull PsiMethod superMethod, boolean includeRealPositionInfo) {
        int superAccessLevel;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(7);
        }
        if (modifierList == null) {
            HighlightMethodUtil.$$$reportNull$$$0(8);
        }
        if (accessModifier == null) {
            HighlightMethodUtil.$$$reportNull$$$0(9);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(10);
        }
        if (accessLevel < (superAccessLevel = PsiUtil.getAccessLevel((PsiModifierList)superMethod.getModifierList()))) {
            String description = JavaErrorBundle.message("weaker.privileges", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), VisibilityUtil.toPresentableText((String)accessModifier), PsiUtil.getAccessModifier((int)superAccessLevel));
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (includeRealPositionInfo) {
                PsiElement keyword = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)accessModifier);
                if (keyword != null) {
                    textRange = keyword.getTextRange();
                } else {
                    PsiIdentifier identifier = method.getNameIdentifier();
                    if (identifier != null) {
                        textRange = identifier.getTextRange();
                    }
                }
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, null, (IntentionAction)QUICK_FIX_FACTORY.createChangeModifierFix());
            return info;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(11);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(12);
        }
        return HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, includeRealPositionInfo, null);
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @Nullable TextRange textRange) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(13);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(14);
        }
        PsiMethod method = methodSignature.getMethod();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiTypeElement typeElement;
            PsiClass superClass;
            PsiType declaredReturnType;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            PsiType superReturnType = declaredReturnType = superMethod.getReturnType();
            if (methodSignatureBackedByPsiMethod.isRaw()) {
                superReturnType = TypeConversionUtil.erasure((PsiType)declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null) continue;
            if (textRange == null && includeRealPositionInfo && (typeElement = method.getReturnTypeElement()) != null) {
                textRange = typeElement.getTextRange();
            }
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            if ((info = HighlightMethodUtil.checkSuperMethodSignature(superMethod, methodSignatureBackedByPsiMethod, superReturnType, method, methodSignature, returnType, JavaErrorBundle.message("incompatible.return.type", new Object[0]), textRange, PsiUtil.getLanguageLevel((PsiElement)aClass))) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodSignature(@NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange range, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor unifyingSubstitutor;
        PsiClass containingClass;
        PsiClass superContainingClass;
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(15);
        }
        if (superMethodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(16);
        }
        if (superReturnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(17);
        }
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(18);
        }
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(19);
        }
        if (returnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(20);
        }
        if (detailMessage == null) {
            HighlightMethodUtil.$$$reportNull$$$0(21);
        }
        if (range == null) {
            HighlightMethodUtil.$$$reportNull$$$0(22);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(23);
        }
        if ((superContainingClass = superMethod.getContainingClass()) != null && "java.lang.Object".equals(superContainingClass.getQualifiedName()) && !superMethod.hasModifierProperty("public") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !superContainingClass.isInterface()) {
            return null;
        }
        boolean isJdk15 = languageLevel.isAtLeast(LanguageLevel.JDK_1_5);
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals((Object)methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure((PsiType)superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType.equals(substitutedSuperReturnType)) {
            return null;
        }
        if (!(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && ((Boolean)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])methodSignature.getTypeParameters(), (PsiSubstitutor)methodSignature.getSubstitutor(), () -> TypeConversionUtil.isAssignable((PsiType)substitutedSuperReturnType, (PsiType)returnType))).booleanValue()) {
            return null;
        }
        return HighlightMethodUtil.createIncompatibleReturnTypeMessage(method, superMethod, substitutedSuperReturnType, returnType, detailMessage, range);
    }

    private static HighlightInfo createIncompatibleReturnTypeMessage(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiType substitutedSuperReturnType, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange textRange) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(24);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(25);
        }
        if (substitutedSuperReturnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(26);
        }
        if (returnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(27);
        }
        if (detailMessage == null) {
            HighlightMethodUtil.$$$reportNull$$$0(28);
        }
        if (textRange == null) {
            HighlightMethodUtil.$$$reportNull$$$0(29);
        }
        String description = MessageFormat.format("{0}; {1}", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), detailMessage);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, substitutedSuperReturnType, false));
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createSuperMethodReturnFix(superMethod, returnType));
        PsiClass returnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType);
        if (returnClass != null && substitutedSuperReturnType instanceof PsiClassType) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createChangeParameterClassFix(returnClass, (PsiClassType)substitutedSuperReturnType));
        }
        return errorResult;
    }

    static HighlightInfo checkMethodOverridesFinal(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(30);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(31);
        }
        PsiMethod method = methodSignature.getMethod();
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            HighlightInfo info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodIsFinal(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(32);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(33);
        }
        if (superMethod.hasModifierProperty("final")) {
            PsiClass superClass = superMethod.getContainingClass();
            String description = JavaErrorBundle.message("final.method.override", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatMethod(superMethod), superClass != null ? HighlightUtil.formatClass(superClass) : "<unknown>");
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)superMethod, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false)));
            return errorResult;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleThrows(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiClass analyzedClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        ArrayList<PsiJavaCodeReferenceElement> exceptionContexts;
        PsiMethod method;
        PsiClass aClass;
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(34);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(35);
        }
        if (analyzedClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(36);
        }
        if ((aClass = (method = methodSignature.getMethod()).getContainingClass()) == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)analyzedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
        if (includeRealPositionInfo) {
            exceptionContexts = new ArrayList<PsiJavaCodeReferenceElement>();
            referenceElements = method.getThrowsList().getReferenceElements();
        } else {
            exceptionContexts = null;
            referenceElements = null;
        }
        ArrayList<PsiClassType> checkedExceptions = new ArrayList<PsiClassType>();
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType psiClassType = exceptions[i];
            if (psiClassType == null) {
                LOG.error("throws: " + method.getThrowsList().getText() + "; method: " + method);
                continue;
            }
            if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
            checkedExceptions.add(psiClassType);
            if (!includeRealPositionInfo || i >= referenceElements.length) continue;
            PsiJavaCodeReferenceElement exceptionRef = referenceElements[i];
            exceptionContexts.add(exceptionRef);
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            TextRange textRange;
            PsiClass superContainingClass;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            int index = HighlightMethodUtil.getExtraExceptionNum((MethodSignature)methodSignature, methodSignatureBackedByPsiMethod, checkedExceptions, superSubstitutor);
            if (index == -1 || aClass.isInterface() && ((superContainingClass = superMethod.getContainingClass()) != null && !superContainingClass.isInterface() || superContainingClass != null && !aClass.isInheritor(superContainingClass, true))) continue;
            PsiClassType exception = (PsiClassType)checkedExceptions.get(index);
            String description = JavaErrorBundle.message("overridden.method.does.not.throw", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), JavaHighlightUtil.formatType((PsiType)exception));
            if (includeRealPositionInfo) {
                PsiElement exceptionContext = (PsiElement)exceptionContexts.get(index);
                textRange = exceptionContext.getTextRange();
            } else {
                textRange = TextRange.EMPTY_RANGE;
            }
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, false, false)));
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(superMethod, exception, true, true)));
            return errorResult;
        }
        return null;
    }

    private static int getExtraExceptionNum(@NotNull MethodSignature methodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignature, @NotNull List<? extends PsiClassType> checkedExceptions, @NotNull PsiSubstitutor substitutorForDerivedClass) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(37);
        }
        if (superSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(38);
        }
        if (checkedExceptions == null) {
            HighlightMethodUtil.$$$reportNull$$$0(39);
        }
        if (substitutorForDerivedClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(40);
        }
        PsiMethod superMethod = superSignature.getMethod();
        PsiSubstitutor substitutorForMethod = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superSignature);
        for (int i = 0; i < checkedExceptions.size(); ++i) {
            PsiClassType checkedEx = checkedExceptions.get(i);
            PsiType substituted = substitutorForMethod == null ? TypeConversionUtil.erasure((PsiType)checkedEx) : substitutorForMethod.substitute((PsiType)checkedEx);
            PsiType exception = substitutorForDerivedClass.substitute(substituted);
            if (HighlightMethodUtil.isMethodThrows(superMethod, substitutorForMethod, exception, substitutorForDerivedClass)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMethodThrows(@NotNull PsiMethod method, @Nullable PsiSubstitutor substitutorForMethod, PsiType exception, @NotNull PsiSubstitutor substitutorForDerivedClass) {
        PsiClassType[] thrownExceptions;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(41);
        }
        if (substitutorForDerivedClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(42);
        }
        for (PsiClassType thrownException1 : thrownExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiType thrownException = substitutorForMethod != null ? substitutorForMethod.substitute((PsiType)thrownException1) : TypeConversionUtil.erasure((PsiType)thrownException1);
            if (!TypeConversionUtil.isAssignable((PsiType)(thrownException = substitutorForDerivedClass.substitute(thrownException)), (PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    static void checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull JavaSdkVersion javaSdkVersion, @NotNull PsiFile file, HighlightInfoHolder holder) {
        HighlightInfo highlightInfo;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(43);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(44);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(45);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(46);
        }
        if (file == null) {
            HighlightMethodUtil.$$$reportNull$$$0(47);
        }
        PsiExpressionList list = methodCall.getArgumentList();
        PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
        JavaResolveResult[] results = referenceToMethod.multiResolve(true);
        JavaResolveResult resolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = resolveResult.getElement();
        boolean isDummy = HighlightMethodUtil.isDummyConstructorCall(methodCall, resolveHelper, list, referenceToMethod);
        if (isDummy) {
            return;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (resolved instanceof PsiMethod && resolveResult.isValidResult()) {
            PsiElement element;
            PsiClass containingClass;
            PsiElement nameElement = referenceToMethod.getReferenceNameElement();
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
            highlightInfo = HighlightUtil.checkUnhandledExceptions((PsiElement)methodCall, nameElement != null ? nameElement.getTextRange() : fixRange);
            if (highlightInfo == null && ((PsiMethod)resolved).hasModifierProperty("static") && (containingClass = ((PsiMethod)resolved).getContainingClass()) != null && containingClass.isInterface() && (highlightInfo = HighlightUtil.checkFeature(element = (PsiElement)ObjectUtils.notNull((Object)referenceToMethod.getReferenceNameElement(), (Object)referenceToMethod), HighlightUtil.Feature.STATIC_INTERFACE_CALLS, languageLevel, file)) == null) {
                highlightInfo = HighlightMethodUtil.checkStaticInterfaceCallQualifier(referenceToMethod, resolveResult, fixRange, containingClass);
            }
            if (highlightInfo == null) {
                highlightInfo = GenericsHighlightUtil.checkInferredIntersections(substitutor, fixRange);
            }
            if (highlightInfo == null) {
                highlightInfo = HighlightMethodUtil.checkVarargParameterErasureToBeAccessible((MethodCandidateInfo)resolveResult, (PsiCall)methodCall);
            }
            if (highlightInfo == null) {
                highlightInfo = HighlightMethodUtil.createIncompatibleTypeHighlightInfo((PsiCallExpression)methodCall, resolveHelper, (MethodCandidateInfo)resolveResult, fixRange);
            }
        } else {
            PsiMethod resolvedMethod = null;
            MethodCandidateInfo candidateInfo = null;
            if (resolveResult instanceof MethodCandidateInfo) {
                candidateInfo = (MethodCandidateInfo)resolveResult;
                resolvedMethod = candidateInfo.getElement();
            }
            if (!resolveResult.isAccessible() || !resolveResult.isStaticsScopeCorrect()) {
                highlightInfo = null;
            } else if (candidateInfo != null && !candidateInfo.isApplicable()) {
                if (candidateInfo.isTypeArgumentsApplicable()) {
                    highlightInfo = HighlightMethodUtil.createIncompatibleCallHighlightInfo(holder, list, candidateInfo);
                    if (highlightInfo != null) {
                        HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list, resolveHelper);
                        HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, candidateInfo, (PsiCall)methodCall);
                        HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference(methodCall, candidateInfo, resolvedMethod, highlightInfo);
                        holder.add(highlightInfo);
                        return;
                    }
                } else {
                    PsiReferenceParameterList typeArgumentList = methodCall.getTypeArgumentList();
                    PsiSubstitutor applicabilitySubstitutor = candidateInfo.getSubstitutor(false);
                    highlightInfo = typeArgumentList.getTypeArguments().length == 0 && resolvedMethod.hasTypeParameters() ? GenericsHighlightUtil.checkInferredTypeArguments((PsiTypeParameterListOwner)resolvedMethod, (PsiElement)methodCall, applicabilitySubstitutor) : GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, applicabilitySubstitutor, javaSdkVersion);
                }
            } else {
                String description = JavaErrorBundle.message("method.call.expected", new Object[0]);
                highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(description).create();
                if (resolved instanceof PsiClass) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createInsertNewFix(methodCall, (PsiClass)resolved));
                } else {
                    PsiMethod method;
                    TextRange range = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
                    HighlightMethodUtil.registerUsageFixes(methodCall, highlightInfo, range);
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createQualifyStaticMethodCallFix(methodCall));
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
                    if (resolved instanceof PsiVariable && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiVariable)resolved).getType())) != null) {
                        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createInsertMethodCallFix(methodCall, method));
                    }
                }
            }
        }
        if (highlightInfo == null) {
            highlightInfo = GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, substitutor, javaSdkVersion);
        }
        holder.add(highlightInfo);
    }

    private static HighlightInfo createIncompatibleCallHighlightInfo(HighlightInfoHolder holder, PsiExpressionList list, @NotNull MethodCandidateInfo candidateInfo) {
        List<Object> mismatchedExpressions;
        if (candidateInfo == null) {
            HighlightMethodUtil.$$$reportNull$$$0(48);
        }
        PsiMethod resolvedMethod = candidateInfo.getElement();
        PsiSubstitutor substitutor = candidateInfo.getSubstitutor();
        String methodName = HighlightMessageUtil.getSymbolName((PsiElement)resolvedMethod, substitutor);
        PsiClass parent = resolvedMethod.getContainingClass();
        String containerName = parent == null ? "" : HighlightMessageUtil.getSymbolName((PsiElement)parent, substitutor);
        String argTypes = HighlightMethodUtil.buildArgTypesList(list);
        String description = JavaErrorBundle.message("wrong.method.arguments", methodName, containerName, argTypes);
        String toolTip = null;
        if (parent != null) {
            PsiParameter[] parameters2;
            PsiExpression[] expressions2 = list.getExpressions();
            mismatchedExpressions = HighlightMethodUtil.mismatchedArgs(expressions2, substitutor, parameters2 = resolvedMethod.getParameterList().getParameters(), candidateInfo.isVarargs());
            if (mismatchedExpressions.size() == 1) {
                toolTip = HighlightMethodUtil.createOneArgMismatchTooltip(candidateInfo, mismatchedExpressions, expressions2, parameters2);
            }
            if (toolTip == null) {
                toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list);
            }
        } else {
            mismatchedExpressions = Collections.emptyList();
            toolTip = description;
        }
        if (mismatchedExpressions.size() == list.getExpressions().length || mismatchedExpressions.isEmpty()) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).description(description).escapedToolTip(toolTip).navigationShift(1).create();
        }
        HighlightInfo highlightInfo = null;
        for (PsiExpression psiExpression : mismatchedExpressions) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)psiExpression).description(description).escapedToolTip(toolTip).create();
            if (highlightInfo == null) {
                highlightInfo = info;
                continue;
            }
            holder.add(info);
        }
        return highlightInfo;
    }

    private static String createOneArgMismatchTooltip(MethodCandidateInfo candidateInfo, @NotNull List<? extends PsiExpression> mismatchedExpressions, PsiExpression[] expressions2, PsiParameter[] parameters2) {
        PsiExpression wrongArg;
        PsiType argType;
        if (mismatchedExpressions == null) {
            HighlightMethodUtil.$$$reportNull$$$0(49);
        }
        if ((argType = (wrongArg = mismatchedExpressions.get(0)).getType()) != null) {
            boolean varargs = candidateInfo.getApplicabilityLevel() == 2;
            int idx = ArrayUtil.find((Object[])expressions2, (Object)wrongArg);
            PsiType paramType = candidateInfo.getSubstitutor().substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)idx, (boolean)varargs));
            String errorMessage = candidateInfo.getInferenceErrorMessage();
            String reason = errorMessage != null ? "<table><tr><td style='padding-left: 4px; padding-top: 10;'>reason: " + XmlStringUtil.escapeString((String)errorMessage).replaceAll("\n", "<br/>") + "</td></tr></table>" : "";
            return HighlightUtil.createIncompatibleTypesTooltip(paramType, argType, (lRawType, lTypeArguments, rRawType, rTypeArguments) -> JavaErrorBundle.message("incompatible.types.html.tooltip", lRawType, lTypeArguments, rRawType, rTypeArguments, reason, "#" + ColorUtil.toHex((Color)UIUtil.getContextHelpForeground())));
        }
        return null;
    }

    static HighlightInfo createIncompatibleTypeHighlightInfo(@NotNull PsiCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull MethodCandidateInfo resolveResult, TextRange fixRange) {
        String errorMessage;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(50);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(51);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(52);
        }
        if ((errorMessage = resolveResult.getInferenceErrorMessage()) == null) {
            return null;
        }
        PsiMethod method = resolveResult.getElement();
        PsiType expectedTypeByParent = InferenceSession.getTargetTypeByParent((PsiElement)methodCall);
        PsiType actualType = resolveResult.getSubstitutor(false).substitute(method.getReturnType());
        HighlightInfo highlightInfo = expectedTypeByParent != null && actualType != null && !expectedTypeByParent.isAssignableFrom(actualType) ? HighlightUtil.createIncompatibleTypeHighlightInfo(expectedTypeByParent, actualType, fixRange, 0, XmlStringUtil.escapeString((String)errorMessage)) : HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(errorMessage).range(fixRange).create();
        if (highlightInfo != null && methodCall instanceof PsiMethodCallExpression) {
            HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, (PsiMethodCallExpression)methodCall, ((PsiMethodCallExpression)methodCall).getArgumentList(), resolveHelper);
            HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, resolveResult, (PsiCall)methodCall);
            HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference((PsiMethodCallExpression)methodCall, resolveResult, method, highlightInfo);
        }
        return highlightInfo;
    }

    private static void registerUsageFixes(@NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo highlightInfo, @NotNull TextRange range) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(53);
        }
        if (range == null) {
            HighlightMethodUtil.$$$reportNull$$$0(54);
        }
        for (IntentionAction action : QUICK_FIX_FACTORY.createCreateMethodFromUsageFixes(methodCall)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)action);
        }
    }

    private static void registerThisSuperFixes(@NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo highlightInfo, @NotNull TextRange range) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(55);
        }
        if (range == null) {
            HighlightMethodUtil.$$$reportNull$$$0(56);
        }
        for (IntentionAction action : QUICK_FIX_FACTORY.createCreateConstructorFromCallExpressionFixes(methodCall)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)action);
        }
    }

    private static void registerTargetTypeFixesBasedOnApplicabilityInference(@NotNull PsiMethodCallExpression methodCall, @NotNull MethodCandidateInfo resolveResult, @NotNull PsiMethod resolved, HighlightInfo highlightInfo) {
        PsiType expectedTypeByApplicabilityConstraints;
        PsiType rType;
        PsiElement resolve2;
        PsiExpression lExpression;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(57);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(58);
        }
        if (resolved == null) {
            HighlightMethodUtil.$$$reportNull$$$0(59);
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        PsiVariable variable = null;
        if (parent instanceof PsiVariable) {
            variable = (PsiVariable)parent;
        } else if (parent instanceof PsiAssignmentExpression && (lExpression = ((PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
            variable = (PsiVariable)resolve2;
        }
        if (variable != null && (rType = methodCall.getType()) != null && !variable.getType().isAssignableFrom(rType) && (expectedTypeByApplicabilityConstraints = resolveResult.getSubstitutor(false).substitute(resolved.getReturnType())) != null && !variable.getType().isAssignableFrom(expectedTypeByApplicabilityConstraints) && PsiTypesUtil.allTypeParametersResolved((PsiElement)variable, (PsiType)expectedTypeByApplicabilityConstraints)) {
            HighlightFixUtil.registerChangeVariableTypeFixes(variable, expectedTypeByApplicabilityConstraints, (PsiExpression)methodCall, highlightInfo);
        }
    }

    static HighlightInfo checkStaticInterfaceCallQualifier(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult resolveResult, @NotNull TextRange fixRange, @NotNull PsiClass containingClass) {
        String message2;
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(60);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(61);
        }
        if (fixRange == null) {
            HighlightMethodUtil.$$$reportNull$$$0(62);
        }
        if (containingClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(63);
        }
        if ((message2 = HighlightMethodUtil.checkStaticInterfaceMethodCallQualifier(referenceToMethod, resolveResult.getCurrentFileResolveScope(), containingClass)) != null) {
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message2).range(fixRange).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAccessStaticViaInstanceFix(referenceToMethod, resolveResult));
            return highlightInfo;
        }
        return null;
    }

    private static String checkStaticInterfaceMethodCallQualifier(@NotNull PsiReferenceExpression ref, @Nullable PsiElement scope, @NotNull PsiClass containingClass) {
        PsiExpression qualifierExpression2;
        if (ref == null) {
            HighlightMethodUtil.$$$reportNull$$$0(64);
        }
        if (containingClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(65);
        }
        if ((qualifierExpression2 = ref.getQualifierExpression()) == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true))) {
            return null;
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (containingClass.getManager().areElementsEquivalent(resolve2, (PsiElement)containingClass)) {
                return null;
            }
            if (resolve2 instanceof PsiTypeParameter) {
                HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                    PsiClass aClass = type2.resolve();
                    if (aClass == null) continue;
                    classes2.add(aClass);
                }
                if (classes2.size() == 1 && classes2.contains(containingClass)) {
                    return null;
                }
            }
        }
        return JavaErrorBundle.message("static.interface.method.call.qualifier", new Object[0]);
    }

    private static void registerMethodReturnFixAction(@NotNull HighlightInfo highlightInfo, @NotNull MethodCandidateInfo candidate, @NotNull PsiCall methodCall) {
        PsiMethod containerMethod;
        if (highlightInfo == null) {
            HighlightMethodUtil.$$$reportNull$$$0(66);
        }
        if (candidate == null) {
            HighlightMethodUtil.$$$reportNull$$$0(67);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(68);
        }
        if (methodCall.getParent() instanceof PsiReturnStatement && (containerMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) != null) {
            PsiMethod method = candidate.getElement();
            PsiExpression methodCallCopy = JavaPsiFacade.getElementFactory((Project)method.getProject()).createExpressionFromText(methodCall.getText(), (PsiElement)methodCall);
            PsiType methodCallTypeByArgs = methodCallCopy.getType();
            methodCallTypeByArgs = JavaPsiFacade.getElementFactory((Project)method.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)method).substitute(methodCallTypeByArgs);
            if (methodCallTypeByArgs != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)methodCall), (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(containerMethod, methodCallTypeByArgs, true));
            }
        }
    }

    @NotNull
    private static List<PsiExpression> mismatchedArgs(PsiExpression @NotNull [] expressions2, PsiSubstitutor substitutor, PsiParameter @NotNull [] parameters2, boolean varargs) {
        if (expressions2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(69);
        }
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(70);
        }
        if (!(parameters2.length != 0 && parameters2[parameters2.length - 1].isVarArgs() || parameters2.length == expressions2.length)) {
            List<PsiExpression> list = Collections.emptyList();
            if (list == null) {
                HighlightMethodUtil.$$$reportNull$$$0(71);
            }
            return list;
        }
        ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
        for (int i = 0; i < Math.max(parameters2.length, expressions2.length); ++i) {
            if (HighlightMethodUtil.assignmentCompatible(i, parameters2, expressions2, substitutor, varargs)) continue;
            result.add(i < expressions2.length ? expressions2[i] : null);
        }
        ArrayList<PsiExpression> arrayList = result;
        if (arrayList == null) {
            HighlightMethodUtil.$$$reportNull$$$0(72);
        }
        return arrayList;
    }

    static boolean isDummyConstructorCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiExpressionList list, @NotNull PsiReferenceExpression referenceToMethod) {
        CandidateInfo[] candidates;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(73);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(74);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(75);
        }
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(76);
        }
        boolean isDummy = false;
        boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
        if (isThisOrSuper && list.isEmpty() && (candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true)).length == 1 && !candidates[0].getElement().isPhysical()) {
            isDummy = true;
        }
        return isDummy;
    }

    static HighlightInfo checkAmbiguousMethodCallIdentifier(@NotNull PsiReferenceExpression referenceToMethod, JavaResolveResult @NotNull [] resolveResults, @NotNull PsiExpressionList list, @Nullable PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
        HighlightInfo info;
        String description;
        MethodCandidateInfo methodCandidate2;
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(77);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(78);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(79);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(80);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(81);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(82);
        }
        if (file == null) {
            HighlightMethodUtil.$$$reportNull$$$0(83);
        }
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(84);
        }
        if ((methodCandidate2 = (MethodCandidateInfo)HighlightMethodUtil.findCandidates((JavaResolveResult[])resolveResults).second) != null) {
            return null;
        }
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        PsiElement elementToHighlight = (PsiElement)ObjectUtils.notNull((Object)referenceToMethod.getReferenceNameElement(), (Object)referenceToMethod);
        if (element != null && !resolveResult.isAccessible()) {
            description = HighlightUtil.accessProblemDescription((PsiElement)referenceToMethod, element, resolveResult);
        } else if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            PsiClass containingClass;
            if (element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("static") && (containingClass = ((PsiMethod)element).getContainingClass()) != null && containingClass.isInterface()) {
                info = HighlightUtil.checkFeature(elementToHighlight, HighlightUtil.Feature.STATIC_INTERFACE_CALLS, languageLevel, file);
                if (info != null) {
                    return info;
                }
                info = HighlightMethodUtil.checkStaticInterfaceCallQualifier(referenceToMethod, resolveResult, elementToHighlight.getTextRange(), containingClass);
                if (info != null) {
                    return info;
                }
            }
            description = HighlightUtil.staticContextProblemDescription(element);
        } else if (candidates.length == 0) {
            PsiClass qualifierClass = RefactoringChangeUtil.getQualifierClass(referenceToMethod);
            String qualifier = qualifierClass != null ? qualifierClass.getName() : null;
            description = qualifier != null ? JavaErrorBundle.message("ambiguous.method.call.no.match", referenceToMethod.getReferenceName(), qualifier) : JavaErrorBundle.message("cannot.resolve.method", referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list));
            highlightInfoType = HighlightInfoType.WRONG_REF;
        } else {
            return null;
        }
        String toolTip = XmlStringUtil.escapeString((String)description);
        info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list, resolveHelper);
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerStaticProblemQuickFixAction(element, info, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list.getExpressions(), info, fixRange);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, info);
        if (candidates.length == 0) {
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)methodCall.getMethodExpression(), (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
        }
        return info;
    }

    static HighlightInfo checkAmbiguousMethodCallArguments(@NotNull PsiReferenceExpression referenceToMethod, JavaResolveResult @NotNull [] resolveResults, @NotNull PsiExpressionList list, PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiElement elementToHighlight) {
        String toolTip;
        String description;
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(85);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(86);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(87);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(88);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(89);
        }
        if (elementToHighlight == null) {
            HighlightMethodUtil.$$$reportNull$$$0(90);
        }
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(91);
        }
        Pair<MethodCandidateInfo, MethodCandidateInfo> pair2 = HighlightMethodUtil.findCandidates(resolveResults);
        MethodCandidateInfo methodCandidate1 = (MethodCandidateInfo)pair2.first;
        MethodCandidateInfo methodCandidate2 = (MethodCandidateInfo)pair2.second;
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            VirtualFile virtualFile2;
            PsiMethod element1 = methodCandidate1.getElement();
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)element1, (PsiSubstitutor)methodCandidate1.getSubstitutor(false), (int)4353, (int)2);
            PsiMethod element2 = methodCandidate2.getElement();
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)element2, (PsiSubstitutor)methodCandidate2.getSubstitutor(false), (int)4353, (int)2);
            VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile((PsiElement)element1);
            if (!Comparing.equal((Object)virtualFile1, (Object)(virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)element2)))) {
                if (virtualFile1 != null) {
                    m1 = m1 + " (In " + virtualFile1.getPresentableUrl() + ")";
                }
                if (virtualFile2 != null) {
                    m2 = m2 + " (In " + virtualFile2.getPresentableUrl() + ")";
                }
            }
            description = JavaErrorBundle.message("ambiguous.method.call", m1, m2);
            toolTip = HighlightMethodUtil.createAmbiguousMethodHtmlTooltip(new MethodCandidateInfo[]{methodCandidate1, methodCandidate2});
        } else {
            if (element != null && !resolveResult.isAccessible()) {
                return null;
            }
            if (element != null && !resolveResult.isStaticsScopeCorrect()) {
                return null;
            }
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list);
            description = JavaErrorBundle.message("cannot.resolve.method", methodName);
            if (candidates.length == 0) {
                return null;
            }
            toolTip = XmlStringUtil.escapeString((String)description);
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        if (methodCandidate2 == null) {
            HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list, resolveHelper);
        }
        if (!resolveResult.isAccessible() && resolveResult.isStaticsScopeCorrect() && methodCandidate2 != null) {
            HighlightFixUtil.registerAccessQuickFixAction((PsiJvmMember)element, (PsiJavaCodeReferenceElement)referenceToMethod, info, resolveResult.getCurrentFileResolveScope());
        }
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerStaticProblemQuickFixAction(element, info, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list.getExpressions(), info, fixRange);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, info);
        return info;
    }

    @NotNull
    private static Pair<MethodCandidateInfo, MethodCandidateInfo> findCandidates(JavaResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(92);
        }
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        Pair pair2 = Pair.pair(methodCandidate1, methodCandidate2);
        if (pair2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(93);
        }
        return pair2;
    }

    private static MethodCandidateInfo @NotNull [] toMethodCandidates(JavaResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(94);
        }
        ArrayList<MethodCandidateInfo> candidateList = new ArrayList<MethodCandidateInfo>(resolveResults.length);
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isAccessible()) continue;
            candidateList.add(candidate);
        }
        MethodCandidateInfo[] methodCandidateInfoArray = candidateList.toArray(new MethodCandidateInfo[0]);
        if (methodCandidateInfoArray == null) {
            HighlightMethodUtil.$$$reportNull$$$0(95);
        }
        return methodCandidateInfoArray;
    }

    private static void registerMethodCallIntentions(@Nullable HighlightInfo highlightInfo, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList list, @NotNull PsiResolveHelper resolveHelper) {
        PsiType methodCallType;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(96);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(97);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(98);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
        PsiExpression qualifierExpression2 = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (resolve2 instanceof PsiClass && ((PsiClass)resolve2).getContainingClass() != null && !((PsiClass)resolve2).hasModifierProperty("static")) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)highlightInfo, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiClass)resolve2), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)true)));
            }
        } else if (qualifierExpression2 instanceof PsiSuperExpression && ((PsiSuperExpression)qualifierExpression2).getQualifier() == null) {
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifierExpression2, highlightInfo);
        }
        HighlightMethodUtil.registerUsageFixes(methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerThisSuperFixes(methodCall, highlightInfo, fixRange);
        CandidateInfo[] methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false);
        CastMethodArgumentFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        MethodReturnFixFactory.INSTANCE.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerMethodAccessLevelIntentions(methodCandidates, methodCall, list, highlightInfo);
        if (!PermuteArgumentsFix.registerFix(highlightInfo, (PsiCall)methodCall, methodCandidates, fixRange)) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        }
        RemoveRedundantArgumentsFix.registerIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        ConvertDoubleToFloatFix.registerIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])methodCandidates, list.getExpressions(), highlightInfo, fixRange);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, highlightInfo);
        if (methodCandidates.length == 0) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createQualifyStaticMethodCallFix(methodCall));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
        }
        for (IntentionAction action : QUICK_FIX_FACTORY.getVariableTypeFromCallFixes(methodCall, list)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)action);
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createReplaceAddAllArrayToCollectionFix(methodCall));
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createSurroundWithArrayFix((PsiCall)methodCall, null));
        QualifyThisArgumentFix.registerQuickFixAction(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)methodCall);
        if (expectedTypeByParent != null && (methodCallType = methodCall.getType()) != null && TypeConversionUtil.areTypesConvertible((PsiType)methodCallType, (PsiType)expectedTypeByParent) && !TypeConversionUtil.isAssignable((PsiType)expectedTypeByParent, (PsiType)methodCallType)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createAddTypeCastFix(expectedTypeByParent, (PsiExpression)methodCall));
        }
        CandidateInfo[] candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true);
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(candidates, methodCall, highlightInfo);
    }

    private static void registerMethodAccessLevelIntentions(CandidateInfo @NotNull [] methodCandidates, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList exprList, @Nullable HighlightInfo highlightInfo) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(99);
        }
        if (exprList == null) {
            HighlightMethodUtil.$$$reportNull$$$0(100);
        }
        if (methodCandidates == null) {
            HighlightMethodUtil.$$$reportNull$$$0(101);
        }
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (methodCandidate.isAccessible() || !PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)methodCandidate.getSubstitutor(), (PsiExpressionList)exprList)) continue;
            HighlightFixUtil.registerAccessQuickFixAction((PsiJvmMember)method, (PsiJavaCodeReferenceElement)methodCall.getMethodExpression(), highlightInfo, methodCandidate.getCurrentFileResolveScope());
        }
    }

    @NotNull
    private static String createAmbiguousMethodHtmlTooltip(MethodCandidateInfo @NotNull [] methodCandidates) {
        if (methodCandidates == null) {
            HighlightMethodUtil.$$$reportNull$$$0(102);
        }
        String string = JavaErrorBundle.message("ambiguous.method.html.tooltip", methodCandidates[0].getElement().getParameterList().getParametersCount() + 2, HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[0]), HighlightMethodUtil.getContainingClassName(methodCandidates[0]), HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[1]), HighlightMethodUtil.getContainingClassName(methodCandidates[1]));
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(103);
        }
        return string;
    }

    @NotNull
    private static String getContainingClassName(@NotNull MethodCandidateInfo methodCandidate) {
        PsiMethod method;
        PsiClass containingClass;
        if (methodCandidate == null) {
            HighlightMethodUtil.$$$reportNull$$$0(104);
        }
        String string = (containingClass = (method = methodCandidate.getElement()).getContainingClass()) == null ? method.getContainingFile().getName() : HighlightUtil.formatClass(containingClass, false);
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(105);
        }
        return string;
    }

    @Language(value="HTML")
    @NotNull
    private static String createAmbiguousMethodHtmlTooltipMethodRow(@NotNull MethodCandidateInfo methodCandidate) {
        if (methodCandidate == null) {
            HighlightMethodUtil.$$$reportNull$$$0(106);
        }
        PsiMethod method = methodCandidate.getElement();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        StringBuilder ms = new StringBuilder("<td><b>" + method.getName() + "</b></td>");
        for (int j = 0; j < parameters2.length; ++j) {
            PsiParameter parameter2 = parameters2[j];
            PsiType type2 = substitutor.substitute(parameter2.getType());
            ms.append("<td><b>").append(j == 0 ? "(" : "").append(XmlStringUtil.escapeString((String)type2.getPresentableText())).append(j == parameters2.length - 1 ? ")" : ",").append("</b></td>");
        }
        if (parameters2.length == 0) {
            ms.append("<td><b>()</b></td>");
        }
        String string = ms.toString();
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(107);
        }
        return string;
    }

    @NotNull
    private static String createMismatchedArgumentsHtmlTooltip(@NotNull MethodCandidateInfo info, @NotNull PsiExpressionList list) {
        if (info == null) {
            HighlightMethodUtil.$$$reportNull$$$0(108);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(109);
        }
        PsiMethod method = info.getElement();
        PsiSubstitutor substitutor = info.getSubstitutor();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        return HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, info, parameters2, substitutor);
    }

    @Language(value="HTML")
    @NotNull
    private static String createMismatchedArgumentsHtmlTooltip(@NotNull PsiExpressionList list, @Nullable MethodCandidateInfo info, PsiParameter @NotNull [] parameters2, @NotNull PsiSubstitutor substitutor) {
        String errorMessage;
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(110);
        }
        if (substitutor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(111);
        }
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(112);
        }
        PsiExpression[] expressions2 = list.getExpressions();
        if (!(parameters2.length != 0 && parameters2[parameters2.length - 1].isVarArgs() || parameters2.length == expressions2.length)) {
            String string = "<html>Expected " + parameters2.length + " arguments but found " + expressions2.length + "</html>";
            if (string == null) {
                HighlightMethodUtil.$$$reportNull$$$0(113);
            }
            return string;
        }
        String greyedColor = ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground());
        StringBuilder s = new StringBuilder("<html><body><table>");
        s.append("<tr>");
        s.append("<td/>");
        s.append("<td style='color: ").append(greyedColor).append("; padding-left: 16px; padding-right: 24px;'>Required type</td>");
        s.append("<td style='color: ").append(greyedColor).append("; padding-right: 28px;'>Provided</td>");
        s.append("</tr>");
        String parameterNameStyle = String.format("color: %s; font-size:%dpt; padding:1px 4px 1px 4px;", greyedColor, StartupUiUtil.getLabelFont().getSize() - (SystemInfo.isWindows ? 0 : 1));
        Color paramBgColor = EditorColorsUtil.getGlobalOrDefaultColorScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT).getBackgroundColor();
        if (paramBgColor != null) {
            parameterNameStyle = parameterNameStyle + "background-color: " + ColorUtil.toHtmlColor((Color)paramBgColor) + ";";
        }
        boolean varargAdded = false;
        for (int i = 0; i < Math.max(parameters2.length, expressions2.length); ++i) {
            boolean varargs;
            boolean bl = varargs = info != null && info.isVarargs();
            if (HighlightMethodUtil.assignmentCompatible(i, parameters2, expressions2, substitutor, varargs)) continue;
            PsiParameter parameter2 = null;
            if (i < parameters2.length) {
                parameter2 = parameters2[i];
                varargAdded = parameter2.isVarArgs();
            } else if (!varargAdded) {
                parameter2 = parameters2[parameters2.length - 1];
                varargAdded = true;
            }
            PsiType parameterType = substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs));
            PsiExpression expression2 = i < expressions2.length ? expressions2[i] : null;
            boolean showShortType = HighlightUtil.showShortType(parameterType, expression2 != null ? expression2.getType() : null);
            s.append("<tr>");
            if (parameter2 != null) {
                s.append("<td><table><tr><td style='").append(parameterNameStyle).append("'>").append(parameter2.getName()).append(":</td></tr></table></td>");
                s.append("<td style='padding-left: 16px; padding-right: 24px;'>").append(HighlightUtil.redIfNotMatch(substitutor.substitute(parameter2.getType()), true, showShortType)).append("</td>");
            } else {
                s.append("<td/>");
                s.append("<td style='padding-left: 16px; padding-right: 24px;'/>");
            }
            if (expression2 != null) {
                s.append("<td style='padding-right: 28px;'>").append(HighlightMethodUtil.mismatchedExpressionType(parameterType, expression2)).append("</td>");
            } else {
                s.append("<td style='padding-right: 28px;'/>");
            }
            s.append("</tr>");
        }
        s.append("</table>");
        String string = errorMessage = info != null ? info.getInferenceErrorMessage() : null;
        if (errorMessage != null) {
            s.append("<table><tr><td style='padding-left: 4px; padding-top: 10;'>").append("reason: ").append(XmlStringUtil.escapeString((String)errorMessage).replaceAll("\n", "<br/>")).append("</td></tr></table>");
        }
        s.append("</body></html>");
        String string2 = s.toString();
        if (string2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(114);
        }
        return string2;
    }

    @NotNull
    private static String mismatchedExpressionType(PsiType parameterType, @NotNull PsiExpression expression2) {
        if (expression2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(115);
        }
        String string = HighlightUtil.createIncompatibleTypesTooltip(parameterType, expression2.getType(), new HighlightUtil.IncompatibleTypesTooltipComposer(){

            @Override
            @NotNull
            public String consume(@NotNull String lRawType, @NotNull String lTypeArguments, @NotNull String rRawType, @NotNull String rTypeArguments) {
                if (lRawType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (lTypeArguments == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (rRawType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (rTypeArguments == null) {
                    1.$$$reportNull$$$0(3);
                }
                String string = rRawType + rTypeArguments;
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            @Override
            public boolean skipTypeArgsColumns() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lRawType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lTypeArguments";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rRawType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rTypeArguments";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "consume";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "consume";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(116);
        }
        return string;
    }

    private static boolean assignmentCompatible(int i, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] expressions2, @NotNull PsiSubstitutor substitutor, boolean varargs) {
        PsiExpression expression2;
        if (substitutor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(117);
        }
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(118);
        }
        if (expressions2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(119);
        }
        PsiExpression psiExpression = expression2 = i < expressions2.length ? expressions2[i] : null;
        if (expression2 == null) {
            return true;
        }
        PsiType paramType = substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs));
        return paramType != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression2);
    }

    static HighlightInfo checkMethodMustHaveBody(@NotNull PsiMethod method, @Nullable PsiClass aClass) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(120);
        }
        HighlightInfo errorResult = null;
        if (!(method.getBody() != null || method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || aClass == null || aClass.isInterface() || PsiUtilCore.hasErrorElementChild((PsiElement)method))) {
            int start = method.getModifierList().getTextRange().getStartOffset();
            int end = method.getTextRange().getEndOffset();
            String description = JavaErrorBundle.message("missing.method.body", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
            if (HighlightUtil.getIncompatibleModifier("abstract", method.getModifierList()) == null && !(aClass instanceof PsiAnonymousClass)) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)method, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.ABSTRACT, (boolean)true)));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
        }
        return errorResult;
    }

    static HighlightInfo checkAbstractMethodInConcreteClass(@NotNull PsiMethod method, @NotNull PsiElement elementToHighlight) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(121);
        }
        if (elementToHighlight == null) {
            HighlightMethodUtil.$$$reportNull$$$0(122);
        }
        HighlightInfo errorResult = null;
        PsiClass aClass = method.getContainingClass();
        if (method.hasModifierProperty("abstract") && aClass != null && !aClass.hasModifierProperty("abstract") && !aClass.isEnum() && !PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            String description = JavaErrorBundle.message("abstract.method.in.non.abstract.class", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            if (method.getBody() != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false));
        }
        return errorResult;
    }

    static HighlightInfo checkConstructorName(@NotNull PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(123);
        }
        if ((aClass = method.getContainingClass()) != null) {
            String className2;
            String string = className2 = aClass instanceof PsiAnonymousClass ? null : aClass.getName();
            if (className2 == null || !Comparing.strEqual((String)method.getName(), (String)className2)) {
                PsiElement element = (PsiElement)ObjectUtils.notNull((Object)method.getNameIdentifier(), (Object)method);
                String description = JavaErrorBundle.message("missing.return.type", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
                if (className2 != null) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)method, className2));
                }
                return info;
            }
        }
        return null;
    }

    static HighlightInfo checkDuplicateMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, @NotNull MostlySingularMultiMap<MethodSignature, PsiMethod> duplicateMethods) {
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(124);
        }
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(125);
        }
        if (duplicateMethods == null) {
            HighlightMethodUtil.$$$reportNull$$$0(126);
        }
        if (method instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        int methodCount = 1;
        List methods = (List)duplicateMethods.get((Object)methodSignature);
        if (methods.size() > 1) {
            ++methodCount;
        }
        if (methodCount == 1 && aClass.isEnum() && GenericsHighlightUtil.isEnumSyntheticMethod(methodSignature, aClass.getProject())) {
            ++methodCount;
        }
        if (methodCount > 1) {
            String description = JavaErrorBundle.message("duplicate.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)method, textRange.getStartOffset(), textRange.getEndOffset()).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkMethodCanHaveBody(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(127);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(128);
        }
        PsiClass aClass = method.getContainingClass();
        boolean hasNoBody = method.getBody() == null;
        boolean isInterface = aClass != null && aClass.isInterface();
        boolean isExtension = method.hasModifierProperty("default");
        boolean isStatic = method.hasModifierProperty("static");
        boolean isPrivate = method.hasModifierProperty("private");
        ArrayList<Object> additionalFixes = new ArrayList<Object>();
        String description = null;
        if (hasNoBody) {
            if (isExtension) {
                description = JavaErrorBundle.message("extension.method.should.have.a.body", new Object[0]);
            } else if (isInterface) {
                if (isStatic && languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    description = "Static methods in interfaces should have a body";
                } else if (isPrivate && languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                    description = "Private methods in interfaces should have a body";
                }
            }
            if (description != null) {
                additionalFixes.add(QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            }
        } else if (isInterface) {
            if (!(isExtension || isStatic || isPrivate)) {
                description = JavaErrorBundle.message("interface.methods.cannot.have.body", new Object[0]);
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && Stream.of(method.findDeepestSuperMethods()).map(PsiJvmMember::getContainingClass).filter(Objects::nonNull).map(PsiClass::getQualifiedName).noneMatch("java.lang.Object"::equals)) {
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "default", true, false));
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", true, false));
                }
            }
        } else if (isExtension) {
            description = JavaErrorBundle.message("extension.method.in.class", new Object[0]);
            additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "default", false, false));
        } else if (method.hasModifierProperty("abstract")) {
            description = JavaErrorBundle.message("abstract.methods.cannot.have.a.body", new Object[0]);
        } else if (method.hasModifierProperty("native")) {
            description = JavaErrorBundle.message("native.methods.cannot.have.a.body", new Object[0]);
        }
        if (description == null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        if (!hasNoBody) {
            if (!isExtension) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteMethodBodyFix(method));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createPushDownMethodFix());
        }
        if (method.hasModifierProperty("abstract") && !isInterface) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false));
        }
        for (IntentionAction intentionAction : additionalFixes) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)intentionAction);
        }
        return info;
    }

    static HighlightInfo checkConstructorCallProblems(@NotNull PsiMethodCallExpression methodCall) {
        PsiMethod ctor;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(129);
        }
        if (!JavaPsiConstructorUtil.isConstructorCall((PsiElement)methodCall)) {
            return null;
        }
        PsiElement codeBlock = methodCall.getParent().getParent();
        if (codeBlock instanceof PsiCodeBlock && (ctor = (PsiMethod)ObjectUtils.tryCast((Object)codeBlock.getParent(), PsiMethod.class)) != null && ctor.isConstructor()) {
            if (JavaPsiRecordUtil.isCompactConstructor(ctor) || JavaPsiRecordUtil.isExplicitCanonicalConstructor(ctor)) {
                String message2 = JavaErrorBundle.message("record.constructor.call.in.canonical", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(message2).create();
            }
            PsiElement prevSibling = methodCall.getParent().getPrevSibling();
            while (true) {
                if (prevSibling == null) {
                    return null;
                }
                if (prevSibling instanceof PsiStatement) break;
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        PsiReferenceExpression expression2 = methodCall.getMethodExpression();
        String message3 = JavaErrorBundle.message("constructor.call.must.be.first.statement", expression2.getText() + "()");
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(message3).create();
    }

    static HighlightInfo checkSuperAbstractMethodDirectCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression expression2;
        if (methodCallExpression == null) {
            HighlightMethodUtil.$$$reportNull$$$0(130);
        }
        if (!((expression2 = methodCallExpression.getMethodExpression()).getQualifierExpression() instanceof PsiSuperExpression)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method != null && method.hasModifierProperty("abstract")) {
            String message2 = JavaErrorBundle.message("direct.abstract.method.access", JavaHighlightUtil.formatMethod(method));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCallExpression).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkConstructorCallsBaseClassConstructor(@NotNull PsiMethod constructor, @Nullable RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper) {
        PsiClassType[] handledExceptions;
        if (constructor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(131);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(132);
        }
        if (!constructor.isConstructor()) {
            return null;
        }
        PsiClass aClass = constructor.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (aClass.isEnum()) {
            return null;
        }
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 == null) {
            return null;
        }
        if (JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor) != null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(constructor);
        HighlightInfo info = HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, handledExceptions = constructor.getThrowsList().getReferencedTypes());
        if (info != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createInsertSuperFix(constructor));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createInsertThisFix(constructor));
            PsiClass superClass = aClass.getSuperClass();
            if (superClass != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddDefaultConstructorFix(superClass));
            }
        }
        return info;
    }

    static HighlightInfo checkStaticMethodOverride(@NotNull PsiMethod method, @NotNull PsiFile containingFile) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(133);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(134);
        }
        if (method.isConstructor()) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        HierarchicalMethodSignature methodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method);
        List superSignatures = methodSignature.getSuperSignatures();
        if (superSignatures.isEmpty()) {
            return null;
        }
        boolean isStatic = method.hasModifierProperty("static");
        for (HierarchicalMethodSignature signature : superSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod superMethod = signature.getMethod();
            PsiClass superClass = superMethod.getContainingClass();
            if (superClass == null || (highlightInfo = HighlightMethodUtil.checkStaticMethodOverride(aClass, method, isStatic, superClass, superMethod, containingFile)) == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkStaticMethodOverride(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean isMethodStatic, @NotNull PsiClass superClass, @NotNull PsiMethod superMethod, @NotNull PsiFile containingFile) {
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(135);
        }
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(136);
        }
        if (superClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(137);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(138);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(139);
        }
        PsiManager manager = containingFile.getManager();
        PsiModifierList superModifierList = superMethod.getModifierList();
        PsiModifierList modifierList = method.getModifierList();
        if (superModifierList.hasModifierProperty("private")) {
            return null;
        }
        if (superModifierList.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)manager.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
            return null;
        }
        boolean isSuperMethodStatic = superModifierList.hasModifierProperty("static");
        if (isMethodStatic != isSuperMethodStatic) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String messageKey = isMethodStatic ? "static.method.cannot.override.instance.method" : "instance.method.cannot.override.static.method";
            String description = JavaErrorBundle.message(messageKey, JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superClass));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (!isSuperMethodStatic || HighlightUtil.getIncompatibleModifier("static", modifierList) == null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", isSuperMethodStatic, false));
            }
            if (manager.isInProject((PsiElement)superMethod) && (!isMethodStatic || HighlightUtil.getIncompatibleModifier("static", superModifierList) == null)) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)info, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)superMethod, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)isMethodStatic)));
            }
            return info;
        }
        if (isMethodStatic) {
            if (superClass.isInterface()) {
                return null;
            }
            int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
            String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
            HighlightInfo info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, true);
            if (info != null) {
                return info;
            }
            info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private static HighlightInfo checkInterfaceInheritedMethodsReturnTypes(@NotNull List<? extends MethodSignatureBackedByPsiMethod> superMethodSignatures, @NotNull LanguageLevel languageLevel) {
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(140);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(141);
        }
        if (superMethodSignatures.size() < 2) {
            return null;
        }
        MethodSignatureBackedByPsiMethod[] returnTypeSubstitutable = new MethodSignatureBackedByPsiMethod[]{superMethodSignatures.get(0)};
        for (int i = 1; i < superMethodSignatures.size(); ++i) {
            PsiMethod currentMethod = returnTypeSubstitutable[0].getMethod();
            PsiType currentType = returnTypeSubstitutable[0].getSubstitutor().substitute(currentMethod.getReturnType());
            MethodSignatureBackedByPsiMethod otherSuperSignature = superMethodSignatures.get(i);
            PsiMethod otherSuperMethod = otherSuperSignature.getMethod();
            PsiSubstitutor otherSubstitutor = otherSuperSignature.getSubstitutor();
            PsiType otherSuperReturnType = otherSubstitutor.substitute(otherSuperMethod.getReturnType());
            PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)returnTypeSubstitutable[0], (MethodSignature)otherSuperSignature);
            if (unifyingSubstitutor != null) {
                otherSuperReturnType = unifyingSubstitutor.substitute(otherSuperReturnType);
                currentType = unifyingSubstitutor.substitute(currentType);
            }
            if (otherSuperReturnType == null || currentType == null || otherSuperReturnType.equals(currentType)) continue;
            PsiType otherReturnType = otherSuperReturnType;
            PsiType curType = currentType;
            HighlightInfo info = (HighlightInfo)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])otherSuperMethod.getTypeParameters(), (PsiSubstitutor)otherSubstitutor, () -> {
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                    if (!(otherReturnType instanceof PsiPrimitiveType) && !(curType instanceof PsiPrimitiveType)) {
                        if (otherReturnType.isAssignableFrom(curType)) {
                            return null;
                        }
                        if (curType.isAssignableFrom(otherReturnType)) {
                            returnTypeSubstitutable[0] = otherSuperSignature;
                            return null;
                        }
                    }
                    if (otherSuperMethod.getTypeParameters().length > 0 && JavaGenericsUtil.isRawToGeneric((PsiType)otherReturnType, (PsiType)curType)) {
                        return null;
                    }
                }
                return HighlightMethodUtil.createIncompatibleReturnTypeMessage(otherSuperMethod, currentMethod, curType, otherReturnType, JavaErrorBundle.message("unrelated.overriding.methods.return.types", new Object[0]), TextRange.EMPTY_RANGE);
            });
            if (info == null) continue;
            return info;
        }
        return null;
    }

    static HighlightInfo checkOverrideEquivalentInheritedMethods(@NotNull PsiClass aClass, @NotNull PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(142);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(143);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(144);
        }
        String description = null;
        boolean appendImplementMethodFix = true;
        Collection visibleSignatures = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        block0: for (HierarchicalMethodSignature signature : visibleSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod method = signature.getMethod();
            if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, null)) continue;
            ArrayList<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            boolean allAbstracts = method.hasModifierProperty("abstract");
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || aClass.equals(containingClass) || aClass.isInterface() && !containingClass.isInterface()) continue;
            if (allAbstracts) {
                superSignatures = new ArrayList<HierarchicalMethodSignature>(superSignatures);
                superSignatures.add(0, signature);
                highlightInfo = HighlightMethodUtil.checkInterfaceInheritedMethodsReturnTypes(superSignatures, languageLevel);
            } else {
                highlightInfo = HighlightMethodUtil.checkMethodIncompatibleReturnType((MethodSignatureBackedByPsiMethod)signature, (List<? extends HierarchicalMethodSignature>)superSignatures, false);
            }
            if (highlightInfo != null) {
                description = highlightInfo.getDescription();
            }
            if (method.hasModifierProperty("static")) {
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (superMethod.hasModifierProperty("static")) continue;
                    PsiClass superClass = superMethod.getContainingClass();
                    description = JavaErrorBundle.message("static.method.cannot.override.instance.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass), JavaHighlightUtil.formatMethod(superMethod), superClass != null ? HighlightUtil.formatClass(superClass) : "<unknown>");
                    appendImplementMethodFix = false;
                    break block0;
                }
                continue;
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodIncompatibleThrows((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, aClass)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodWeakerPrivileges((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, containingFile)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null) continue;
            break;
        }
        if (description != null) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (appendImplementMethodFix) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkConstructorHandleSuperClassExceptions(@NotNull PsiMethod method) {
        PsiStatement[] statements;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(145);
        }
        if (!method.isConstructor()) {
            return null;
        }
        PsiCodeBlock body2 = method.getBody();
        PsiStatement[] psiStatementArray = statements = body2 == null ? null : body2.getStatements();
        if (statements == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)method, (PsiElement)method.getContainingClass());
        if (unhandled.isEmpty()) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled);
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        for (PsiClassType exception : unhandled) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, true, false)));
        }
        return highlightInfo;
    }

    static HighlightInfo checkRecursiveConstructorInvocation(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(146);
        }
        if (HighlightControlFlowUtil.isRecursivelyCalledConstructor(method)) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String description = JavaErrorBundle.message("recursive.constructor.invocation", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    public static TextRange getFixRange(@NotNull PsiElement element) {
        if (element == null) {
            HighlightMethodUtil.$$$reportNull$$$0(147);
        }
        TextRange range = element.getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.SEMICOLON)) {
            return new TextRange(start, end + 1);
        }
        TextRange textRange = range;
        if (textRange == null) {
            HighlightMethodUtil.$$$reportNull$$$0(148);
        }
        return textRange;
    }

    static void checkNewExpression(@NotNull PsiNewExpression expression2, @Nullable PsiType type2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        if (expression2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(149);
        }
        if (holder == null) {
            HighlightMethodUtil.$$$reportNull$$$0(150);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(151);
        }
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
        PsiClass aClass = typeResult.getElement();
        if (aClass == null) {
            return;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type2 = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
        HighlightMethodUtil.checkConstructorCall(typeResult, (PsiConstructorCall)expression2, type2, classReference2, holder, javaSdkVersion);
    }

    static void checkConstructorCall(@NotNull PsiClassType.ClassResolveResult typeResolveResult, @NotNull PsiConstructorCall constructorCall, @NotNull PsiType type2, @Nullable PsiJavaCodeReferenceElement classReference2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        PsiExpression qualifier;
        PsiExpressionList list;
        if (typeResolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(152);
        }
        if (constructorCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(153);
        }
        if (type2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(154);
        }
        if (holder == null) {
            HighlightMethodUtil.$$$reportNull$$$0(155);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(156);
        }
        if ((list = constructorCall.getArgumentList()) == null) {
            return;
        }
        PsiClass aClass = typeResolveResult.getElement();
        if (aClass == null) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)holder.getProject()).getResolveHelper();
        PsiClass accessObjectClass = null;
        if (constructorCall instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)constructorCall).getQualifier()) != null) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
        }
        if (classReference2 != null && !resolveHelper.isAccessible((PsiMember)aClass, (PsiElement)constructorCall, accessObjectClass)) {
            String description = HighlightUtil.accessProblemDescription((PsiElement)classReference2, (PsiElement)aClass, (JavaResolveResult)typeResolveResult);
            PsiElement element = (PsiElement)ObjectUtils.notNull((Object)classReference2.getReferenceNameElement(), (Object)classReference2);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            HighlightFixUtil.registerAccessQuickFixAction((PsiJvmMember)aClass, classReference2, info, null);
            holder.add(info);
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            PsiReferenceParameterList typeArgumentList;
            if (!list.isEmpty()) {
                String constructorName = aClass.getName();
                String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorBundle.message("wrong.constructor.arguments", constructorName + "()", argTypes);
                String tooltip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, null, PsiParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).description(description).escapedToolTip(tooltip).navigationShift(1).create();
                QuickFixAction.registerQuickFixActions((HighlightInfo)info, (TextRange)constructorCall.getTextRange(), (Iterable)QUICK_FIX_FACTORY.createCreateConstructorFromUsageFixes(constructorCall));
                if (classReference2 != null) {
                    ConstructorParametersFixer.registerFixActions(classReference2, constructorCall, info, HighlightMethodUtil.getFixRange((PsiElement)list));
                }
                holder.add(info);
                return;
            }
            if (classReference2 != null && aClass.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass)) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference2, (PsiJvmMember)aClass, (JavaResolveResult)typeResolveResult));
            } else if (aClass.isInterface() && constructorCall instanceof PsiNewExpression && (typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList()).getTypeArguments().length > 0) {
                holder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeArgumentList).descriptionAndTooltip("Anonymous class implements interface; cannot have type arguments").create());
            }
        } else {
            PsiReferenceParameterList typeArgumentList;
            HighlightInfo info;
            PsiExpressionList infoElement;
            PsiAnonymousClass anonymousClass;
            PsiExpressionList place = list;
            if (constructorCall instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)constructorCall).getAnonymousClass()) != null) {
                place = anonymousClass;
            }
            JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type2, list, (PsiElement)place);
            MethodCandidateInfo result = null;
            if (results.length == 1) {
                result = (MethodCandidateInfo)results[0];
            }
            PsiMethod constructor = result == null ? null : result.getElement();
            boolean applicable = true;
            try {
                JavaResolveResult staticFactory;
                PsiDiamondType diamondType = constructorCall instanceof PsiNewExpression ? PsiDiamondType.getDiamondType((PsiNewExpression)((PsiNewExpression)constructorCall)) : null;
                JavaResolveResult javaResolveResult = staticFactory = diamondType != null ? diamondType.getStaticFactory() : null;
                if (staticFactory instanceof MethodCandidateInfo) {
                    if (((MethodCandidateInfo)staticFactory).isApplicable()) {
                        result = (MethodCandidateInfo)staticFactory;
                        if (constructor == null) {
                            constructor = ((MethodCandidateInfo)staticFactory).getElement();
                        }
                    } else {
                        applicable = false;
                    }
                } else {
                    applicable = result != null && result.isApplicable();
                }
            }
            catch (IndexNotReadyException diamondType) {
                // empty catch block
            }
            Object object = infoElement = list.getTextLength() > 0 ? list : constructorCall;
            if (constructor == null) {
                String name2 = aClass.getName();
                name2 = name2 + HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorBundle.message("cannot.resolve.constructor", name2);
                HighlightInfo info2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).navigationShift(1).create();
                if (info2 != null) {
                    WrapExpressionFix.registerWrapAction(results, list.getExpressions(), info2, HighlightMethodUtil.getFixRange((PsiElement)list));
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference2, list, aClass, constructors, results, (PsiElement)infoElement, info2);
                    holder.add(info2);
                }
            } else if (classReference2 != null && (!result.isAccessible() || constructor.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass))) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference2, (PsiJvmMember)constructor, (JavaResolveResult)result));
            } else if (!applicable) {
                HighlightInfo info3 = HighlightMethodUtil.createIncompatibleCallHighlightInfo(holder, list, result);
                if (info3 != null) {
                    JavaResolveResult[] methodCandidates = results;
                    if (constructorCall instanceof PsiNewExpression) {
                        methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)constructorCall, true);
                    }
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference2, list, aClass, constructors, methodCandidates, (PsiElement)infoElement, info3);
                    HighlightMethodUtil.registerMethodReturnFixAction(info3, result, (PsiCall)constructorCall);
                    holder.add(info3);
                }
            } else if (constructorCall instanceof PsiNewExpression && (info = GenericsHighlightUtil.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)constructor, typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList(), result.getSubstitutor(), false, javaSdkVersion)) != null) {
                holder.add(info);
            }
            if (result != null && !holder.hasErrorResults()) {
                holder.add(HighlightMethodUtil.checkVarargParameterErasureToBeAccessible(result, (PsiCall)constructorCall));
            }
        }
    }

    private static HighlightInfo checkVarargParameterErasureToBeAccessible(@NotNull MethodCandidateInfo info, @NotNull PsiCall place) {
        if (info == null) {
            HighlightMethodUtil.$$$reportNull$$$0(157);
        }
        if (place == null) {
            HighlightMethodUtil.$$$reportNull$$$0(158);
        }
        PsiMethod method = info.getElement();
        if (info.isVarargs() || method.isVarArgs() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)place)) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiType componentType = ((PsiEllipsisType)parameters2[parameters2.length - 1].getType()).getComponentType();
            PsiType substitutedTypeErasure = TypeConversionUtil.erasure((PsiType)info.getSubstitutor().substitute(componentType));
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)substitutedTypeErasure);
            if (targetClass != null && !PsiUtil.isAccessible((PsiMember)targetClass, (PsiElement)place, null)) {
                PsiExpressionList argumentList = place.getArgumentList();
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip("Formal varargs element type " + PsiFormatUtil.formatClass((PsiClass)targetClass, (int)2048) + " is inaccessible here").range((PsiElement)(argumentList != null ? argumentList : place)).create();
            }
        }
        return null;
    }

    private static void registerFixesOnInvalidConstructorCall(@NotNull PsiConstructorCall constructorCall, @Nullable PsiJavaCodeReferenceElement classReference2, @NotNull PsiExpressionList list, @NotNull PsiClass aClass, PsiMethod @NotNull [] constructors, JavaResolveResult @NotNull [] results, @NotNull PsiElement infoElement, @NotNull HighlightInfo info) {
        if (constructorCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(159);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(160);
        }
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(161);
        }
        if (infoElement == null) {
            HighlightMethodUtil.$$$reportNull$$$0(162);
        }
        if (info == null) {
            HighlightMethodUtil.$$$reportNull$$$0(163);
        }
        if (constructors == null) {
            HighlightMethodUtil.$$$reportNull$$$0(164);
        }
        if (results == null) {
            HighlightMethodUtil.$$$reportNull$$$0(165);
        }
        QuickFixAction.registerQuickFixActions((HighlightInfo)info, (TextRange)constructorCall.getTextRange(), (Iterable)QUICK_FIX_FACTORY.createCreateConstructorFromUsageFixes(constructorCall));
        if (classReference2 != null) {
            ConstructorParametersFixer.registerFixActions(classReference2, constructorCall, info, HighlightMethodUtil.getFixRange(infoElement));
            ChangeTypeArgumentsFix.registerIntentions(results, list, info, aClass);
            ConvertDoubleToFloatFix.registerIntentions(results, list, info, null);
        }
        if (!PermuteArgumentsFix.registerFix(info, (PsiCall)constructorCall, (CandidateInfo[])HighlightMethodUtil.toMethodCandidates(results), HighlightMethodUtil.getFixRange((PsiElement)list))) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions(results, list, info, null);
        }
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)constructorCall, list, info);
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)list), (IntentionAction)QUICK_FIX_FACTORY.createSurroundWithArrayFix((PsiCall)constructorCall, null));
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors, constructorCall, info);
    }

    private static HighlightInfo buildAccessProblem(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiJvmMember resolved, @NotNull JavaResolveResult result) {
        if (ref == null) {
            HighlightMethodUtil.$$$reportNull$$$0(166);
        }
        if (resolved == null) {
            HighlightMethodUtil.$$$reportNull$$$0(167);
        }
        if (result == null) {
            HighlightMethodUtil.$$$reportNull$$$0(168);
        }
        String description = HighlightUtil.accessProblemDescription((PsiElement)ref, (PsiElement)resolved, result);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).navigationShift(1).create();
        if (result.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerAccessQuickFixAction(resolved, ref, info, result.getCurrentFileResolveScope());
        }
        return info;
    }

    private static boolean callingProtectedConstructorFromDerivedClass(@NotNull PsiConstructorCall place, @NotNull PsiClass constructorClass) {
        PsiClass aClass;
        if (place == null) {
            HighlightMethodUtil.$$$reportNull$$$0(169);
        }
        if (constructorClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(170);
        }
        if (place instanceof PsiNewExpression && ((PsiNewExpression)place).getAnonymousClass() != null) {
            return false;
        }
        PsiConstructorCall curElement = place;
        PsiClass containingClass = constructorClass.getContainingClass();
        do {
            if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiClass.class)) == null) {
                return false;
            }
            curElement = aClass;
        } while (!aClass.isInheritor(constructorClass, true) && (containingClass == null || !aClass.isInheritor(containingClass, true)) || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)constructorClass));
        return true;
    }

    @NotNull
    private static String buildArgTypesList(@NotNull PsiExpressionList list) {
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(171);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        PsiExpression[] args = list.getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = args[i].getType()) != null ? JavaHighlightUtil.formatType(argType) : "?");
        }
        builder.append(")");
        String string = builder.toString();
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(172);
        }
        return string;
    }

    private static void registerChangeParameterClassFix(@NotNull PsiCall methodCall, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(173);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(174);
        }
        JavaResolveResult result = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions2 = list.getExpressions();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != expressions2.length) {
            return;
        }
        for (int i = 0; i < expressions2.length; ++i) {
            PsiExpression expression2 = expressions2[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType expressionType = expression2.getType();
            PsiType parameterType = substitutor.substitute(parameter2.getType());
            if (expressionType == null || expressionType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)expressionType) || expressionType instanceof PsiArrayType || parameterType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)parameterType) || parameterType instanceof PsiArrayType || parameterType.isAssignableFrom(expressionType)) continue;
            PsiClass parameterClass = PsiUtil.resolveClassInType((PsiType)parameterType);
            PsiClass expressionClass = PsiUtil.resolveClassInType((PsiType)expressionType);
            if (parameterClass == null || expressionClass == null || expressionClass instanceof PsiAnonymousClass || parameterClass.isInheritor(expressionClass, true)) continue;
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createChangeParameterClassFix(expressionClass, (PsiClassType)parameterType));
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntentions(JavaResolveResult @NotNull [] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, @Nullable TextRange fixRange) {
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(175);
        }
        if (candidates == null) {
            HighlightMethodUtil.$$$reportNull$$$0(176);
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntention(expressions2, highlightInfo, fixRange, candidate, (PsiElement)list);
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntention(PsiExpression @NotNull [] expressions2, @Nullable HighlightInfo highlightInfo, @Nullable TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (candidate == null) {
            HighlightMethodUtil.$$$reportNull$$$0(177);
        }
        if (context == null) {
            HighlightMethodUtil.$$$reportNull$$$0(178);
        }
        if (expressions2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(179);
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject((PsiElement)method)) {
            IntentionAction fix2 = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageFix(method, expressions2, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)fix2);
            IntentionAction f2 = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageReverseOrderFix(method, expressions2, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)f2);
        }
    }

    static PsiType determineReturnType(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(180);
        }
        PsiManager manager = method.getManager();
        PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements((PsiMethod)method);
        if (returnStatements.length == 0) {
            return PsiType.VOID;
        }
        PsiType expectedType = null;
        for (PsiReturnStatement returnStatement : returnStatements) {
            ReturnModel returnModel = ReturnModel.create(returnStatement);
            if (returnModel == null) {
                return null;
            }
            expectedType = HighlightMethodUtil.lub(expectedType, returnModel.myLeastType, returnModel.myType, method, manager);
        }
        return expectedType;
    }

    @NotNull
    private static PsiType lub(@Nullable PsiType currentType, @NotNull PsiType leastValueType, @NotNull PsiType valueType, @NotNull PsiMethod method, @NotNull PsiManager manager) {
        if (leastValueType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(181);
        }
        if (valueType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(182);
        }
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(183);
        }
        if (manager == null) {
            HighlightMethodUtil.$$$reportNull$$$0(184);
        }
        if (currentType == null || PsiType.VOID.equals((Object)currentType)) {
            PsiType psiType = valueType;
            if (psiType == null) {
                HighlightMethodUtil.$$$reportNull$$$0(185);
            }
            return psiType;
        }
        if (currentType == valueType) {
            PsiType psiType = currentType;
            if (psiType == null) {
                HighlightMethodUtil.$$$reportNull$$$0(186);
            }
            return psiType;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)valueType)) {
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)currentType)) {
                int r2;
                int r1 = TypeConversionUtil.getTypeRank((PsiType)currentType);
                PsiType psiType = r1 >= (r2 = TypeConversionUtil.getTypeRank((PsiType)leastValueType)) ? currentType : valueType;
                if (psiType == null) {
                    HighlightMethodUtil.$$$reportNull$$$0(187);
                }
                return psiType;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)currentType);
            if (valueType.equals(unboxedType)) {
                PsiType psiType = currentType;
                if (psiType == null) {
                    HighlightMethodUtil.$$$reportNull$$$0(188);
                }
                return psiType;
            }
            valueType = ((PsiPrimitiveType)valueType).getBoxedType((PsiElement)method);
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)currentType)) {
            currentType = ((PsiPrimitiveType)currentType).getBoxedType((PsiElement)method);
        }
        PsiType psiType = Objects.requireNonNull(GenericsUtil.getLeastUpperBound((PsiType)currentType, (PsiType)valueType, (PsiManager)manager));
        if (psiType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(189);
        }
        return psiType;
    }

    static HighlightInfo checkRecordAccessorDeclaration(PsiMethod method) {
        PsiRecordComponent component = JavaPsiRecordUtil.getRecordComponentForAccessor(method);
        if (component == null) {
            return null;
        }
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        PsiType componentType = component.getType();
        PsiType methodType = method.getReturnType();
        if (methodType == null) {
            return null;
        }
        if (!componentType.equals(methodType)) {
            String message2 = JavaErrorBundle.message("record.accessor.wrong.return.type", componentType.getPresentableText(), methodType.getPresentableText());
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)Objects.requireNonNull(method.getReturnTypeElement())).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, componentType, false));
            return info;
        }
        return HighlightMethodUtil.checkRecordSpecialMethodDeclaration(method, JavaErrorBundle.message("record.accessor", new Object[0]));
    }

    @NotNull
    static List<HighlightInfo> checkRecordConstructorDeclaration(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(190);
        }
        if (!method.isConstructor()) {
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                HighlightMethodUtil.$$$reportNull$$$0(191);
            }
            return list;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                HighlightMethodUtil.$$$reportNull$$$0(192);
            }
            return list;
        }
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                HighlightMethodUtil.$$$reportNull$$$0(193);
            }
            return list;
        }
        if (!aClass.isRecord()) {
            if (JavaPsiRecordUtil.isCompactConstructor(method)) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(JavaErrorBundle.message("compact.constructor.in.regular.class", new Object[0])).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddParameterListFix(method));
                List<HighlightInfo> list = Collections.singletonList(info);
                if (list == null) {
                    HighlightMethodUtil.$$$reportNull$$$0(194);
                }
                return list;
            }
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                HighlightMethodUtil.$$$reportNull$$$0(195);
            }
            return list;
        }
        if (JavaPsiRecordUtil.isExplicitCanonicalConstructor(method)) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiRecordComponent[] components = aClass.getRecordComponents();
            ArrayList<HighlightInfo> problems2 = new ArrayList<HighlightInfo>();
            assert (parameters2.length == components.length);
            for (int i = 0; i < parameters2.length; ++i) {
                HighlightInfo info;
                String message2;
                PsiType componentType = components[i].getType();
                PsiType parameterType = parameters2[i].getType();
                String componentName = components[i].getName();
                String parameterName = parameters2[i].getName();
                if (!parameterType.equals(componentType)) {
                    message2 = JavaErrorBundle.message("record.canonical.constructor.wrong.parameter.type", componentName, componentType.getPresentableText(), parameterType.getPresentableText());
                    info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)Objects.requireNonNull(parameters2[i].getTypeElement())).descriptionAndTooltip(message2).create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createMethodParameterTypeFix(method, i, componentType, false));
                    problems2.add(info);
                }
                if (componentName == null || parameterName.equals(componentName)) continue;
                message2 = JavaErrorBundle.message("record.canonical.constructor.wrong.parameter.name", componentName, parameterName);
                info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)Objects.requireNonNull(parameters2[i].getNameIdentifier())).descriptionAndTooltip(message2).create();
                if (Arrays.stream(parameters2).map(PsiParameter::getName).noneMatch(Predicate.isEqual(componentName))) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)parameters2[i], componentName));
                }
                problems2.add(info);
            }
            ContainerUtil.addIfNotNull(problems2, (Object)HighlightMethodUtil.checkRecordSpecialMethodDeclaration(method, JavaErrorBundle.message("record.canonical.constructor", new Object[0])));
            ArrayList<HighlightInfo> arrayList = problems2;
            if (arrayList == null) {
                HighlightMethodUtil.$$$reportNull$$$0(196);
            }
            return arrayList;
        }
        if (JavaPsiRecordUtil.isCompactConstructor(method)) {
            List<HighlightInfo> list = Collections.singletonList(HighlightMethodUtil.checkRecordSpecialMethodDeclaration(method, JavaErrorBundle.message("record.compact.constructor", new Object[0])));
            if (list == null) {
                HighlightMethodUtil.$$$reportNull$$$0(197);
            }
            return list;
        }
        PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
        if (call == null || JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call)) {
            String message3 = JavaErrorBundle.message("record.no.constructor.call.in.non.canonical", new Object[0]);
            List<HighlightInfo> list = Collections.singletonList(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(message3).create());
            if (list == null) {
                HighlightMethodUtil.$$$reportNull$$$0(198);
            }
            return list;
        }
        List<HighlightInfo> list = Collections.emptyList();
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(199);
        }
        return list;
    }

    @Nullable
    private static HighlightInfo checkRecordSpecialMethodDeclaration(PsiMethod method, String methodTitle) {
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        if (typeParameterList != null && typeParameterList.getTypeParameters().length > 0) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeParameterList).descriptionAndTooltip(JavaErrorBundle.message("record.special.method.type.parameters", methodTitle)).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteFix((PsiElement)typeParameterList));
            return info;
        }
        if (!method.hasModifierProperty("public")) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(JavaErrorBundle.message("record.special.method.non.public", methodTitle)).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "public", true, false));
            return info;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        if (throwsList.getReferenceElements().length > 0) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)throwsList).descriptionAndTooltip(JavaErrorBundle.message("record.special.method.throws", methodTitle)).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteFix((PsiElement)throwsList));
            return info;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 71: 
            case 72: 
            case 93: 
            case 95: 
            case 103: 
            case 105: 
            case 107: 
            case 113: 
            case 114: 
            case 116: 
            case 148: 
            case 172: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 71: 
            case 72: 
            case 93: 
            case 95: 
            case 103: 
            case 105: 
            case 107: 
            case 113: 
            case 114: 
            case 116: 
            case 148: 
            case 172: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 2: 
            case 3: 
            case 71: 
            case 72: 
            case 93: 
            case 95: 
            case 103: 
            case 105: 
            case 107: 
            case 113: 
            case 114: 
            case 116: 
            case 148: 
            case 172: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 19: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 31: 
            case 35: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignatures";
                break;
            }
            case 6: 
            case 134: 
            case 139: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 7: 
            case 18: 
            case 24: 
            case 32: 
            case 41: 
            case 120: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 133: 
            case 136: 
            case 145: 
            case 146: 
            case 180: 
            case 183: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessModifier";
                break;
            }
            case 10: 
            case 15: 
            case 25: 
            case 33: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignature";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superReturnType";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailMessage";
                break;
            }
            case 22: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 23: 
            case 45: 
            case 82: 
            case 128: 
            case 141: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutedSuperReturnType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzedClass";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignature";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedExceptions";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutorForDerivedClass";
                break;
            }
            case 43: 
            case 50: 
            case 53: 
            case 55: 
            case 57: 
            case 68: 
            case 73: 
            case 80: 
            case 88: 
            case 96: 
            case 99: 
            case 129: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 44: 
            case 51: 
            case 74: 
            case 81: 
            case 89: 
            case 98: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 46: 
            case 151: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdkVersion";
                break;
            }
            case 47: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateInfo";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mismatchedExpressions";
                break;
            }
            case 52: 
            case 58: 
            case 61: 
            case 79: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 59: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 60: 
            case 76: 
            case 77: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToMethod";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixRange";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 64: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 67: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 69: 
            case 119: 
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 70: 
            case 112: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 75: 
            case 78: 
            case 86: 
            case 97: 
            case 109: 
            case 110: 
            case 160: 
            case 171: 
            case 174: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 84: 
            case 91: 
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 90: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprList";
                break;
            }
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCandidates";
                break;
            }
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCandidate";
                break;
            }
            case 108: 
            case 157: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 111: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 115: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 124: 
            case 135: 
            case 142: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicateMethods";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 150: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolveResult";
                break;
            }
            case 153: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 158: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoElement";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorClass";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leastValueType";
                break;
            }
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClashMethodMessage";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "mismatchedArgs";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "findCandidates";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "toMethodCandidates";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "createAmbiguousMethodHtmlTooltip";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingClassName";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "createAmbiguousMethodHtmlTooltipMethodRow";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "createMismatchedArgumentsHtmlTooltip";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "mismatchedExpressionType";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixRange";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "buildArgTypesList";
                break;
            }
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "lub";
                break;
            }
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "checkRecordConstructorDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createClashMethodMessage";
                break;
            }
            case 2: 
            case 3: 
            case 71: 
            case 72: 
            case 93: 
            case 95: 
            case 103: 
            case 105: 
            case 107: 
            case 113: 
            case 114: 
            case 116: 
            case 148: 
            case 172: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodWeakerPrivileges";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWeaker";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodIncompatibleReturnType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethodSignature";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleReturnTypeMessage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodOverridesFinal";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethodIsFinal";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodIncompatibleThrows";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getExtraExceptionNum";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isMethodThrows";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCall";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleCallHighlightInfo";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createOneArgMismatchTooltip";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleTypeHighlightInfo";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "registerUsageFixes";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "registerThisSuperFixes";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "registerTargetTypeFixesBasedOnApplicabilityInference";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticInterfaceCallQualifier";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticInterfaceMethodCallQualifier";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodReturnFixAction";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "mismatchedArgs";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isDummyConstructorCall";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethodCallIdentifier";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethodCallArguments";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "findCandidates";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "toMethodCandidates";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodCallIntentions";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodAccessLevelIntentions";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "createAmbiguousMethodHtmlTooltip";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClassName";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "createAmbiguousMethodHtmlTooltipMethodRow";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "createMismatchedArgumentsHtmlTooltip";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "mismatchedExpressionType";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "assignmentCompatible";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodMustHaveBody";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "checkAbstractMethodInConcreteClass";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorName";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateMethod";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCanHaveBody";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCallProblems";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperAbstractMethodDirectCall";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCallsBaseClassConstructor";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticMethodOverride";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "checkInterfaceInheritedMethodsReturnTypes";
                break;
            }
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "checkOverrideEquivalentInheritedMethods";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorHandleSuperClassExceptions";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "checkRecursiveConstructorInvocation";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getFixRange";
                break;
            }
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "checkNewExpression";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCall";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "checkVarargParameterErasureToBeAccessible";
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "registerFixesOnInvalidConstructorCall";
                break;
            }
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "buildAccessProblem";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "callingProtectedConstructorFromDerivedClass";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "buildArgTypesList";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeParameterClassFix";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeMethodSignatureFromUsageIntentions";
                break;
            }
            case 177: 
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeMethodSignatureFromUsageIntention";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "determineReturnType";
                break;
            }
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "lub";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "checkRecordConstructorDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 71: 
            case 72: 
            case 93: 
            case 95: 
            case 103: 
            case 105: 
            case 107: 
            case 113: 
            case 114: 
            case 116: 
            case 148: 
            case 172: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReturnModel {
        final PsiReturnStatement myStatement;
        final PsiType myType;
        final PsiType myLeastType;

        @Contract(pure=true)
        private ReturnModel(@NotNull PsiReturnStatement statement, @NotNull PsiType type2) {
            if (statement == null) {
                ReturnModel.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                ReturnModel.$$$reportNull$$$0(1);
            }
            this.myStatement = statement;
            this.myType = this.myLeastType = type2;
        }

        @Contract(pure=true)
        private ReturnModel(@NotNull PsiReturnStatement statement, @NotNull PsiType type2, @NotNull PsiType leastType) {
            if (statement == null) {
                ReturnModel.$$$reportNull$$$0(2);
            }
            if (type2 == null) {
                ReturnModel.$$$reportNull$$$0(3);
            }
            if (leastType == null) {
                ReturnModel.$$$reportNull$$$0(4);
            }
            this.myStatement = statement;
            this.myType = type2;
            this.myLeastType = leastType;
        }

        @Nullable
        private static ReturnModel create(@NotNull PsiReturnStatement statement) {
            PsiExpression value2;
            if (statement == null) {
                ReturnModel.$$$reportNull$$$0(5);
            }
            if ((value2 = statement.getReturnValue()) == null) {
                return new ReturnModel(statement, (PsiType)PsiType.VOID);
            }
            if (ExpressionUtils.nonStructuralChildren(value2).anyMatch(c -> c instanceof PsiFunctionalExpression)) {
                return null;
            }
            PsiType type2 = RefactoringChangeUtil.getTypeByExpression(value2);
            if (type2 == null || type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() == null) {
                return null;
            }
            return new ReturnModel(statement, type2, ReturnModel.getLeastValueType(value2, type2));
        }

        @NotNull
        private static PsiType getLeastValueType(@NotNull PsiExpression returnValue, @NotNull PsiType type2) {
            if (returnValue == null) {
                ReturnModel.$$$reportNull$$$0(6);
            }
            if (type2 == null) {
                ReturnModel.$$$reportNull$$$0(7);
            }
            if (type2 instanceof PsiPrimitiveType) {
                int rank = TypeConversionUtil.getTypeRank((PsiType)type2);
                if (rank < 1 || rank > 4) {
                    PsiType psiType = type2;
                    if (psiType == null) {
                        ReturnModel.$$$reportNull$$$0(8);
                    }
                    return psiType;
                }
                PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance((Project)returnValue.getProject()).getConstantEvaluationHelper();
                Object res = evaluator.computeConstantExpression((PsiElement)returnValue);
                if (res instanceof Number) {
                    long value2 = ((Number)res).longValue();
                    if (-128L <= value2 && value2 <= 127L) {
                        PsiPrimitiveType psiPrimitiveType = PsiType.BYTE;
                        if (psiPrimitiveType == null) {
                            ReturnModel.$$$reportNull$$$0(9);
                        }
                        return psiPrimitiveType;
                    }
                    if (-32768L <= value2 && value2 <= 32767L) {
                        PsiPrimitiveType psiPrimitiveType = PsiType.SHORT;
                        if (psiPrimitiveType == null) {
                            ReturnModel.$$$reportNull$$$0(10);
                        }
                        return psiPrimitiveType;
                    }
                    if (0L <= value2 && value2 <= 65535L) {
                        PsiPrimitiveType psiPrimitiveType = PsiType.CHAR;
                        if (psiPrimitiveType == null) {
                            ReturnModel.$$$reportNull$$$0(11);
                        }
                        return psiPrimitiveType;
                    }
                }
            }
            PsiType psiType = type2;
            if (psiType == null) {
                ReturnModel.$$$reportNull$$$0(12);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leastType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnValue";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil$ReturnModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil$ReturnModel";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeastValueType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeastValueType";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

