/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class JavaTelescope {
    private static final int TOO_MANY_USAGES = -1;

    public static String usagesHint(@NotNull PsiMember member, @NotNull PsiFile file) {
        List<Object> things;
        if (member == null) {
            JavaTelescope.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaTelescope.$$$reportNull$$$0(1);
        }
        Project project = file.getProject();
        AtomicInteger totalUsageCount = new AtomicInteger();
        ProgressIndicator progress = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressIndicatorProvider.getGlobalProgressIndicator(), (Object)new EmptyProgressIndicator());
        List<Object> list = things = member instanceof PsiMethod ? new ArrayList(DeepestSuperMethodsSearch.search((PsiMethod)((PsiMethod)member)).findAll()) : Collections.singletonList(member);
        if (things.isEmpty()) {
            things.add(member);
        }
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(things, progress, e -> {
            int count = JavaTelescope.usagesCount(project, file, e, progress);
            int newCount = totalUsageCount.updateAndGet(old -> count == -1 ? -1 : old + count);
            return newCount != -1;
        });
        if (totalUsageCount.get() == -1 || totalUsageCount.get() == 0) {
            return null;
        }
        String format = "{0,choice, 0#no usages|1#1 usage|2#{0,number} usages}";
        return StringUtil.capitalizeWords((String)MessageFormat.format(format, totalUsageCount.get()), (boolean)true);
    }

    private static int usagesCount(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress) {
        AtomicInteger count;
        boolean ok;
        if (project == null) {
            JavaTelescope.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            JavaTelescope.$$$reportNull$$$0(3);
        }
        if (member == null) {
            JavaTelescope.$$$reportNull$$$0(4);
        }
        if (progress == null) {
            JavaTelescope.$$$reportNull$$$0(5);
        }
        if (!(ok = UnusedSymbolUtil.processUsages(project, containingFile, member, progress, null, (Processor<? super UsageInfo>)((Processor)arg_0 -> JavaTelescope.lambda$usagesCount$2(count = new AtomicInteger(), arg_0))))) {
            return -1;
        }
        return count.get();
    }

    public static int collectInheritingClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaTelescope.$$$reportNull$$$0(6);
        }
        if (aClass.hasModifierProperty("final")) {
            return 0;
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger();
        ClassInheritorsSearch.INSTANCE.createQuery((Object)new ClassInheritorsSearch.SearchParameters(aClass, aClass.getUseScope(), true, true, true)).forEach(__ -> count.incrementAndGet());
        return count.get();
    }

    public static int collectOverridingMethods(@NotNull PsiMethod method) {
        if (method == null) {
            JavaTelescope.$$$reportNull$$$0(7);
        }
        AtomicInteger count = new AtomicInteger();
        OverridingMethodsSearch.search((PsiMethod)method).forEach(__ -> count.incrementAndGet());
        return count.get();
    }

    private static /* synthetic */ boolean lambda$usagesCount$2(AtomicInteger count, UsageInfo info) {
        PsiFile psiFile = info.getFile();
        if (psiFile == null) {
            return true;
        }
        int offset = info.getNavigationOffset();
        if (offset == -1) {
            return true;
        }
        count.incrementAndGet();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaTelescope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "usagesHint";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "usagesCount";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInheritingClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "collectOverridingMethods";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

