/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class AnonymousTargetClassPreselectionUtil {
    private static final String PRESELECT_ANONYMOUS = "create.member.preselect.anonymous";

    public static void rememberSelection(PsiClass aClass, PsiClass firstClass) {
        if (firstClass instanceof PsiAnonymousClass) {
            PropertiesComponent.getInstance().setValue(PRESELECT_ANONYMOUS, aClass == firstClass);
        }
    }

    @Nullable
    public static PsiClass getPreselection(Collection<? extends PsiClass> classes2, PsiClass firstClass) {
        if (firstClass instanceof PsiAnonymousClass && !PropertiesComponent.getInstance().getBoolean(PRESELECT_ANONYMOUS, true)) {
            for (PsiClass psiClass : classes2) {
                if (psiClass instanceof PsiAnonymousClass) continue;
                return psiClass;
            }
        }
        return null;
    }
}

