/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CastMethodArgumentFix
extends MethodArgumentFix
implements HighPriorityAction {
    private final String myText;
    public static final ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private CastMethodArgumentFix(PsiExpressionList list, int i, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list, i, toType, factory);
        this.myText = this.myArgList.getExpressionCount() == 1 ? QuickFixBundle.message("cast.single.parameter.text", JavaHighlightUtil.formatType(this.myToType)) : QuickFixBundle.message("cast.parameter.text", this.myIndex + 1, JavaHighlightUtil.formatType(this.myToType));
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            CastMethodArgumentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix", "getText"));
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public CastMethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new CastMethodArgumentFix(list, i, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            PsiType exprType = expression2.getType();
            if (exprType instanceof PsiClassType && toType instanceof PsiPrimitiveType) {
                toType = ((PsiPrimitiveType)toType).getBoxedType((PsiElement)expression2);
                assert (toType != null);
            }
            return AddTypeCastFix.createCastExpression(expression2, expression2.getProject(), toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(0);
            }
            if (parameterType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(1);
            }
            if (context == null) {
                MyFixerActionFactory.$$$reportNull$$$0(2);
            }
            if (exprType instanceof PsiClassType && parameterType instanceof PsiPrimitiveType && (parameterType = ((PsiPrimitiveType)parameterType).getBoxedType(context)) == null) {
                return false;
            }
            if (exprType instanceof PsiPrimitiveType && parameterType instanceof PsiClassType) {
                if (PsiType.NULL.equals((Object)exprType)) {
                    return true;
                }
                if ((parameterType = PsiPrimitiveType.getUnboxedType((PsiType)parameterType)) == null) {
                    return false;
                }
            }
            if (parameterType.isConvertibleFrom(exprType)) {
                return true;
            }
            return parameterType instanceof PsiEllipsisType && this.areTypesConvertible(exprType, ((PsiEllipsisType)parameterType).getComponentType(), context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exprType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix$MyFixerActionFactory";
            objectArray[2] = "areTypesConvertible";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

