/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodFromUsageFix {
    private static final Logger LOG = Logger.getInstance(CreateMethodFromUsageFix.class);

    public static boolean isMethodSignatureExists(PsiMethodCallExpression call, PsiClass target) {
        PsiMethod[] methods;
        String name2 = call.getMethodExpression().getReferenceName();
        JavaResolveResult resolveResult = call.getMethodExpression().advancedResolve(false);
        PsiExpressionList list = call.getArgumentList();
        for (PsiMethod method : methods = target.findMethodsByName(name2, false)) {
            if (!PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)resolveResult.getSubstitutor(), (PsiExpressionList)list)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasErrorsInArgumentList(PsiMethodCallExpression call) {
        Project project = call.getProject();
        PsiExpressionList argumentList = call.getArgumentList();
        for (PsiExpression expression2 : argumentList.getExpressions()) {
            PsiType type2 = expression2.getType();
            if (type2 != null && !PsiType.VOID.equals((Object)type2)) continue;
            return true;
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(call.getContainingFile());
        if (document == null) {
            return true;
        }
        TextRange argRange = argumentList.getTextRange();
        return !DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, (HighlightSeverity)HighlightSeverity.ERROR, (int)(argRange.getStartOffset() + 1), (int)(argRange.getEndOffset() - 1), info -> info.getActualStartOffset() <= argRange.getStartOffset() || info.getActualEndOffset() >= argRange.getEndOffset());
    }

    public static PsiMethod createMethod(PsiClass targetClass, PsiClass parentClass, PsiMember enclosingContext, String methodName) {
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)targetClass.getProject());
        if (factory == null) {
            return null;
        }
        PsiMethod method = factory.createMethod(methodName, (PsiType)PsiType.VOID);
        if (targetClass.equals(parentClass)) {
            method = (PsiMethod)targetClass.addAfter((PsiElement)method, (PsiElement)enclosingContext);
        } else {
            PsiMember anchor;
            for (anchor = enclosingContext; anchor != null && anchor.getParent() != null && !anchor.getParent().equals(targetClass); anchor = anchor.getParent()) {
            }
            if (anchor != null && anchor.getParent() == null) {
                anchor = null;
            }
            method = anchor != null ? (PsiMethod)targetClass.addAfter((PsiElement)method, (PsiElement)anchor) : (PsiMethod)targetClass.add((PsiElement)method);
        }
        return method;
    }

    public static void doCreate(PsiClass targetClass, PsiMethod method, List<? extends Pair<PsiExpression, PsiType>> arguments, PsiSubstitutor substitutor, ExpectedTypeInfo[] expectedTypes, @Nullable PsiElement context) {
        CreateMethodFromUsageFix.doCreate(targetClass, method, CreateMethodFromUsageFix.shouldBeAbstractImpl(null, targetClass), arguments, substitutor, expectedTypes, context);
    }

    public static void doCreate(PsiClass targetClass, PsiMethod method, boolean shouldBeAbstract, List<? extends Pair<PsiExpression, PsiType>> arguments, PsiSubstitutor substitutor, ExpectedTypeInfo[] expectedTypes, @Nullable PsiElement context) {
        if ((method = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method)) == null) {
            return;
        }
        final Project project = targetClass.getProject();
        final PsiFile targetFile = targetClass.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(targetFile);
        if (document == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
        CreateFromUsageUtils.setupMethodParameters(method, (TemplateBuilder)builder, context, substitutor, arguments);
        PsiTypeElement returnTypeElement = method.getReturnTypeElement();
        if (returnTypeElement != null) {
            new GuessTypeParameters(project, (JVMElementFactory)JavaPsiFacade.getElementFactory((Project)project), (TemplateBuilder)builder, substitutor).setupTypeElement(returnTypeElement, expectedTypes, context, targetClass);
        }
        PsiCodeBlock body2 = method.getBody();
        builder.setEndVariableAfter((PsiElement)(shouldBeAbstract || body2 == null ? method : body2.getLBrace()));
        method = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        if (method == null) {
            return;
        }
        RangeMarker rangeMarker = document.createRangeMarker(method.getTextRange());
        final Editor newEditor = CreateFromUsageBaseFix.positionCursor(project, targetFile, (PsiElement)method);
        if (newEditor == null) {
            return;
        }
        Template template = builder.buildTemplate();
        newEditor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        newEditor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        rangeMarker.dispose();
        if (!shouldBeAbstract) {
            CreateFromUsageBaseFix.startTemplate(newEditor, template, project, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (brokenOff) {
                        return;
                    }
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                        PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                        int offset = newEditor.getCaretModel().getOffset();
                        PsiMethod method1 = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)(offset - 1), PsiMethod.class, (boolean)false);
                        if (method1 != null) {
                            try {
                                CreateFromUsageUtils.setupMethodBody(method1);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                            CreateFromUsageUtils.setupEditor(method1, newEditor);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix$1", "templateFinished"));
                }
            });
        } else {
            CreateFromUsageBaseFix.startTemplate(newEditor, template, project);
        }
    }

    public static boolean checkTypeParam(final PsiMethod method, PsiTypeParameter typeParameter) {
        final String typeParameterName = typeParameter.getName();
        PsiTypeVisitor<Boolean> visitor2 = new PsiTypeVisitor<Boolean>(){

            public Boolean visitClassType(@NotNull PsiClassType classType) {
                PsiClass psiClass;
                if (classType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((psiClass = classType.resolve()) instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)((PsiTypeParameter)psiClass).getOwner(), (PsiElement)method, (boolean)true)) {
                    return false;
                }
                if (Comparing.strEqual((String)typeParameterName, (String)classType.getCanonicalText())) {
                    return true;
                }
                for (PsiType p : classType.getParameters()) {
                    if (!((Boolean)p.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            public Boolean visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                if (primitiveType == null) {
                    2.$$$reportNull$$$0(1);
                }
                return false;
            }

            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    2.$$$reportNull$$$0(2);
                }
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound;
                if (wildcardType == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((bound = wildcardType.getBound()) != null) {
                    return (Boolean)bound.accept((PsiTypeVisitor)this);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "primitiveType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPrimitiveType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiTypeElement rElement = method.getReturnTypeElement();
        if (rElement != null && ((Boolean)rElement.getType().accept((PsiTypeVisitor)visitor2)).booleanValue()) {
            return true;
        }
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            PsiTypeElement element = parameter2.getTypeElement();
            if (element == null || !((Boolean)element.getType().accept((PsiTypeVisitor)visitor2)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldBeAbstractImpl(PsiReferenceExpression expression2, PsiClass targetClass) {
        return targetClass.isInterface() && (expression2 == null || !CreateFromUsageBaseFix.shouldCreateStaticMember(expression2, targetClass));
    }
}

