/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteReturnFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final SmartPsiElementPointer<PsiReturnStatement> myStatementPtr;
    private final SmartPsiElementPointer<PsiExpression> myValuePtr;
    private final boolean myIsLastStatement;
    private final boolean myHasSideEffects;

    public DeleteReturnFix(@NotNull PsiMethod method, @NotNull PsiReturnStatement returnStatement, @NotNull PsiExpression returnValue) {
        if (method == null) {
            DeleteReturnFix.$$$reportNull$$$0(0);
        }
        if (returnStatement == null) {
            DeleteReturnFix.$$$reportNull$$$0(1);
        }
        if (returnValue == null) {
            DeleteReturnFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)returnStatement);
        PsiCodeBlock codeBlock = Objects.requireNonNull(method.getBody());
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)returnStatement.getProject());
        this.myStatementPtr = manager.createSmartPsiElementPointer((PsiElement)returnStatement);
        this.myValuePtr = manager.createSmartPsiElementPointer((PsiElement)returnValue);
        this.myIsLastStatement = ControlFlowUtils.blockCompletesWithStatement(codeBlock, (PsiStatement)returnStatement);
        this.myHasSideEffects = SideEffectChecker.mayHaveSideEffects(returnValue);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String toDelete = this.myIsLastStatement ? "statement" : "value";
        String string = QuickFixBundle.message(this.myHasSideEffects ? "delete.return.fix.side.effects.text" : "delete.return.fix.text", toDelete);
        if (string == null) {
            DeleteReturnFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("delete.return.fix.family", new Object[0]);
        if (string == null) {
            DeleteReturnFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiReturnStatement returnStatement;
        if (project == null) {
            DeleteReturnFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DeleteReturnFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            DeleteReturnFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            DeleteReturnFix.$$$reportNull$$$0(8);
        }
        if ((returnStatement = (PsiReturnStatement)this.myStatementPtr.getElement()) == null) {
            return;
        }
        PsiExpression returnValue = (PsiExpression)this.myValuePtr.getElement();
        if (returnValue == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        if (this.myHasSideEffects) {
            returnValue = Objects.requireNonNull(RefactoringUtil.ensureCodeBlock(returnValue));
            returnStatement = (PsiReturnStatement)returnValue.getParent();
        }
        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(returnValue);
        sideEffects.forEach(ct::markUnchanged);
        PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, returnValue);
        if (statements.length > 0) {
            BlockUtils.addBefore((PsiStatement)returnStatement, statements);
        }
        PsiReturnStatement toDelete = this.myIsLastStatement ? returnStatement : returnValue;
        ct.deleteAndRestoreComments((PsiElement)toDelete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteReturnFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteReturnFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

