/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ImportClassFix
extends ImportClassFixBase<PsiJavaCodeReferenceElement, PsiJavaCodeReferenceElement> {
    public ImportClassFix(@NotNull PsiJavaCodeReferenceElement element) {
        if (element == null) {
            ImportClassFix.$$$reportNull$$$0(0);
        }
        super(element, element);
    }

    @Override
    protected String getReferenceName(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            ImportClassFix.$$$reportNull$$$0(1);
        }
        return reference.getReferenceName();
    }

    @Override
    protected PsiElement getReferenceNameElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            ImportClassFix.$$$reportNull$$$0(2);
        }
        return reference.getReferenceNameElement();
    }

    @Override
    protected void bindReference(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
        if (ref == null) {
            ImportClassFix.$$$reportNull$$$0(3);
        }
        if (targetClass == null) {
            ImportClassFix.$$$reportNull$$$0(4);
        }
        if (ref instanceof PsiImportStaticReferenceElement) {
            ((PsiImportStaticReferenceElement)ref).bindToTargetClass(targetClass);
        } else {
            super.bindReference(ref, targetClass);
        }
    }

    @Override
    protected boolean hasTypeParameters(@NotNull PsiJavaCodeReferenceElement reference) {
        PsiReferenceParameterList refParameters;
        if (reference == null) {
            ImportClassFix.$$$reportNull$$$0(5);
        }
        return (refParameters = reference.getParameterList()) != null && refParameters.getTypeParameterElements().length > 0;
    }

    @Override
    protected String getQualifiedName(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            ImportClassFix.$$$reportNull$$$0(6);
        }
        return reference.getQualifiedName();
    }

    @Override
    protected boolean isQualified(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            ImportClassFix.$$$reportNull$$$0(7);
        }
        return reference.isQualified();
    }

    @Override
    protected boolean hasUnresolvedImportWhichCanImport(PsiFile psiFile, String name2) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiImportStatement[] importStatements;
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiImportList importList = ((PsiJavaFile)psiFile).getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
            String className2;
            if (importStatement.resolve() != null) continue;
            if (importStatement.isOnDemand()) {
                return true;
            }
            String qualifiedName = importStatement.getQualifiedName();
            String string = className2 = qualifiedName == null ? null : ClassUtil.extractClassName((String)qualifiedName);
            if (!Comparing.strEqual((String)className2, (String)name2)) continue;
            return true;
        }
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            if (importStaticStatement.resolve() != null) continue;
            if (importStaticStatement.isOnDemand()) {
                return true;
            }
            String qualifiedName = importStaticStatement.getReferenceName();
            if (qualifiedName == null || !StringUtil.split((String)qualifiedName, (String)".").contains(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getRequiredMemberName(@NotNull PsiJavaCodeReferenceElement reference) {
        PsiElement parent;
        if (reference == null) {
            ImportClassFix.$$$reportNull$$$0(8);
        }
        if ((parent = reference.getParent()) instanceof PsiJavaCodeReferenceElement) {
            return ((PsiJavaCodeReferenceElement)parent).getReferenceName();
        }
        return super.getRequiredMemberName(reference);
    }

    @Override
    protected boolean canReferenceClass(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            ImportClassFix.$$$reportNull$$$0(9);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStatementBase.class) != null) {
            return false;
        }
        if (ref instanceof PsiReferenceExpression) {
            PsiElement parent = ref.getParent();
            return parent instanceof PsiReferenceExpression || parent instanceof PsiExpressionStatement;
        }
        return !ImportClassFix.inReturnTypeOfIncompleteGenericMethod(ref);
    }

    private static boolean inReturnTypeOfIncompleteGenericMethod(@NotNull PsiJavaCodeReferenceElement element) {
        PsiTypeElement type2;
        PsiElement prev;
        PsiTypeParameterList typeParameterList;
        if (element == null) {
            ImportClassFix.$$$reportNull$$$0(10);
        }
        if ((typeParameterList = (PsiTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)(prev = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)(type2 = (PsiTypeElement)SyntaxTraverser.psiApi().parents((Object)element).filter(PsiTypeElement.class).last()))), PsiTypeParameterList.class)) != null && typeParameterList.getParent() instanceof PsiErrorElement) {
            return Arrays.stream(typeParameterList.getTypeParameters()).anyMatch(p -> Objects.equals(element.getReferenceName(), p.getName()));
        }
        return false;
    }

    @Override
    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull PsiJavaCodeReferenceElement ref) {
        if (candidates == null) {
            ImportClassFix.$$$reportNull$$$0(11);
        }
        if (ref == null) {
            ImportClassFix.$$$reportNull$$$0(12);
        }
        if (ref instanceof PsiReferenceExpression) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ImportClassFix.$$$reportNull$$$0(13);
            }
            return list;
        }
        PsiElement typeElement = ref.getParent();
        if (typeElement instanceof PsiTypeElement) {
            PsiType type2;
            PsiExpression initializer;
            PsiElement var = typeElement.getParent();
            if (var instanceof PsiVariable && (initializer = ((PsiVariable)var).getInitializer()) != null && (type2 = initializer.getType()) != null) {
                List<PsiClass> list = ImportClassFix.filterAssignableFrom(type2, candidates);
                if (list == null) {
                    ImportClassFix.$$$reportNull$$$0(14);
                }
                return list;
            }
            if (var instanceof PsiParameter) {
                List<PsiClass> list = ImportClassFix.filterBySuperMethods((PsiParameter)var, candidates);
                if (list == null) {
                    ImportClassFix.$$$reportNull$$$0(15);
                }
                return list;
            }
        }
        List<PsiClass> list = super.filterByContext(candidates, ref);
        if (list == null) {
            ImportClassFix.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    protected boolean isAccessible(@NotNull PsiMember member, @NotNull PsiJavaCodeReferenceElement reference) {
        if (member == null) {
            ImportClassFix.$$$reportNull$$$0(17);
        }
        if (reference == null) {
            ImportClassFix.$$$reportNull$$$0(18);
        }
        return PsiUtil.isAccessible((PsiMember)member, (PsiElement)reference, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceNameElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeParameters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isQualified";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredMemberName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canReferenceClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inReturnTypeOfIncompleteGenericMethod";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterByContext";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

