/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IterateOverIterableIntention
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(IterateOverIterableIntention.class);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        TemplateImpl template;
        if (project == null) {
            IterateOverIterableIntention.$$$reportNull$$$0(0);
        }
        Object object = template = file instanceof PsiJavaFile ? IterateOverIterableIntention.getTemplate() : null;
        if (template != null) {
            int offset;
            int startOffset = offset = editor.getCaretModel().getOffset();
            if (editor.getSelectionModel().hasSelection()) {
                int selStart = editor.getSelectionModel().getSelectionStart();
                int selEnd = editor.getSelectionModel().getSelectionEnd();
                startOffset = offset == selStart ? selEnd : selStart;
            }
            PsiElement element = file.findElementAt(startOffset);
            while (element instanceof PsiWhiteSpace) {
                element = element.getPrevSibling();
            }
            PsiStatement psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
            if (psiStatement != null) {
                startOffset = psiStatement.getTextRange().getStartOffset();
            }
            if (!template.isDeactivated() && (TemplateManagerImpl.isApplicable((PsiFile)file, (int)offset, (TemplateImpl)template) || TemplateManagerImpl.isApplicable((PsiFile)file, (int)startOffset, (TemplateImpl)template))) {
                return IterateOverIterableIntention.getIterableExpression(editor, file) != null;
            }
        }
        return false;
    }

    @Nullable
    private static TemplateImpl getTemplate() {
        return TemplateSettings.getInstance().getTemplate("I", "surround");
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("iterate.iterable", new Object[0]);
        if (string == null) {
            IterateOverIterableIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static PsiExpression getIterableExpression(Editor editor, PsiFile file) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement elementAtStart = file.findElementAt(selectionModel.getSelectionStart());
            PsiElement elementAtEnd = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if ((elementAtStart == null || elementAtStart instanceof PsiWhiteSpace || elementAtStart instanceof PsiComment) && (elementAtStart = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)elementAtStart)) == null) {
                return null;
            }
            if ((elementAtEnd == null || elementAtEnd instanceof PsiWhiteSpace || elementAtEnd instanceof PsiComment) && (elementAtEnd = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elementAtEnd)) == null) {
                return null;
            }
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
            if (parent instanceof PsiExpression) {
                PsiType type2 = ((PsiExpression)parent).getType();
                return type2 instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Iterable") ? (PsiExpression)parent : null;
            }
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        while (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression().getLastChild();
        }
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class, (boolean)true)) != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiMethodCallExpression) continue;
            if (!(parent instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiType type3 = ((PsiExpression)element).getType();
            if (!(type3 instanceof PsiArrayType) && !InheritanceUtil.isInheritor((PsiType)type3, (String)"java.lang.Iterable")) continue;
            return (PsiExpression)element;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            IterateOverIterableIntention.$$$reportNull$$$0(2);
        }
        TemplateImpl template = IterateOverIterableIntention.getTemplate();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            PsiExpression iterableExpression = IterateOverIterableIntention.getIterableExpression(editor, file);
            LOG.assertTrue(iterableExpression != null);
            TextRange textRange = iterableExpression.getTextRange();
            selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        }
        new InvokeTemplateAction(template, editor, project, new HashSet()).perform();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            IterateOverIterableIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/IterateOverIterableIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/IterateOverIterableIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

