/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyStaticMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportConstantFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QualifyStaticConstantFix
extends StaticImportConstantFix {
    QualifyStaticConstantFix(@NotNull PsiFile file, @NotNull PsiJavaCodeReferenceElement referenceElement) {
        if (file == null) {
            QualifyStaticConstantFix.$$$reportNull$$$0(0);
        }
        if (referenceElement == null) {
            QualifyStaticConstantFix.$$$reportNull$$$0(1);
        }
        super(file, referenceElement);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        return "Qualify static constant access";
    }

    @Override
    @NotNull
    protected StaticImportMethodQuestionAction<PsiField> createQuestionAction(@NotNull List<? extends PsiField> fieldsToImport, final @NotNull Project project, Editor editor) {
        if (fieldsToImport == null) {
            QualifyStaticConstantFix.$$$reportNull$$$0(2);
        }
        if (project == null) {
            QualifyStaticConstantFix.$$$reportNull$$$0(3);
        }
        return new StaticImportMethodQuestionAction<PsiField>(project, editor, fieldsToImport, this.myRef){

            @Override
            @NotNull
            protected String getPopupTitle() {
                String string = QuickFixBundle.message("field.to.import.chooser.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected void doImport(PsiField toImport) {
                PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)QualifyStaticConstantFix.this.myRef.getElement();
                if (!(element instanceof PsiReferenceExpression)) {
                    return;
                }
                QualifyStaticMethodCallFix.qualifyStatically((PsiMember)toImport, project, (PsiReferenceExpression)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyStaticConstantFix$1", "getPopupTitle"));
            }
        };
    }

    @Override
    protected boolean toAddStaticImports() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldsToImport";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyStaticConstantFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createQuestionAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

