/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QualifyStaticMethodCallFix
extends StaticImportMethodFix {
    public QualifyStaticMethodCallFix(@NotNull PsiFile file, @NotNull PsiMethodCallExpression methodCallExpression) {
        if (file == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(0);
        }
        if (methodCallExpression == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(1);
        }
        super(file, methodCallExpression);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        return "Qualify static call";
    }

    @Override
    @NotNull
    protected StaticImportMethodQuestionAction<PsiMethod> createQuestionAction(@NotNull List<? extends PsiMethod> methodsToImport, final @NotNull Project project, Editor editor) {
        if (methodsToImport == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(2);
        }
        if (project == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(3);
        }
        return new StaticImportMethodQuestionAction<PsiMethod>(project, editor, methodsToImport, this.myRef){

            @Override
            protected void doImport(PsiMethod toImport) {
                PsiMethodCallExpression element = (PsiMethodCallExpression)QualifyStaticMethodCallFix.this.myRef.getElement();
                if (element == null) {
                    return;
                }
                QualifyStaticMethodCallFix.qualifyStatically((PsiMember)toImport, project, element.getMethodExpression());
            }
        };
    }

    @Override
    protected boolean toAddStaticImports() {
        return false;
    }

    static void qualifyStatically(@NotNull PsiMember toImport, @NotNull Project project, @NotNull PsiReferenceExpression qualifiedExpression) {
        PsiClass containingClass;
        if (toImport == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(4);
        }
        if (project == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(5);
        }
        if (qualifiedExpression == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(6);
        }
        if ((containingClass = toImport.getContainingClass()) == null) {
            return;
        }
        PsiReferenceExpression qualifier = JavaPsiFacade.getElementFactory((Project)project).createReferenceExpression(containingClass);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Qualify Static Access", null, () -> {
            qualifiedExpression.setQualifierExpression((PsiExpression)qualifier);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)qualifiedExpression);
        }, (PsiFile[])new PsiFile[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodsToImport";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyStaticMethodCallFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createQuestionAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifyStatically";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

