/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SideEffectWarningDialog;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoveUnusedVariableFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(RemoveUnusedVariableFix.class);
    private final PsiVariable myVariable;

    public RemoveUnusedVariableFix(PsiVariable variable) {
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        String string = CommonQuickFixBundle.message((String)"fix.remove.title.x", (Object[])new Object[]{JavaElementKind.fromElement((PsiElement)this.myVariable).object(), this.myVariable.getName()});
        if (string == null) {
            RemoveUnusedVariableFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.unused.element.family", JavaElementKind.VARIABLE.object());
        if (string == null) {
            RemoveUnusedVariableFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RemoveUnusedVariableFix.$$$reportNull$$$0(2);
        }
        return this.myVariable != null && this.myVariable.isValid() && BaseIntentionAction.canModify((PsiElement)this.myVariable);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RemoveUnusedVariableFix.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myVariable.getContainingFile())) {
            return;
        }
        this.removeVariableAndReferencingStatements(editor);
    }

    private void removeVariableAndReferencingStatements(Editor editor) {
        ArrayList<PsiVariable> references = new ArrayList<PsiVariable>();
        ArrayList sideEffects = new ArrayList();
        boolean[] canCopeWithSideEffects = new boolean[]{true};
        try {
            PsiClass context;
            Object object = context = this.myVariable instanceof PsiField ? ((PsiField)this.myVariable).getContainingClass() : PsiUtil.getVariableCodeBlock((PsiVariable)this.myVariable, null);
            if (context != null) {
                RemoveUnusedVariableUtil.collectReferences((PsiElement)context, this.myVariable, references);
            }
            references.add(this.myVariable);
            for (PsiElement psiElement : references) {
                Boolean result = RemoveUnusedVariableUtil.processUsage(psiElement, this.myVariable, sideEffects, RemoveUnusedVariableUtil.RemoveMode.CANCEL);
                if (result == null) {
                    return;
                }
                canCopeWithSideEffects[0] = canCopeWithSideEffects[0] & result;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        RemoveUnusedVariableUtil.RemoveMode deleteMode = RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, this.myVariable, editor, canCopeWithSideEffects[0]);
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                RemoveUnusedVariableUtil.deleteReferences(this.myVariable, references, deleteMode);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public static RemoveUnusedVariableUtil.RemoveMode showSideEffectsWarning(List<? extends PsiElement> sideEffects, PsiVariable variable, Editor editor, boolean canCopeWithSideEffects, @NonNls String beforeText, @NonNls String afterText) {
        if (sideEffects.isEmpty()) {
            return RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return canCopeWithSideEffects ? RemoveUnusedVariableUtil.RemoveMode.MAKE_STATEMENT : RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL;
        }
        Project project = editor.getProject();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(sideEffects);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlights(editor, elements, attributes, true, null);
        SideEffectWarningDialog dialog = new SideEffectWarningDialog(project, false, variable, beforeText, afterText, canCopeWithSideEffects);
        dialog.show();
        int code = dialog.getExitCode();
        return RemoveUnusedVariableUtil.RemoveMode.values()[code];
    }

    private static RemoveUnusedVariableUtil.RemoveMode showSideEffectsWarning(List<? extends PsiElement> sideEffects, PsiVariable variable, Editor editor, boolean canCopeWithSideEffects) {
        PsiElement sideEffect;
        String text2 = sideEffects.isEmpty() ? "" : ((sideEffect = sideEffects.get(0)) instanceof PsiExpression ? PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)sideEffect)) : sideEffect.getText());
        return RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, variable, editor, canCopeWithSideEffects, text2, text2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

